/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import tcl.lang.ArrayObject;
import tcl.lang.Command;
import tcl.lang.CommandWithDispose;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.JavaInfoCmd;
import tcl.lang.JavaInvoke;
import tcl.lang.TclException;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

public class ReflectObject
extends InternalRep
implements CommandWithDispose {
    Object javaObj;
    Class javaClass;
    Interp ownerInterp;
    String refID;
    private int useCount;
    private boolean isValid;
    Hashtable bindings;
    private static final String NULL_REP = "java0x0";
    protected static final String NOCONVERT = "-noconvert";
    protected static final String CMD_PREFIX = "java0x";
    private static final boolean debug = false;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;

    private static ReflectObject makeNullObject(Interp interp, Class clazz) {
        ReflectObject reflectObject = new ReflectObject();
        reflectObject.ownerInterp = interp;
        reflectObject.refID = NULL_REP;
        reflectObject.useCount = 1;
        reflectObject.isValid = true;
        reflectObject.javaObj = null;
        reflectObject.javaClass = clazz;
        return reflectObject;
    }

    private static void addToReflectTable(ReflectObject reflectObject) {
        Interp interp = reflectObject.ownerInterp;
        Class clazz = reflectObject.javaClass;
        Object object = reflectObject.javaObj;
        String string = reflectObject.refID;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(JavaInfoCmd.getNameFromClass(clazz));
        stringBuffer.append('.');
        stringBuffer.append(System.identityHashCode(object));
        String string2 = stringBuffer.toString();
        ReflectObject reflectObject2 = (ReflectObject)interp.reflectObjTable.get(string2);
        if (reflectObject2 == null) {
            interp.reflectObjTable.put(string2, reflectObject);
            return;
        }
        throw new TclRuntimeError("reflectObjectTable returned null for " + string);
    }

    private static void removeFromReflectTable(ReflectObject reflectObject) {
        Interp interp = reflectObject.ownerInterp;
        Class clazz = reflectObject.javaClass;
        Object object = reflectObject.javaObj;
        String string = reflectObject.refID;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(JavaInfoCmd.getNameFromClass(clazz));
        stringBuffer.append('.');
        stringBuffer.append(System.identityHashCode(object));
        String string2 = stringBuffer.toString();
        ReflectObject reflectObject2 = (ReflectObject)interp.reflectObjTable.get(string2);
        if (reflectObject2 == null) {
            throw new TclRuntimeError("reflectObjectTable returned null for " + string);
        }
        if (reflectObject2 != reflectObject) {
            throw new TclRuntimeError("reflect object did not match object in table");
        }
        interp.reflectObjTable.remove(string2);
    }

    private static ReflectObject findInReflectTable(Interp interp, Class clazz, Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(JavaInfoCmd.getNameFromClass(clazz));
        stringBuffer.append('.');
        stringBuffer.append(System.identityHashCode(object));
        String string = stringBuffer.toString();
        ReflectObject reflectObject = (ReflectObject)interp.reflectObjTable.get(string);
        if (reflectObject == null) {
            return null;
        }
        if (reflectObject.javaClass != clazz || reflectObject.javaObj != object || reflectObject.ownerInterp != interp) {
            throw new TclRuntimeError("table entry did not match arguments");
        }
        return reflectObject;
    }

    public static void dump(Interp interp) {
        try {
            Serializable serializable;
            Object object;
            Object object2;
            Object object3;
            System.out.println("BEGIN DUMP -------------------------------");
            System.out.println("interp.reflectObjCount = " + interp.reflectObjCount);
            System.out.println("interp.reflectIDTable.size() = " + interp.reflectIDTable.size());
            System.out.println("interp.reflectObjTable.size() = " + interp.reflectObjTable.size());
            System.out.println("dumping reflectIDTable");
            Enumeration enumeration = interp.reflectIDTable.keys();
            while (enumeration.hasMoreElements()) {
                Command command;
                System.out.println();
                object3 = (String)enumeration.nextElement();
                object2 = (ReflectObject)interp.reflectIDTable.get(object3);
                if (object2 == null) {
                    throw new RuntimeException("Reflect ID Table entry \"" + (String)object3 + "\" hashed to null");
                }
                if (!((String)object3).equals(((ReflectObject)object2).refID)) {
                    throw new RuntimeException("Reflect ID Table entry \"" + (String)object3 + "\" does not match object refID \"" + ((ReflectObject)object2).refID + "\"");
                }
                if (((ReflectObject)object2).ownerInterp != interp) {
                    throw new RuntimeException("roRep.ownerInterp not the same as current interp");
                }
                System.out.println("refID = \"" + ((ReflectObject)object2).refID + "\"");
                System.out.println("javaClass = \"" + JavaInfoCmd.getNameFromClass(((ReflectObject)object2).javaClass) + "\"");
                System.out.println("javaObj.hashCode() = \"" + ((ReflectObject)object2).javaObj.hashCode() + "\"");
                System.out.println("System.identityHashCode(javaObj) = \"" + System.identityHashCode(((ReflectObject)object2).javaObj) + "\"");
                object = TclString.newInstance(((ReflectObject)object2).refID);
                try {
                    serializable = ReflectObject.getClass(interp, (TclObject)object);
                }
                catch (TclException tclException) {
                    serializable = null;
                }
                if (serializable != null && ((ReflectObject)object2).javaClass != serializable) {
                    throw new RuntimeException("javaClass is not the same the reflect class type \"" + JavaInfoCmd.getNameFromClass((Class)serializable) + "\" in the interp");
                }
                System.out.println("useCount = \"" + ((ReflectObject)object2).useCount + "\"");
                System.out.println("isValid = \"" + ((ReflectObject)object2).isValid + "\"");
                try {
                    command = interp.getCommand(((ReflectObject)object2).refID);
                }
                catch (TclRuntimeError tclRuntimeError) {
                    command = null;
                }
                if (command == null) {
                    System.out.println("could not find command named \"" + ((ReflectObject)object2).refID + "\"");
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(JavaInfoCmd.getNameFromClass(((ReflectObject)object2).javaClass));
                stringBuffer.append('.');
                stringBuffer.append(System.identityHashCode(((ReflectObject)object2).javaObj));
                String string = stringBuffer.toString();
                ReflectObject reflectObject = (ReflectObject)interp.reflectObjTable.get(string);
                if (object2 == reflectObject) continue;
                throw new RuntimeException("Reflect ID table entry \"" + string + "\" did not hash to its own ReflectObject");
            }
            System.out.println();
            System.out.println("dumping reflectObjTable");
            object3 = interp.reflectObjTable.keys();
            while (object3.hasMoreElements()) {
                System.out.println();
                object2 = (String)object3.nextElement();
                object = (ReflectObject)interp.reflectObjTable.get(object2);
                if (object == null) {
                    throw new RuntimeException("Reflect table entry \"" + (String)object2 + "\" hashed to null");
                }
                if (object != interp.reflectIDTable.get(((ReflectObject)object).refID)) {
                    throw new RuntimeException("Reflect table entry \"" + (String)object2 + "\" did not hash to its own ReflectObject");
                }
                serializable = new StringBuffer();
                serializable.append(JavaInfoCmd.getNameFromClass(((ReflectObject)object).javaClass));
                serializable.append('.');
                serializable.append(System.identityHashCode(((ReflectObject)object).javaObj));
                if (!((String)object2).equals(serializable.toString())) {
                    throw new RuntimeException("ident \"" + (String)object2 + "\" is not equal to calculated" + " ident \"" + serializable.toString());
                }
                System.out.println("ident \"" + (String)object2 + "\" corresponds to ReflectObject with " + "refID \"" + ((ReflectObject)object).refID + "\"");
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.out);
            return;
        }
    }

    private static ReflectObject makeReflectObject(Interp interp, Class clazz, Object object) throws TclException {
        if (object == null) {
            return ReflectObject.makeNullObject(interp, clazz);
        }
        if (clazz == null) {
            throw new TclException(interp, "non null reflect object with null class is not valid");
        }
        if (clazz == Integer.TYPE) {
            clazz = class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = ReflectObject.class$("java.lang.Integer"));
        } else if (clazz == Boolean.TYPE) {
            clazz = class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = ReflectObject.class$("java.lang.Boolean"));
        } else if (clazz == Long.TYPE) {
            clazz = class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = ReflectObject.class$("java.lang.Long"));
        } else if (clazz == Float.TYPE) {
            clazz = class$java$lang$Float != null ? class$java$lang$Float : (class$java$lang$Float = ReflectObject.class$("java.lang.Float"));
        } else if (clazz == Double.TYPE) {
            clazz = class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = ReflectObject.class$("java.lang.Double"));
        } else if (clazz == Byte.TYPE) {
            clazz = class$java$lang$Byte != null ? class$java$lang$Byte : (class$java$lang$Byte = ReflectObject.class$("java.lang.Byte"));
        } else if (clazz == Short.TYPE) {
            clazz = class$java$lang$Short != null ? class$java$lang$Short : (class$java$lang$Short = ReflectObject.class$("java.lang.Short"));
        } else if (clazz == Character.TYPE) {
            clazz = class$java$lang$Character != null ? class$java$lang$Character : (class$java$lang$Character = ReflectObject.class$("java.lang.Character"));
        } else if (clazz == Void.TYPE) {
            throw new TclException(interp, "void object type can not be reflected");
        }
        ReflectObject reflectObject = ReflectObject.findInReflectTable(interp, clazz, object);
        if (reflectObject != null) {
            ++reflectObject.useCount;
            return reflectObject;
        }
        reflectObject = clazz.isArray() ? new ArrayObject() : new ReflectObject();
        reflectObject.ownerInterp = interp;
        reflectObject.javaObj = object;
        reflectObject.javaClass = clazz;
        Class<?> clazz2 = reflectObject.javaObj.getClass();
        if (!reflectObject.javaClass.isAssignableFrom(clazz2)) {
            throw new TclException(interp, "object of type " + JavaInfoCmd.getNameFromClass(clazz2) + " can not be referenced as type " + JavaInfoCmd.getNameFromClass(reflectObject.javaClass));
        }
        ++interp.reflectObjCount;
        reflectObject.refID = CMD_PREFIX + Long.toHexString(interp.reflectObjCount);
        interp.createCommand(reflectObject.refID, (Command)reflectObject);
        interp.reflectIDTable.put(reflectObject.refID, reflectObject);
        ReflectObject.addToReflectTable(reflectObject);
        reflectObject.useCount = 1;
        reflectObject.isValid = true;
        return reflectObject;
    }

    protected void dispose() {
        --this.useCount;
        if (this.useCount == 0 && this.refID != NULL_REP) {
            this.ownerInterp.deleteCommand(this.refID);
            this.ownerInterp.reflectIDTable.remove(this.refID);
            ReflectObject.removeFromReflectTable(this);
            this.ownerInterp = null;
            this.javaObj = null;
            this.javaClass = null;
            this.bindings = null;
            this.refID = NULL_REP;
        }
    }

    protected InternalRep duplicate() {
        ++this.useCount;
        return this;
    }

    private static void setReflectObjectFromAny(Interp interp, TclObject tclObject) throws TclException {
        String string;
        ReflectObject reflectObject;
        InternalRep internalRep = tclObject.getInternalRep();
        if (internalRep instanceof ReflectObject) {
            reflectObject = (ReflectObject)internalRep;
            if (reflectObject.isValid && reflectObject.ownerInterp == interp) {
                return;
            }
        }
        if ((string = tclObject.toString()).startsWith(CMD_PREFIX)) {
            if (string.equals(NULL_REP)) {
                tclObject.setInternalRep(ReflectObject.makeReflectObject(interp, null, null));
                return;
            }
            reflectObject = (ReflectObject)interp.reflectIDTable.get(string);
            if (reflectObject != null && reflectObject.isValid) {
                ++reflectObject.useCount;
                tclObject.setInternalRep(reflectObject);
                return;
            }
        }
        throw new TclException(interp, "unknown java object \"" + tclObject + "\"");
    }

    public static TclObject newInstance(Interp interp, Class clazz, Object object) throws TclException {
        return new TclObject(ReflectObject.makeReflectObject(interp, clazz, object));
    }

    public static Object get(Interp interp, TclObject tclObject) throws TclException {
        ReflectObject.setReflectObjectFromAny(interp, tclObject);
        ReflectObject reflectObject = (ReflectObject)tclObject.getInternalRep();
        return reflectObject.javaObj;
    }

    public static Class getClass(Interp interp, TclObject tclObject) throws TclException {
        ReflectObject.setReflectObjectFromAny(interp, tclObject);
        ReflectObject reflectObject = (ReflectObject)tclObject.getInternalRep();
        return reflectObject.javaClass;
    }

    static ReflectObject getReflectObject(Interp interp, TclObject tclObject) throws TclException {
        ReflectObject.setReflectObjectFromAny(interp, tclObject);
        return (ReflectObject)tclObject.getInternalRep();
    }

    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        int n;
        boolean bl;
        if (!this.isValid) {
            throw new TclException(interp, "reflected object is no longer valid");
        }
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "?-noconvert? signature ?arg arg ...?");
        }
        String string = tclObjectArray[1].toString();
        if (string.length() >= 2 && NOCONVERT.startsWith(string)) {
            bl = false;
            n = 2;
        } else {
            bl = true;
            n = 1;
        }
        if (tclObjectArray.length < n + 1) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "?-noconvert? signature ?arg arg ...?");
        }
        int n2 = n + 1;
        int n3 = tclObjectArray.length - n2;
        interp.setResult(JavaInvoke.callMethod(interp, new TclObject(this), tclObjectArray[n], tclObjectArray, n2, n3, bl));
    }

    public void disposeCmd() {
        this.isValid = false;
    }

    public String toString() {
        return this.refID;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

