/*
 * ListCmd.java
 *
 * Copyright (c) 1997 Cornell University.
 * Copyright (c) 1997 Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and
 * redistribution of this file, and for a DISCLAIMER OF ALL
 * WARRANTIES.
 * 
 * SCCS: @(#) ListCmd.java 1.6 97/07/21 16:53:45
 *
 */

package tcl.lang;

/**
 * This class implements the built-in "list" command in Tcl.
 */
class ListCmd implements Command {

    /**
     * See Tcl user documentation for details.
     */
    public void cmdProc(Interp interp, TclObject argv[])
	    throws TclException {
	TclObject list = TclList.newInstance();

	list.preserve();
	try {
	    for (int i = 1; i<argv.length; i++) {
		TclList.append(interp, list, argv[i]);
	    }
	    interp.setResult(list);
	} finally {
	    list.release();
	}
    }
}

