/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.TclToken;

class TclParse {
    char[] string;
    int endIndex;
    int commentStart;
    int commentSize;
    int commandStart;
    int commandSize;
    int numWords;
    TclToken[] tokenList;
    int numTokens;
    int tokensAvailable;
    Interp interp;
    String fileName;
    int lineNum;
    int termIndex;
    boolean incomplete;
    int result;
    private static final int INITIAL_NUM_TOKENS = 20;
    private static final int MAX_CACHED_TOKENS = 50;

    TclParse(Interp interp, char[] string, int endIndex, String fileName, int lineNum) {
        this.interp = interp;
        this.string = string;
        this.endIndex = endIndex;
        this.fileName = fileName;
        this.lineNum = lineNum;
        this.tokenList = new TclToken[20];
        this.tokensAvailable = 20;
        this.numTokens = 0;
        this.numWords = 0;
        this.commentStart = -1;
        this.commentSize = 0;
        this.commandStart = -1;
        this.commandSize = 0;
        this.incomplete = false;
    }

    TclToken getToken(int index) {
        if (index >= this.tokensAvailable) {
            this.expandTokenArray(index);
        }
        if (this.tokenList[index] == null) {
            this.tokenList[index] = this.grabToken();
        }
        return this.tokenList[index];
    }

    void release() {
        int index = 0;
        while (index < this.tokensAvailable) {
            if (this.tokenList[index] != null) {
                this.releaseToken(this.tokenList[index]);
                this.tokenList[index] = null;
            }
            ++index;
        }
    }

    static void init(Interp interp) {
        TclToken[] TOKEN_CACHE = new TclToken[50];
        int i = 0;
        while (i < 50) {
            TOKEN_CACHE[i] = new TclToken();
            ++i;
        }
        interp.parserTokens = TOKEN_CACHE;
        interp.parserTokensUsed = 0;
    }

    private TclToken grabToken() {
        if (this.interp == null || this.interp.parserTokensUsed == 50) {
            return new TclToken();
        }
        return this.interp.parserTokens[this.interp.parserTokensUsed++];
    }

    private void releaseToken(TclToken token) {
        if (this.interp != null && this.interp.parserTokensUsed > 0) {
            --this.interp.parserTokensUsed;
            this.interp.parserTokens[this.interp.parserTokensUsed] = token;
        }
    }

    void expandTokenArray(int needed) {
        while (needed >= this.tokensAvailable) {
            this.tokensAvailable *= 2;
        }
        TclToken[] newList = new TclToken[this.tokensAvailable];
        System.arraycopy(this.tokenList, 0, newList, 0, this.tokenList.length);
        this.tokenList = newList;
    }

    public String toString() {
        return this.get().toString();
    }

    TclObject get() {
        TclObject obj = TclList.newInstance();
        try {
            if (this.commentSize > 0) {
                TclList.append(this.interp, obj, TclString.newInstance((String)new String(this.string, this.commentStart, this.commentSize)));
            } else {
                TclList.append(this.interp, obj, TclString.newInstance((String)"-"));
            }
            if (this.commandStart >= this.endIndex + 1) {
                this.commandStart = this.endIndex;
            }
            String cmd = new String(this.string, this.commandStart, this.commandSize);
            TclList.append(this.interp, obj, TclString.newInstance((String)cmd));
            TclList.append(this.interp, obj, TclInteger.newInstance((int)this.numWords));
            int i = 0;
            while (i < this.numTokens) {
                String typeString;
                TclToken token = this.tokenList[i];
                switch (token.type) {
                    case 1: {
                        typeString = "word";
                        break;
                    }
                    case 2: {
                        typeString = "simple";
                        break;
                    }
                    case 4: {
                        typeString = "text";
                        break;
                    }
                    case 8: {
                        typeString = "backslash";
                        break;
                    }
                    case 16: {
                        typeString = "command";
                        break;
                    }
                    case 32: {
                        typeString = "variable";
                        break;
                    }
                    default: {
                        typeString = "??";
                    }
                }
                TclList.append(this.interp, obj, TclString.newInstance((String)typeString));
                TclList.append(this.interp, obj, TclString.newInstance((String)token.getTokenString()));
                TclList.append(this.interp, obj, TclInteger.newInstance((int)token.numComponents));
                ++i;
            }
            int nextIndex = this.commandStart + this.commandSize;
            TclList.append(this.interp, obj, TclString.newInstance((String)new String(this.string, nextIndex, this.endIndex - nextIndex)));
        }
        catch (TclException tclException) {}
        return obj;
    }
}

