/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import tcl.lang.Channel;
import tcl.lang.FileUtil;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclPosixException;
import tcl.lang.TclRuntimeError;

class FileChannel
extends Channel {
    private RandomAccessFile file;
    private static final int BUF_SIZE = 1024;
    private boolean eofCond = false;

    FileChannel() {
    }

    String open(Interp interp, String fileName, int modeFlags) throws IOException, TclException {
        this.mode = modeFlags;
        File fileObj = FileUtil.getNewFileObj(interp, fileName);
        if ((modeFlags & 0x10) != 0 && !fileObj.exists()) {
            this.file = new RandomAccessFile(fileObj, "rw");
            this.file.close();
        }
        if ((modeFlags & 4) != 0) {
            this.checkFileExists(interp, fileObj);
            this.checkReadWritePerm(interp, fileObj, 0);
            if (fileObj.isDirectory()) {
                throw new TclException(interp, "couldn't open \"" + fileName + "\": illegal operation on a directory");
            }
            this.file = new RandomAccessFile(fileObj, "rw");
        } else if ((modeFlags & 1) != 0) {
            this.checkFileExists(interp, fileObj);
            this.checkReadWritePerm(interp, fileObj, -1);
            if (fileObj.isDirectory()) {
                throw new TclException(interp, "couldn't open \"" + fileName + "\": illegal operation on a directory");
            }
            this.file = new RandomAccessFile(fileObj, "r");
        } else if ((modeFlags & 2) != 0) {
            this.checkFileExists(interp, fileObj);
            this.checkReadWritePerm(interp, fileObj, 1);
            if (fileObj.isDirectory()) {
                throw new TclException(interp, "couldn't open \"" + fileName + "\": illegal operation on a directory");
            }
            if (!fileObj.canRead()) {
                throw new TclException(interp, "Java IO limitation: Cannot open a file that has only write permissions set.");
            }
            this.file = new RandomAccessFile(fileObj, "rw");
        } else {
            throw new TclRuntimeError("FileChannel.java: invalid mode value");
        }
        if ((modeFlags & 8) != 0) {
            this.file.seek(this.file.length());
        }
        String fName = "file" + this.getNextFileNum(interp);
        this.setChanName(fName);
        return fName;
    }

    String read(Interp interp, int readType, int numBytes) throws IOException, TclException {
        if (this.file == null) {
            throw new TclRuntimeError("FileChannel.read: null file object");
        }
        if ((this.mode & 2) != 0) {
            throw new TclException(interp, "channel" + this.getChanName() + "\"wasn't opened for reading");
        }
        switch (readType) {
            case 1: {
                int bytesRead = 0;
                long fileSize = this.file.length();
                byte[] byteArr = new byte[1024];
                StringBuffer sbuf = new StringBuffer((int)fileSize);
                while (fileSize - (long)bytesRead > 1024L) {
                    bytesRead += this.file.read(byteArr);
                    sbuf.append(byteArr);
                }
                bytesRead = this.file.read(byteArr);
                if (bytesRead == -1) {
                    return "";
                }
                sbuf.append(new String(byteArr, 0, bytesRead));
                this.eofCond = true;
                return sbuf.toString();
            }
            case 2: {
                int byteRead = 0;
                StringBuffer sbuf = new StringBuffer();
                this.eofCond = false;
                try {
                    char ch;
                    while ((ch = (char)this.file.readByte()) != '\uffffffff') {
                        if (ch != '\n' && ch != '\r') {
                            sbuf.append(ch);
                            ++byteRead;
                            continue;
                        }
                        break;
                    }
                }
                catch (EOFException eOFException) {
                    this.eofCond = true;
                }
                return sbuf.toString();
            }
            case 3: {
                byte[] byteArr = new byte[numBytes];
                int bytesRead = this.file.read(byteArr);
                if (bytesRead == -1) {
                    this.eofCond = true;
                    return "";
                }
                this.eofCond = false;
                return new String(byteArr);
            }
        }
        throw new TclRuntimeError("FileChannel.read(): Incorrect read mode.");
    }

    void write(Interp interp, String s) throws IOException, TclException {
        if (this.file == null) {
            throw new TclRuntimeError("FileChannel.write(): null file object");
        }
        if ((this.mode & 1) != 0) {
            throw new TclException(interp, "channel \"" + this.getChanName() + "\" wasn't opened for writing");
        }
        this.file.writeBytes(s);
    }

    void close() throws IOException {
        if (this.file == null) {
            throw new TclRuntimeError("FileChannel.close(): null file object");
        }
        this.file.close();
    }

    void flush(Interp interp) throws IOException, TclException {
        if (this.file == null) {
            throw new TclRuntimeError("FileChannel.seek(): null file object");
        }
    }

    void seek(long offset, int mode) throws IOException {
        if (this.file == null) {
            throw new TclRuntimeError("FileChannel.seek(): null file object");
        }
        switch (mode) {
            case 1: {
                this.file.seek(offset);
                break;
            }
            case 2: {
                this.file.seek(this.file.getFilePointer() + offset);
                break;
            }
            case 3: {
                this.file.seek(this.file.length() + offset);
                break;
            }
        }
    }

    long tell() throws IOException {
        if (this.file == null) {
            throw new TclRuntimeError("FileChannel.tell(): null file object");
        }
        return this.file.getFilePointer();
    }

    boolean eof() {
        return this.eofCond;
    }

    private void checkFileExists(Interp interp, File fileObj) throws TclException {
        if (!fileObj.exists()) {
            throw new TclPosixException(interp, 2, true, "couldn't open \"" + fileObj.getName() + "\"");
        }
    }

    private void checkReadWritePerm(Interp interp, File fileObj, int mode) throws TclException {
        boolean error = false;
        if (mode <= 0 && !fileObj.canRead()) {
            error = true;
        }
        if (mode >= 0 && !fileObj.canWrite()) {
            error = true;
        }
        if (error) {
            throw new TclPosixException(interp, 13, true, "couldn't open \"" + fileObj.getName() + "\"");
        }
    }

    private int getNextFileNum(Interp interp) {
        Hashtable htbl = TclIO.getInterpChanTable(interp);
        int i = 0;
        while (htbl.get("file" + i) != null) {
            ++i;
        }
        return i;
    }
}

