[comment {-*- tcl -*- doctools manpage}]
[manpage_begin ftpd n 1.1.2]
[moddesc   {Tcl FTP Server Package}]
[titledesc {Tcl FTP server implementation}]
[require Tcl 8.3]
[require ftpd [opt 1.1.2]]
[description]

The [package ftpd] package provides a simple Tcl-only server library
for the FTP protocol.  It works by listening on the standard FTP
socket.  Most server errors are returned as error messages with the
appropriate code attached to them.  Since the server code for the ftp
daemon is executed in the event loop, it is possible that a

[cmd bgerror] will be thrown on the server if there are problems with
the code in the module.

[section COMMANDS]

[list_begin definitions]

[call [cmd ::ftpd::server] [opt [arg myaddr]]]

Open a listening socket to listen to and accept ftp connections.
myaddr is an optional argument.  [arg myaddr] is the domain-style name
or numerical IP address of the client-side network interface to use
for the connection.

[call [cmd ::ftpd::config] [opt [arg {option value}]] [opt [arg {option value ...}]]]

The value is always the name of the command to call as the
callback. The option specifies which callback should be configured.
See section [sectref CALLBACKS] for descriptions of the arguments and
return values for each of the callbacks.

[list_begin definitions]

[lst_item "-authIpCmd [arg proc]"]

Callback to authenticate new connections based on the ip-address of
the peer.

[lst_item "-authUsrCmd [arg proc]"]

Callback to authenticate new connections based on the user logging in
(and the users password).

[lst_item "-authFileCmd [arg proc]"]

Callback to accept or deny a users access to read and write to a
specific path or file.

[lst_item "-logCmd [arg proc]"]

Callback for log information generated by the FTP engine.

[lst_item "-fsCmd [arg proc]"]

Callback to connect the engine to the filesystem it operates on.

[list_end]
[list_end]

[section CALLBACKS]

[list_begin definitions]

[lst_item [strong {authIpCmd callback}]]

The authIpCmd receives the ip-address of the peer attempting to
connect to the ftp server as its argument. It returns a 1 to allow
users from the specified IP to attempt to login and a 0 to reject the
login attempt from the specified IP.

[lst_item [strong {authUsrCmd callback}]]

The authUsrCmd receives the username and password as its two
arguments. It returns a 1 to accept the attempted login to the ftpd
and a 0 to reject the attempted login.

[lst_item [strong {authFileCmd callback}]]

The authFileCmd receives the user (that is currently logged in), the
path or filename that is about to be read or written, and

[strong read] or [strong write] as its three arguments.  It returns a
1 to allow the path or filename to be read or written, and a 0 to
reject the attempted read or write with a permissions error code.

[lst_item [strong {logCmd callback}]]

The logCmd receives a severity and a message as its two arguments.
The severities used within the ftpd package are [strong note],

[strong debug], and [strong error]. The logCmd doesn't return
anything.

[lst_item [strong {fsCmd callback}]]

The fsCmd receives a subcommand, a filename or path, and optional
additional arguments (depending on the subcommand).

[nl]
The subcommands supported by the fsCmd are:

[list_begin definitions]

[call [arg fsCmd] [method append] [arg path]]

The append subcommand receives the filename to append to as its
argument. It returns a writable tcl channel as its return value.

[call [arg fsCmd] [method delete] [arg path] [arg channel]]

The delete subcommand receives the filename to delete, and a channel
to write to as its two arguments.  The file specified is deleted and
the appropriate ftp message is written to the channel that is passed
as the second argument.  The delete subcommand returns nothing.

[call [arg fsCmd] [method dlist] [arg path] [arg style] [arg channel]]

The dlist subcommand receives the path that it should list the files
that are in, the style in which the files should be listed which is
either [strong nlst] or [strong list], and a channel to write to as
its three arguments.  The files in the specified path are printed to
the specified channel one per line.  If the style is [strong nlst]
only the name of the file is printed to the channel.  If the style is
[strong list] then the file permissions, number of links to the file,
the name of the user that owns the file, the name of the group that
owns the file, the size (in bytes) of the file, the modify time of the
file, and the filename are printed out to the channel in a formatted
space separated format.  The [method dlist] subcommand returns
nothing.

[call [arg fsCmd] [method exists] [arg path]]

The exists subcommand receives the name of a file to check the
existence of as its only argument.  The exists subcommand returns a 1
if the path specified exists and the path is not a directory.

[call [arg fsCmd] [method mkdir] [arg path] [arg channel]]

The mkdir subcommand receives the path of a directory to create and a
channel to write to as its two arguments.  The mkdir subcommand
creates the specified directory if necessary and possible.  The mkdir
subcommand then prints the appropriate success or failure message to
the channel.  The mkdir subcommand returns nothing.

[call [arg fsCmd] [method mtime] [arg path] [arg channel]]

The mtime subcommand receives the path of a file to check the modify
time on and a channel as its two arguments.  If the file exists the
mtime is printed to the channel in the proper FTP format, otherwise an
appropriate error message and code are printed to the channel.  The
mtime subcommand returns nothing.

[call [arg fsCmd] [method permissions] [arg path]]

The permissions subcommand receives the path of a file to retrieve the
permissions of.  The permissions subcommand returns the octal file
permissions of the specified file.  The file is expected to exist.

[call [arg fsCmd] [method rename] [arg path] [arg newpath] [arg channel]]

The rename subcommand receives the path of the current file, the new
file path, and a channel to write to as its three arguments.  The
rename subcommand renames the current file to the new file path if the
path to the new file exists, and then prints out the appropriate
message to the channel.  If the new file path doesn't exist the
appropriate error message is printed to the channel.  The rename
subcommand returns nothing.

[call [arg fsCmd] [method retr] [arg path]]

The retr subcommand receives the path of a file to read as its only
argument.  The retr subcommand returns a readable channel that the
specified file can be read from.

[call [arg fsCmd] [method rmdir] [arg path] [arg channel]]

The rmdir subcommand receives the path of a directory to remove and a
channel to write to as its two arguments.  The rmdir subcommand
removes the specified directory (if possible) and prints the
appropriate message to the channel (which may be an error if the
specified directory does not exist or is not empty).  The rmdir
subcommand returns nothing.

[call [arg fsCmd] [method size] [arg path] [arg channel]]

The size subcommand receives the path of a file to get the size (in
bytes) of and a channel to write to as its two arguments.  The size
subcommand prints the appropriate code and the size of the file if the
specified path is a file, otherwise an appropriate error code and
message are printed to the channel.  The size subcommand returns
nothing.

[call [arg fsCmd] [method store] [arg path]]

The store subcommand receives the path of a file to write as its only
argument.  The store subcommand returns a writable channel.

[list_end]
[list_end]

[section VARIABLES]

[list_begin definitions]

[lst_item [var ::ftpd::cwd]]

The current working directory for a session when someone first
connects to the FTPD or when the [cmd REIN] ftp command is received.

[lst_item [var ::ftpd::contact]]

The e-mail address of the person that is the contact for the ftp
server.  This address is printed out as part of the response to the
[cmd {FTP HELP}] command.

[lst_item [var ::ftpd::port]]

The port that the ftp server should listen on.

[lst_item [var ::ftpd::welcome]]

The message that is printed out when the user first connects to the
ftp server.


[list_end]

[keywords ftpd ftp ftpserver services {rfc 959}]
[manpage_end]
