'\"
'\" Generated from ../tcllib/modules/uri/uri.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "uri" n 1.1.1 uri "Tcl Uniform Resource Identifier Management"
.BS
.SH NAME
uri \- URI utilities
.SH "SYNOPSIS"
package require \fBTcl 8.2\fR
.sp
package require \fBuri ?1.1.1?\fR
.sp
\fBuri::split\fR \fIurl\fR\fR
.sp
\fBuri::join\fR ?\fIkey\fR \fIvalue\fR?...\fR
.sp
\fBuri::resolve\fR \fIbase\fR \fIurl\fR\fR
.sp
\fBuri::isrelative\fR \fIurl\fR\fR
.sp
\fBuri::geturl\fR \fIurl\fR ?\fIoptions\fR...?\fR
.sp
\fBuri::canonicalize\fR \fIuri\fR\fR
.sp
\fBuri::register\fR \fIschemeList\fR \fIscript\fR\fR
.sp
.BE
.SH "DESCRIPTION"
This package contains two parts. First it provides regular expressions
for a number of url/uri schemes. Second it provides a number of
commands for manipulating urls/uris and fetching data specified by
them. For the latter this package analyses the requested url/uri and
then dispatches it to the appropriate package (http, ftp, ...) for
actual fetching.
.SH "COMMANDS"
.TP
\fBuri::split\fR \fIurl\fR\fR
\fBuri::split\fR takes a single \fIurl\fR, decodes it and then returns
a list of key/value pairs suitable for \fBarray set\fR containing
the constituents of the \fIurl\fR. If the scheme is missing from the
url it defaults to \fBhttp\fR. Currently only the schemes
\fBhttp\fR, \fBftp\fR, \fBmailto\fR, \fBurn\fR and
\fBfile\fR are supported. See section \fBEXTENDING\fR on how to
expand that range.
.TP
\fBuri::join\fR ?\fIkey\fR \fIvalue\fR?...\fR
\fBuri::join\fR takes a list of key/value pairs (generated by
\fBuri::split\fR, for example) and returns the canonical url they
represent. Currently only the schemes \fBhttp\fR, \fBftp\fR,
\fBmailto\fR, \fBurn\fR and \fBfile\fR are supported. See
section \fBEXTENDING\fR on how to expand that range.
.TP
\fBuri::resolve\fR \fIbase\fR \fIurl\fR\fR
\fBuri::resolve\fR resolves the specified \fIurl\fR relative to
\fIbase\fR. In other words: A non-relative \fIurl\fR is returned
unchanged, whereas for a relative \fIurl\fR the missing parts are
taken from \fIbase\fR and prepended to it. The result of this
operation is returned. For an empty \fIurl\fR the result is
\fIbase\fR.
.TP
\fBuri::isrelative\fR \fIurl\fR\fR
\fBuri::isrelative\fR determines whether the specified \fIurl\fR is
absolute or relative.
.TP
\fBuri::geturl\fR \fIurl\fR ?\fIoptions\fR...?\fR
\fBuri::geturl\fR decodes the specified \fIurl\fR and then dispatches
the request to the package appropriate for the scheme found in the
url. The command assumes that the package to handle the given scheme
either has the same name as the scheme itself (including possible
capitalization) followed by \fB::geturl\fR, or, in case of this
failing, has the same name as the scheme itself (including possible
capitalization). It further assumes that whatever package was loaded
provides a \fBgeturl\fR-command in the namespace of the same name as
the package itself. This command is called with the given \fIurl\fR
and all given \fIoptions\fR. Currently \fBgeturl\fR does not handle
any options itself.
.sp
\fBNote:\fR \fBfile\fR-urls are an exception to the rule
described above. They are handled internally.
.sp
It is not possible to specify results of the command. They depend on
the \fBgeturl\fR-command for the scheme the request was dispatched to.
.TP
\fBuri::canonicalize\fR \fIuri\fR\fR
\fBuri::canonicalize\fR returns the canonical form of a URI.  The
canonical form of a URI is one where relative path specifications,
ie. . and .., have been resolved.
.TP
\fBuri::register\fR \fIschemeList\fR \fIscript\fR\fR
\fBuri::register\fR registers the first element of \fIschemeList\fR as
a new scheme and the remaining elements as aliases for this scheme. It
creates the namespace for the scheme and executes the \fIscript\fR in
the new namespace. The script has to declare variables containing the
regular expressions relevant to the scheme. At least the variable
\fBschemepart\fR has to be declared as that one is used to extend
the variables keeping track of the registered schemes.
.SH "SCHEMES"
In addition to the commands mentioned above this package provides
regular expression to recognize urls for a number of url schemes.
.PP
For each supported scheme a namespace of the same name as the scheme
itself is provided inside of the namespace \fBuri\fR containing the
variable \fBurl\fR whose contents are a regular expression to
recognize urls of that scheme. Additional variables may contain
regular expressions for parts of urls for that scheme.
.PP
The variable \fBuri::schemes\fR contains a list of all supported
schemes. Currently these are \fBftp\fR, \fBfile\fR,
\fBhttp\fR, \fBgopher\fR, \fBmailto\fR, \fBnews\fR,
\fBwais\fR and \fBprospero\fR.
.SH "EXTENDING"
Extending the range of schemes supported by \fBuri::split\fR and
\fBuri::join\fR is easy because both commands do not handle the
request by themselves but dispatch it to another command in the
\fBuri\fR namespace using the scheme of the url as criterion.
.PP
\fBuri::split\fR and \fBuri::join\fR
call \fBSplit[string totitle <scheme>]\fR
and  \fBJoin[string totitle <scheme>]\fR respectively.
.SH "CREDITS"
.PP
Original code by Andreas Kupries.
Modularisation by Steve Ball.
.SH "KEYWORDS"
uri, url, fetching information, www, http, ftp, mailto, gopher, wais, prospero, file
