'\"
'\" Generated from ../tcllib/modules/struct/queue.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "queue" n 1.2.1 struct "Tcl Data Structures"
.BS
.SH NAME
queue \- Create and manipulate queue objects
.SH "SYNOPSIS"
package require \fBTcl 8.2\fR
.sp
package require \fBstruct ?1.2.1?\fR
.sp
\fIqueueName\fR \fBoption\fR ?\fIarg arg ...\fR?\fR
.sp
\fIqueueName\fR \fBclear\fR\fR
.sp
\fIqueueName\fR \fBdestroy\fR\fR
.sp
\fIqueueName\fR \fBget\fR ?\fIcount\fR?\fR
.sp
\fIqueueName\fR \fBpeek\fR ?\fIcount\fR?\fR
.sp
\fIqueueName\fR \fBput\fR \fIitem\fR ?\fIitem ...\fR?\fR
.sp
\fIqueueName\fR \fBsize\fR\fR
.sp
.BE
.SH "DESCRIPTION"
The \fB::struct::queue\fR command creates a new queue object with an
associated global Tcl command whose name is \fIqueueName\fR.  This
command may be used to invoke various operations on the queue.  It has
the following general form:
.TP
\fIqueueName\fR \fBoption\fR ?\fIarg arg ...\fR?\fR
\fIOption\fR and the \fIarg\fRs determine the exact behavior of the
command.  The following commands are possible for queue objects:
.TP
\fIqueueName\fR \fBclear\fR\fR
Remove all items from the queue.
.TP
\fIqueueName\fR \fBdestroy\fR\fR
Destroy the queue, including its storage space and associated command.
.TP
\fIqueueName\fR \fBget\fR ?\fIcount\fR?\fR
Return the front \fIcount\fR items of the queue and remove them from
the queue.  If \fIcount\fR is not specified, it defaults to 1.  If
\fIcount\fR is 1, the result is a simple string; otherwise, it is a
list.  If specified, \fIcount\fR must be greater than or equal to 1.
If there are no items in the queue, this command will return
\fIcount\fR empty strings.
.TP
\fIqueueName\fR \fBpeek\fR ?\fIcount\fR?\fR
Return the front \fIcount\fR items of the queue, without removing them
from the queue.  If \fIcount\fR is not specified, it defaults to 1.
If \fIcount\fR is 1, the result is a simple string; otherwise, it is a
list.  If specified, \fIcount\fR must be greater than or equal to 1.
If there are no items in the queue, this command will return
\fIcount\fR empty strings.
.TP
\fIqueueName\fR \fBput\fR \fIitem\fR ?\fIitem ...\fR?\fR
Put the \fIitem\fR or items specified into the queue.  If more than
one \fIitem\fR is given, they will be added in the order they are
listed.
.TP
\fIqueueName\fR \fBsize\fR\fR
Return the number of items in the queue.
.SH "KEYWORDS"
stack, matrix, tree, graph
