'\"
'\" Generated from ../tcllib/modules/base64/yencode.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "yencode" n 1.0 base64 "encode/decoding a binary file"
.BS
.SH NAME
yencode \- encode/decoding a binary file
.SH "SYNOPSIS"
package require \fBTcl 8\fR
.sp
package require \fByencode ?1.0?\fR
.sp
\fB::yencode::encode\fR \fIstring\fR\fR
.sp
\fB::yencode::decode\fR \fIstring\fR\fR
.sp
\fB::yencode::yencode\fR ?-name \fIstring\fR? ?-line \fIinteger\fR? ?-crc32 \fIboolean\fR? (-file \fIfilename\fR | ?--? \fIstring\fR)\fR
.sp
\fB::yencode::ydecode\fR (-file \fIfilename\fR | ?--? \fIstring\fR)\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
This package provides a Tcl-only implementation of the yEnc file
encoding. This is a recently introduced method of encoding binary
files for transmission through usenet. This encoding packs binary data
into a format that requires an 8-bit clean transmission layer but that
escapes characters special to the NNTP posting protocols. See
\fIhttp://www.yenc.org/\fR for details concerning the algorithm.
.TP
\fB::yencode::encode\fR \fIstring\fR\fR
returns the yEnc encoded data.
.TP
\fB::yencode::decode\fR \fIstring\fR\fR
Decodes the given yEnc encoded data.
.TP
\fB::yencode::yencode\fR ?-name \fIstring\fR? ?-line \fIinteger\fR? ?-crc32 \fIboolean\fR? (-file \fIfilename\fR | ?--? \fIstring\fR)\fR
Encode a file or block of data.
.TP
\fB::yencode::ydecode\fR (-file \fIfilename\fR | ?--? \fIstring\fR)\fR
Decode a file or block of data. A file may contain more than one
embedded file so the result is a list where each element is a three
element list of filename, file size and data.
.SH "OPTIONS"
.TP
-filename name
Cause the yencode or ydecode commands to read their data from the
named file rather that taking a string parameter.
.TP
-name string
The encoded data header line contains the suggested file name to be
used when unpacking the data. Use this option to change this from the
default of "data.dat".
.TP
-line integer
The yencoded data header line contains records the line length used
during the encoding. Use this option to select a line length other
that the default of 128. Note that NNTP imposes a 1000 character line
length limit and some gateways may have trouble with more than 255
characters per line.
.TP
-crc32 boolean
The yEnc specification recommends the inclusion of a cyclic redundancy
check value in the footer. Use this option to change the default from
\fItrue\fR to \fIfalse\fR.
.PP
.nf
% set d [yencode::yencode -file testfile.txt]
=ybegin line=128 size=584 name=testfile.txt
 -o- data not shown -o-
=yend size=584 crc32=ded29f4f
.fi
.SH "KEYWORDS"
encoding, uuencode, yEnc, yencode, ydecode
