# Canvas chapter
# This implements a scale with two sliders that
# represent a min and max value.
proc Scale2 {w min max {width {}} } {
	global scale2
	if {$width == {}} {
		set width [expr $max - $min]
	}
	# Save parameters
	set scale2($w,scale) [expr ($max-$min)/$width.0]
	set scale2($w,min) $min
	set scale2($w,max) $max
	set scale2($w,Min) $min
	set scale2($w,Max) $max
	set scale2($w,L) 10	
	set scale2($w,R) [expr $width+10]

	# Build from 0 to 100, then scale and move it later
	# Distance between center points of boxes is 100
	canvas $w
	$w create rect 0   0 110 10 -fill grey -tag slider
	$w create rect 0  -4 10  10 -fill black -tag {left lbox}
	$w create rect 100 0 110 14 -fill red -tag {right rbox}
	$w create text 5 16  -anchor n -text $min -tag {left lnum}
	$w create text 105 16 -anchor n -text $max \
		-tag {right rnum} -fill red

	# Scale to the right length,
	# move the right box over, and
	# then shift the whole thing into view a bit.

	set scale [expr ($width+10) / 110.0]
	$w scale slider 0 0 $scale 1.0
	set nx [lindex [$w coords slider] 2]
	$w move right [expr $nx-110] 0
	$w move all 10 10

	# Make the canvas fit comfortably around the image
	set bbox [$w bbox all]
	set height [expr [lindex $bbox 3]+4]
	$w config -height $height -width [expr $width+30]

	# Bind the actions
	$w bind left  <Button-1>  {Start %W %x lbox}
	$w bind right <Button-1>  {Start %W %x rbox}
	$w bind left  <B1-Motion> {Move %W %x lbox}
	$w bind right <B1-Motion> {Move %W %x rbox}
}
proc Scale2orig {w min max {width {}} } {
	global scale2
	if {$width == {}} {
		set width [expr $max - $min]
	}
	# Save parameters
	set scale2($w,scale) [expr ($max-$min)/$width.0]
	set scale2($w,min) $min
	set scale2($w,max) $max
	set scale2($w,Min) $min
	set scale2($w,Max) $max

	# The top of the slider is at Y = 0
	set yL [expr -4]	;# Top of left box
	set yB [expr 10]	;# Bottom of slider
	set yR [expr $yB+4]	;# Bottom of right box
	set yT [expr $yR+2]	;# Top of text

	# Each box is this wide, and the slider has
	# width pixels between the left edge of each box.
	set box 10
	incr width $box

	# The left edge of the slider is at X = 0
	set xL $box	;# right edge of first box
	set xR [expr $width-$box]	;# left edge of second box
	set xTL [expr $box/2]	;# anchor for left text
	set xTR [expr $width-($box/2)]	;# anchor for right text
    
	canvas $w
	$w create rect 0 0 $width $yB -fill grey
	$w create rect 0 $yL $xL $yB -fill black -tag {left lbox}
	$w create rect $xR 0 $width $yR -fill red -tag {right rbox}
	$w create text $xTL $yT \
	    -anchor n -text $min -tag {left lnum}
	$w create text $xTR $yT \
	    -anchor n -text $max -tag {right rnum} -fill red
    
	set space 10
	incr width [expr 2*$space]
	$w move all $space $space
	set bbox [$w bbox all]
	set height [expr [lindex $bbox 3]+4]
	$w config -height $height -width $width
	set scale2($w,L) $space	
	set scale2($w,R) [expr $width-2*$space]

	# Bind drag actions
	$w bind left  <Button-1>  {Start %W %x lbox}
	$w bind right <Button-1>  {Start %W %x rbox}
	$w bind left  <B1-Motion> {Move %W %x lbox}
	$w bind right <B1-Motion> {Move %W %x rbox}
}
proc Start { w x what } {
	global scale2
	set scale2($w,$what) $x
}

proc Move { w x what } {
	global scale2
	set x1 $scale2($w,$what)
	set scale2($w,$what) $x
	set dx [expr $x - $x1]
	set rx [lindex [$w coords rbox] 0]
	set lx [lindex [$w coords lbox] 0]
	if {$what == "lbox"} {
		if {$lx + $dx > $rx} {
			set dx [expr ($rx - $lx)]
			set scale2($w,$what) $rx
		} elseif {$lx + $dx < $scale2($w,L)} {
			set dx [expr $scale2($w,L) - $lx]
			set scale2($w,$what) $scale2($w,L)
		}
		$w move left $dx 0
		set lx [lindex [$w coords lbox] 0]
		set scale2($w,min) [expr int($scale2($w,Min) + \
			($lx-$scale2($w,L)) * $scale2($w,scale))]
		$w itemconfigure lnum -text $scale2($w,min)
	} else {
		if {($dx < 0) && (($rx + $dx) < $lx)} {
			set dx [expr ($lx - $rx)]
			set scale2($w,$what) $lx
		} elseif {($rx + $dx > $scale2($w,R))} {
			set dx [expr ($scale2($w,R) - $rx)]
			set scale2($w,$what) $scale2($w,R)
		}
		$w move right $dx 0
		set rx [lindex [$w coords right] 0]
		set scale2($w,max) [expr int($scale2($w,Min) + \
			($rx-$scale2($w,L)) * $scale2($w,scale))]
		$w itemconfigure rnum -text $scale2($w,max)
	}
}
proc Value {w} {
	global scale2
	return [list $scale2($w,min) $scale2($w,max)]
}

catch {destroy .s2}
Scale2 .s2 0 100
pack .s2 -side top
