'\"
'\" Copyright (c) 1998 Jeffrey Hobbs (jeff.hobbs@acm.org)
'/"
.TH pie n 2.0 Tk "Tk pie chart extension"
.HS pie piechart tk
.BS
.SH NAME
pie \- Create and manipulate pie graph widgets
.SH SYNOPSIS
\fBpie\fI \fIpathName \fR?\fIoptions\fR?
.SO
\-background	\-borderwidth	\-cursor
\-font	\-foreground
\-highlightbackground	\-highlightcolor	\-highlightthickness
\-padx	\-pady	\-relief	\-takefocus
.SE

.SH "WIDGET-SPECIFIC OPTIONS"
.OP \-angle angle Angle
The viewing angle for the pie, between 0 and 90.  0 views the pie as
a flat circle.  90 views the pie as a flat line.  Defaults to 0.
.OP \-label label Label
This string is placed on the top of the widget as the widgets title.
An empty label ("") will remove the label.  Default to empty.
.OP \-legend legend legend
Specifies what fields are displayed in the legend, and in what order.  The
legend option is a string consisting of the letters K,V,P and L,
representing fields: Key box (the colored square), Value (the numerical
value), P (the percentage of the whole), Label (the given label of the
slice).  Each letter may be present only once (no duplication of fields).
.PP
Numbers may precede a field identifier.  In all cases, a 0 indicates that
this field should not be shown (in which case the field id should simply be
omitted).  For the key box, a positive number means display the slice's
color in a separate box, while a negative number means use the slice's
color as background for the whole text.  For all other fields, a positive
number specifies the maximum field length to display, while a negative
number means use a field length equal to the longest required for that
field.  When no number is specified, a -1 is assumed.  For example, the
string KL would display only the label, with no numerical data displayed at
all, using a background of the slice color.
.OP \-origin origin Origin
Specifies the rotation of the pie, in degrees, clockwise. It specifies
the angle that the line between the first slice and the last slice
makes with the vertical. That is, if \fBorigin\fR is 0, then there
will always be a line in the `12 o-clock' position, going straight up. If
it is 90, then there will be a line in the `3 o-clock' position.
.OP \-precision
The numeric precision at which to display slice value and percentage
values.  Defaults to 2 (ie 100.00% or 34.22).
.OP \-radius radius Radius
Specifies the radius of the pie.
.OP \-shadow
Specifies the depth of the shadow for the pie, drawn when the angle is
not 0.  The shadow appears under the slices using a darker background,
and does not have borders.  Defaults to 0, meaning no shadow.
.OP \-sliceborder sliceBorder SliceBorder
Specifies whether borders should be drawn around the slices.
Defaults to 1.
.OP \-smallfont
If specified, this font is used to draw the values of the slices at
their edges in the main pie area.
.BE

.SH DESCRIPTION
.PP
The \fBpie\fR command creates a new window (given by the \fIpathName\fR
argument) and makes it into a pie graph widget.  Additional options,
described above, may be specified on the command line or in the option
database to configure aspects of the pie such as its colors, font, text,
and initial relief.  The \fBpie\fR command returns its \fIpathName\fR
argument.  At the time this command is invoked, there must not exist a
window named \fIpathName\fR, but \fIpathName\fR's parent must exist.
.PP
A pie is a widget for displaying pie graphs. It creates a rectangular
widget which contains a pie and a legend. The legend consists of four
fields, the \fIkey box\fR (the colored square), \fIvalue\fR (the numerical
value), \fIp\fR (the percentage of the whole) and \fIlabel\fR (the
textual label of the slice).  The display of the legend is managed by
the \fI\-legend\fR option.

.SH "WIDGET COMMAND"
.PP
The \fBpie\fR command creates a new Tcl command whose name is
\fIpathName\fR.  This command may be used to invoke various operations on
the widget.  It has the following general form:
.CS
\fIpathName option \fR?\fIarg arg ...\fR?
.CE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for pie widgets:
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBpie\fR command.
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBpie\fR command.
.TP
\fIpathName \fBdelete\fR \fIpattern\fR ?\fIpattern ...\fR?
Delete pie slices that match the given glob patterns.
.TP
\fIpathName \fBexplode\fR \fIname\fR ?\fIvalue name value ...\fR?
Convenience method to set the explode values of one or more slices.
The slices must already exist.  If only one \fIname\fR is given, then
the explode value for that slice is returned.
.TP
\fIpathName \fBitemcget\fR \fIname\fR \fIoption\fR
Returns the current value of the configuration option given by \fIoption\fR
for the named slice.
\fIOption\fR may have any of the values accepted by the
\fBpie itemconfigure\fR command.
.TP
\fIpathName \fBitemconfigure\fR \fIname\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the named slice.  If no
\fIoption\fR is specified, returns a list describing all of the available
options for named slice (see \fBTk_ConfigureInfo\fR for information on the
format of this list).  If \fIoption\fR is specified with no \fIvalue\fR,
then the command returns a list describing the one named option for the
slice (this list will be identical to the corresponding sublist of the
value returned if no \fIoption\fR is specified).  If one or more
\fIoption\-value\fR pairs are specified, then the command modifies the
given slice option(s) to have the given value(s); in this case the command
returns an empty string.  \fIOption\fR may have any of the following
values:
.RS
.TP
\fB\-foreground\fR or \fB\-fg\fR \fIcolor\fR
Foreground color of the slice.
.TP
\fB\-label\fR \fIcolor\fR
Label of the slice.  This defaults to the name, but can be
changed for viewing in the legend.
.TP
\fB\-value\fR \fIdouble\fR
Value of the slice.
.TP
\fB\-explode\fR \fIinteger\fR
Explode value of the slice.  This defines how far separated from the
main pie to display this piece.
.RE
.TP
\fIpathName \fBlower\fR \fIname\fR ?\fIbelowThis\fR?
Lower the named slice below the slice \fIbelowThis\fR.  If \fIbelowThis\fR
is not specified, move named slice to the bottom.
.TP
\fIpathName \fBnames\fR ?\fIpattern ...\fR?
Return the names of the slices, in order, according to the given
glob pattern.  \fIpattern\fR defaults to *.
.TP
\fIpathName \fBorder\fR \fIname\fR ?\fIname\fR ...?
Move the named slices, in order, to the top.  The first named slice will
be first, the second second, and so on.  The named slices must exist.
.TP
\fIpathName \fBraise\fR \fIname\fR ?\fIaboveThis\fR?
Raise the named slice above the slice \fIaboveThis\fR.  If \fIaboveThis\fR
is not specified, move named slice to the top.
.TP
\fIpathName \fBswap\fR \fIname\fR \fIname\fR
Swap the two named slices.
.TP
\fIpathName \fBset\fR \fIname\fR ?\fIvalue name value ...\fR?
Convenience method to set the values of one or more slices.
The slices do not need to already exist.  If only one \fIname\fR is
given, then the value for that slice is returned.
.TP
\fIpathName \fBvalue\fR
Returns the sum of the slice values.

.SH "DEFAULT BINDINGS"
.PP
When a new pie is created, it has no default event bindings:
pies are intended for output purposes only.  Events can be bound
to make the pie interactively spin or rotate.

.SH KEYWORDS
pie, widget
