'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" RCS: @(#) $Id: tkTable.n,v 1.12 2005/05/11 21:51:33 hobbs Exp $
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  If an argument is present, then a line break is
'\"	forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !'\\$4'' .TP \\$4
.el \{\
.   ie !'\\$2'' .TP \\n()Cu
.   el          .TP 15
.\}
.ie !'\\$3'' \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !'\\$2'' \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !'\\$1'' .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !'\\$2'' .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !'\\$1'' .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH table n 2.8 Tk "Tk Table Extension"
.HS table tk
.BS
.SH NAME
table \- Create and manipulate tables
.SH SYNOPSIS
\fBtable\fI \fIpathName \fR?\fIoptions\fR?
.SO
\-anchor	\-background	\-cursor
\-exportselection	\-font	\-foreground
\-highlightbackground	\-highlightcolor	\-highlightthickness
\-insertbackground	\-insertborderwidth	\-insertofftime
\-insertontime	\-insertwidth	\-invertselected
\-relief	\-takefocus	\-xscrollcommand
\-yscrollcommand
.SE

.SH "WIDGET-SPECIFIC OPTIONS"
.OP \-autoclear autoClear AutoClear
A boolean value which specifies whether the first keypress in a cell will
delete whatever text was previously there.  Defaults to 0.
.OP \-bordercursor borderCursor Cursor
Specifies the name of the cursor to show when over borders, a visual
indication that interactive resizing is allowed (it is thus affect by
the value of \-resizeborders).  Defaults to \fIcrosshair\fR.
.OP "\-borderwidth or \-bd" borderWidth BorderWidth
Specifies a non-negative pixel value or list of values indicating the width
of the 3-D border to draw on interior table cells (if such a border is
being drawn; the \fBrelief\fR option typically determines this).  If one
value is specified, a rectangle of this width will be drawn.  If two values
are specified, then only the left and right edges of the cell will have
borders.  If four values are specified, then the values correspond to the
{left right top bottom} edges.  This can be overridden by the a tag's
borderwidth option.  It can also be affected by the defined
\fB\-drawmode\fR for the table.  Each value in the list must have one of
the forms acceptable to \fBTk_GetPixels\fR.
.OP "\-browsecommand or \-browsecmd" browseCommand BrowseCommand
Specifies a command which will be evaluated anytime the active cell changes.
It uses the %\-substition model described in COMMAND SUBSTITUTION below.
.OP \-cache cache Cache
A boolean value that specifies whether an internal cache of the table
contents should be kept.  This greatly enhances speed performance when used
with \fB\-command\fR but uses extra memory.  Can maintain state when both
\fB\-command\fR and \fB\-variable\fR are empty.  The cache is automatically
flushed whenever the value of \fB\-cache\fR or \fB\-variable\fR changes,
otherwise you have to explicitly call \fBclear\fR on it.  Defaults to off.
.OP \-colorigin colOrigin Origin
Specifies what column index to interpret as the leftmost column in the table.
This value is used for user indices in the table.  Defaults to 0.
.OP \-cols cols Cols
Number of cols in the table.  Defaults to 10.
.OP \-colseparator colSeparator Separator
Specifies a separator character that will be interpreted as the column
separator when cutting or pasting data in a table.  By default, columns
are separated as elements of a tcl list.
.OP \-colstretchmode colStretchMode StretchMode
Specifies one of the following stretch modes for columns to fill extra
allocated window space:
.RS
.TP
\fBnone\fR
Columns will not stretch to fill the assigned window space.  If the columns
are too narrow, there will be a blank space at the right of the table.  This
is the default.
.TP
\fBunset\fR
Only columns that do not have a specific width set will be stretched.
.TP
\fBall\fR
All columns will be stretched by the same number of pixels to fill the
window space allocated to the table.  This mode can interfere with
interactive border resizing which tries to force column width.
.TP
\fBlast\fR
The last column will be stretched 
to fill the window space allocated to the table.
.TP
\fBfill\fR (only valid for \fB\-rowstretch\fR currently)
The table will get more or less columns according to the window
space allocated to the table.  This mode has numerous quirks and
may disappear in the future.
.RE
.OP \-coltagcommand colTagCommand TagCommand
Provides the name of a procedure that will be evaluated by the widget to
determine the tag to be used for a given column.  When displaying a cell,
the table widget will first check to see if a tag has been defined using the
\fBtag col\fR widget method.  If no tag is found, it will evaluate the named
procedure passing the column number in question as the sole argument.  The
procedure is expected to return the name of a tag to use, or a null string.
Errors occuring during the evaluation of the procedure, or the return of an
invalid tag name are silently ignored.
.OP \-colwidth colWidth ColWidth
Default column width, interpreted as characters in the default font when
the number is positive, or pixels if it is negative.  Defaults to 10.
.OP \-command command Command
Specified a command to use as a procedural interface to cell values.
If \fB\-usecommand\fR is true, this command will be used instead of any
reference to the \fB\-variable\fR array.  When retrieving cell values,
the return value of the command is used as the value for the cell.
It uses the %\-substition model described in COMMAND SUBSTITUTION below.
.OP \-drawmode drawMode DrawMode
Sets the table drawing mode to one of the following options:
.RS
.TP
\fBslow\fR
The table is drawn to an offscreen pixmap using the Tk bordering functions
(double-buffering).  This means there will be no flashing, but this mode is
slow for larger tables.
.TP
\fBcompatible\fR
The table is drawn directly to the screen using the Tk border functions.
It is faster, but the screen may flash on update.  This is the default.
.TP
\fBfast\fR
The table is drawn directly to the screen and the borders are done with
fast X calls, so they are always one pixel wide only.  As a side effect, it
restricts \fB\-borderwidth\fR to a range of 0 or 1.  This mode provides
best performance for large tables, but can flash on redraw and is not 100%
Tk compatible on the border mode.
.TP
\fBsingle\fR
The table is drawn to the screen as in fast mode, but only single pixel
lines are drawn (not square borders).
.RE
.OP \-ellipsis ellipsis Ellipsis
This specifies a string to display at the end of a line that would be
clipped by its cell, like ``...''.  An ellipsis will be displayed only
on non-wrapping, non-multiline cells that would be clipped.  The ellipsis
will display on the left for east anchored cells, otherwise it displays
on the right.
Defaults to "" (no ellipsis).
.OP \-flashmode flashMode FlashMode
A boolean value which specifies whether cells should flash when their value
changes.  The table tag \fBflash\fR will be applied to these cells for the
duration specified by \fB\-flashtime\fR.  Defaults to 0.
.OP \-flashtime flashTime FlashTime
The amount of time, in 1/4 second increments, for which a cell should flash
when its value has changed.  \fB\-flashmode\fR must be on.  Defaults to 2.
.OP \-height height Height
Specifies the desired height for the window, in rows.
If zero or less, then the desired height for the window is made just
large enough to hold all the rows in the table.  The height can be
further limited by \fB\-maxheight\fR.
.OP \-invertselected invertSelected InvertSelected
Specifies whether the foreground and background of an item should simply
have their values swapped instead of merging the \fIsel\fR tag options
when the cell is selected.  Defaults to 0 (merge \fIsel\fR tag).
.OP \-ipadx ipadX Pad
A pixel value specifying the internal offset X padding for text in a cell.
This value does not grow the size of the cell, it just causes the text to
be drawn further from the cell border.  It only affects one side (depending
on anchor).  Defaults to 0.  See \fB\-padx\fR for an alternate padding
style.
.OP \-ipady ipadY Pad
A pixel value specifying the internal offset Y padding for text in a cell.
This value does not grow the size of the cell, it just causes the text to
be drawn further from the cell border.  It only affects one side (depending
on anchor).  Defaults to 0.  See \fB\-pady\fR for an alternate padding
style.
.OP \-justify justify Justify
How to justify multi\-line text in a cell.
It must be one of \fBleft\fR, \fBright\fR, or \fBcenter\fR.
Defaults to left.
.OP \-maxheight maxHeight MaxHeight
The max height in pixels that the window will request.  Defaults to 600.
.OP \-maxwidth maxWidth MaxWidth
The max width in pixels that the window will request.  Defaults to 800.
.OP \-multiline multiline Multiline
Specifies the default setting for the multiline tag option.  Defaults to 1.
.OP \-padx padX Pad
A pixel value specifying the offset X padding for a cell.  This value
causes the default size of the cell to increase by two times the value (one
for each side), unless a specific pixel size is chosen for the cell with
the \fBwidth\fR command.  This will force an empty area on the left and
right of each cell edge.  This padding affects all types of data in the
cell.  Defaults to 0.  See \fB\-ipadx\fR for an alternate padding style.
.OP \-pady padY Pad
A pixel value specifying the offset Y padding for a cell.  This value
causes the default size of the cell to increase by two times the value (one
for each side), unless a specific pixel size is chosen for the cell with
the \fBheight\fR command.  This will force an empty area on the top and
bottom of each cell edge.  This padding affects all types of data in the
cell.  Defaults to 0.  See \fB\-ipadx\fR for an alternate padding style.
.OP \-resizeborders resizeBorders ResizeBorders
Specifies what kind of interactive border resizing to allow, must be one of
row, col, both (default) or none.
.OP \-rowheight rowHeight RowHeight
Default row height, interpreted as lines in the default font when
the number is positive, or pixels if it is negative.  Defaults to 1.
.OP \-roworigin rowOrigin Origin
Specifies what row index to interpret as the topmost row in the table.
This value is used for user indices in the table.  Defaults to 0.
.OP \-rows rows Rows
Number of rows in the table.  Defaults to 10.
.OP \-rowseparator rowSeparator Separator
Specifies a separator character that will be interpreted as the row
separator when cutting or pasting data in a table.  By default, rows
are separated as tcl lists.
.OP \-rowstretchmode rowStretchMode StretchMode
Specifies the stretch modes for rows to fill extra
allocated window space.  See \fB\-colstretchmode\fR for valid options.
.OP \-rowtagcommand rowTagCommand TagCommand
Provides the name of a procedure that can evaluated by the widget to
determine the tag to be used for a given row.  The procedure must be
defined by the user to accept a single argument (the row number), and
return a tag name or null string.  This operates in a similar manner as
\fB\-coltagcommand\fR, except that it applies to row tags.
.OP "\-selectioncommand or \-selcmd" selectionCommand SelectionCommand
Specifies a command to evaluate when the selection is retrieved from a
table via the selection mechanism (ie: evaluating ``\fBselection get\fR'').
The return value from this command will become the string passed on by the
selection mechanism.  It uses the %\-substition model described in COMMAND
SUBSTITUTION below.  If an error occurs, a Tcl background error is
generated and nothing is returned.
.OP \-selectmode selectMode SelectMode
Specifies one of several styles for manipulating the selection.  The value
of the option may be arbitrary, but the default bindings expect it to be
either \fBsingle\fR, \fBbrowse\fR, \fBmultiple\fR, or \fBextended\fR; the
default value is \fBbrowse\fR.  These styles are like those for the Tk
listbox, except expanded for 2 dimensions.
.OP \-selecttitle selectTitles SelectTitles
Specifies whether title cells should be allowed in the selection.
Defaults to 0 (disallowed).
.OP \-selecttype selectType SelectType
Specifies one of several types of selection for the table.  The value of the
option may be one of \fBrow\fR, \fBcol\fR, \fBcell\fR, or \fBboth\fR
(meaning \fBrow && col\fR); the default value is \fBcell\fR.  These types
define whether an entire row/col is affected when a cell's selection is
changed (set or clear).
.OP \-sparsearray sparseArray SparseArray
A boolean value that specifies whether an associated Tcl array should be
kept as a sparse array (1, the default) or as a full array (0).  If true,
then cell values that are empty will be deleted from the array (taking
less memory).  If false, then all values in the array will be maintained.
.OP \-state state State
Specifies one of two states for the entry:  \fBnormal\fR or \fBdisabled\fR.
If the table is disabled then the value may not be changed using widget
commands and no insertion cursor will be displayed, even if the input focus
is in the widget.  Also, all insert or delete methods will be ignored.
Defaults to \fBnormal\fR.
.OP \-titlecols titleCols TitleCols
Number of columns to use as a title area.  Defaults to 0.
.OP \-titlerows titleRows TitleRows
Number of rows to use as a title area.  Defaults to 0.
.OP \-usecommand useCommand UseCommand
A boolean value which specifies whether to use the \fBcommand\fR option.
This value sets itself to zero if \fBcommand\fR is used and returns an error.
Defaults to 1 (will use \fBcommand\fR if specified).
.OP \-validate validate Validate
A boolean specifying whether validation should occur for the active buffer.
Defaults to 0.
.OP "\-validatecommand or \-vcmd" validateCommand ValidateCommand
Specifies a command to execute when the active cell is edited.  This command
is expected to return a Tcl boolean.  If it returns true, then it is assumed
the new value is OK, otherwise the new value is rejected (the edition will
not take place).  Errors in this command are handled in the background.  It
uses the %\-substition model described in COMMAND SUBSTITUTION below.
.OP \-variable variable Variable
Global Tcl array variable to attach to the table's C array.  It will be
created if it doesn't already exist or is a simple variable.  Keys used by
the table in the array are of the form \fIrow\fR,\fIcol\fR for cells and
the special key \fIactive\fR which contains the value of the active cell
buffer.  The Tcl array is managed as a sparse array (the table doesn't
require all valid indices have values).  No stored value for an index is
equivalent to the empty string, and clearing a cell will remove that index
from the Tcl array, unless the \fB\-sparsearray\fR options is set to 0.
.OP \-width width Width
Specifies the desired width for the window, in columns.
If zero or less, then the desired width for the window is made just
large enough to hold all the columns in the table.  The width can be
further limited by \fB\-maxwidth\fR.
.OP \-wrap wrap Wrap
Specifies the default wrap value for tags.  Defaults to 0.
.BE

.SH DESCRIPTION
.PP
The \fBtable\fR command creates a 2\-dimensional grid of cells.  The table
can use a Tcl array variable or Tcl command for data storage and retrieval,
as well as optionally cache data in memory for speed.  One of these data
sources \fImust\fR be configured before any data is retained by the table.
The widget has an active cell, the contents of which can be edited (when
the state is normal).  The widget supports a default style for the cells
and also multiple \fItags\fR, which can be used to change the style of a
row, column or cell (see TAGS for details).  A cell \fIflash\fR can be set
up so that changed cells will change color for a specified amount of time
("blink").  Cells can have embedded images or windows, as described in
TAGS and "EMBEDDED WINDOWS" respectively.
.PP
One or more cells may be selected as described below.  If a table is
exporting its selection (see \fB\-exportselection\fR option), then it will
observe the standard X11 protocols for handling the selection.  See THE
SELECTION for details.
.PP
It is not necessary for all the cells to be displayed in the table window at
once; commands described below may be used to change the view in the window.
Tables allow scrolling in both directions using the standard
\fB\-xscrollcommand\fR and \fB\-yscrollcommand\fR options.  They also support
scanning, as described below.
.PP
In order to obtain good performance, the table widget supports multiple
drawing modes, two of which are fully Tk compatible.

.SH "INITIALIZATION"
.PP
When the \fBtable\fR command is loaded into an interpreter, a built-in
Tcl command, \fBtkTableInit\fR, is evaluated.  This will search for the
appropriate table binding init file to load.  The directories searched
are those in \fI$tcl_pkgPath\fR, both with Tktable(version) appended and
without, \fI$tk_library\fR and \fI[pwd]\fR (the current directory).  You
can also define an \fI$env(TK_TABLE_LIBRARY)\fR to head this search list.
By default, the file searched for is called \fBtkTable.tcl\fR, but this
can be overridden by setting \fI$env(TK_TABLE_LIBRARY_FILE)\fR.
.PP
This entire init script can be overridden by providing your own
\fBtkTableInit\fR procedure before the library is loaded.  Otherwise, the
aforementioned \fIenv(TK_TABLE_LIBRARY)\fR variable will be set with the
directory in which \fI$env(TK_TABLE_LIBRARY_FILE)\fR was found.

.SH "INDICES"
.PP
Many of the widget commands for tables take one or more indices as arguments.
An index specifies a particular cell of the table, in any of
the following ways:
.TP 12
\fInumber,number\fR
Specifies the cell as a numerical index of row,col which corresponds to the
index of the associated Tcl array, where \fB\-roworigin,\-colorigin\fR
corresponds to the first cell in the table (0,0 by default).  The values
for row and column will be constrained to actual values in the table,
which means a valid cell is always found.
.TP 12
\fBactive\fR
Indicates the cell that has the location cursor.
It is specified with the \fBactivate\fR widget command.
.TP 12
\fBanchor\fR
Indicates the anchor point for the selection, which is set with the
\fBselection anchor\fR widget command.
.TP 12
\fBbottomright\fR
Indicates the bottom\-rightmost cell visible in the table.
.TP 12
\fBend\fR
Indicates the bottom right cell of the table.
.TP 12
\fBorigin\fR
Indicates the top\-leftmost editable cell of the table, not necessarily
in the display.  This takes into account the user specified origin and
title area.
.TP 12
\fBtopleft\fR
Indicates the top\-leftmost editable cell visible in the table (this
excludes title cells).
.TP 12
\fB@\fIx\fB,\fIy\fR
Indicates the cell that covers the point in the table window
specified by \fIx\fR and \fIy\fR (in pixel coordinates).  If no
cell covers that point, then the closest cell to that
point is used.
.LP
In the widget command descriptions below, arguments named \fIindex\fR,
\fIfirst\fR, and \fIlast\fR always contain text indices in one of
the above forms.

.SH TAGS
.PP
A tag is a textual string that is associated with zero or more rows,
columns or cells in a table.  Tags may contain arbitrary characters, but it
is probably best to avoid using names which look like indices to reduce
coding confusion.  A tag can apply to an entire row or column, or just a
single cell.  There are several permanent tags in each table that can be
configured by the user and will determine the attributes for special cells:
.RS
.TP 10
\fBactive\fR
This tag is given to the \fIactive\fR cell
.TP 10
\fBflash\fR
If flash mode is on, this tag is given to any recently
edited cells.
.TP 10
\fBsel\fR
This tag is given to any selected cells.
.TP 10
\fBtitle\fR
This tag is given to any cells in the title rows and columns.  This
tag has \fB\-state\fR \fIdisabled\fR by default.
.RE
.PP
Tags control the way cells are displayed on the screen.  Where appropriate,
the default for displaying cells is determined by the options for the table
widget.  However, display options may be associated with individual tags
using the ``\fIpathName \fBtag configure\fR'' widget command.  If a cell,
row or column has been tagged, then the display options associated with the
tag override the default display style.  The following options are
currently supported for tags:
.RS
.TP
\fB\-anchor\fR \fIanchor\fR
Anchor for item in the cell space.
.TP
\fB\-background\fR or \fB\-bg\fR \fIcolor\fR
Background color of the cell.
.TP
\fB\-borderwidth\fR or \fB\-bd\fR \fIpixelList\fR
Borderwidth of the cell, of the same format for the table, but may also
be empty to inherit the default table borderwidth value (the default).
.TP
\fB\-ellipsis\fR \fIstring\fR
String to display at the end of a line that would be clipped by its cell,
like ``...''.  An ellipsis will be displayed only
on non-wrapping, non-multiline cells that would be clipped.  The ellipsis
will display on the left for east anchored cells, otherwise it displays
on the right.
.TP
\fB\-font\fR \fIfontName\fR
Font for text in the cell.
.TP
\fB\-foreground\fR or \fB\-fg\fR \fIcolor\fR
Foreground color of the cell.
.TP
\fB\-justify\fR \fIjustify\fR
How to justify multi\-line text in a cell.
It must be one of \fBleft\fR, \fBright\fR, or \fBcenter\fR.
.TP
\fB\-image\fR \fIimageName\fR
An image to display in the cell instead of text.
.TP
\fB\-multiline\fR \fIboolean\fR
Whether to display text with newlines on multiple lines.
.TP
\fB\-relief\fR \fIrelief\fR
The relief for the cell.  May be the empty string to cause this tag to
not disturb the value.
.TP
\fB\-showtext\fR \fIboolean\fR
Whether to show the text over an image.
.TP
\fB\-state\fR \fIstate\fR
The state of the cell, to allow for certain cells to be disabled.
This prevents the cell from being edited by the \fIinsert\fR or \fIdelete\fR
methods, but a direct \fIset\fR will not be prevented.
.TP
\fB\-wrap\fR \fIboolean\fR
Whether characters should wrap in a cell that is not wide enough.
.RE
.PP
A priority order is defined among tags based on creation order (first
created tag has highest default priority), and this order is used in
implementing some of the tag\-related functions described below.  When a cell
is displayed, its properties are determined by the tags which are assigned
to it.  The priority of a tag can be modified by the ``\fIpathName \fBtag
lower\fR'' and ``\fIpathName \fBtag raise\fR'' widget commands.
.PP
If a cell has several tags associated with it that define the same display
options (eg - a \fBtitle\fR cell with specific \fBrow\fR and \fBcell\fR
tags), then the options of the highest priority tag are used.  If a
particular display option hasn't been specified for a particular tag, or if
it is specified as an empty string, then that option will not be used; the
next\-highest\-priority tag's option will be used instead.  If no tag
specifies a particular display option, then the default style for the
widget will be used.
.PP
Images are used for display purposes only.  Editing in that cell will still
be enabled and any querying of the cell will show the text value of the cell,
regardless of the value of \fB\-showtext\fR.

.SH "EMBEDDED WINDOWS"
.PP
There may be any number of embedded windows in a table widget (one per
cell), and any widget may be used as an embedded window (subject to the
usual rules for geometry management, which require the table window to be
the parent of the embedded window or a descendant of its parent).  The
embedded window's position on the screen will be updated as the table is
modified or scrolled, and it will be mapped and unmapped as it moves into
and out of the visible area of the table widget.  Each embedded window
occupies one cell's worth of space in the table widget, and it is referred
to by the index of the cell in the table.  Windows associated with the
table widget are destroyed when the table widget is destroyed.
.PP
Windows are used for display purposes only.  A value still exists for that
cell, but will not be shown unless the window is deleted in some way.  If
the window is destroyed or lost by the table widget to another geometry
manager, then any data associated with it is lost (the cell it occupied
will no longer appear in \fBwindow names\fR).
.PP
When an embedded window is added to a table widget with the window
configure widget command, several configuration options may be associated
with it.  These options may be modified with later calls to the window
configure widget command.  The following options are currently supported:
.RS
.TP
\fB\-create \fIscript\fR
NOT CURRENTLY SUPPORTED.  Specifies a Tcl script that may be evaluated to
create the window for the annotation.  If no \-window option has been
specified for this cell then this script will be evaluated when the
cell is about to be displayed on the screen.  Script must create a
window for the cell and return the name of that window as its result.
If the cell's window should ever be deleted, the script will be evaluated
again the next time the cell is displayed.
.TP
\fB\-background\fR or \fB\-bg\fR \fIcolor\fR
Background color of the cell.  If not
specified, it uses the table's default background.
.TP
\fB\-borderwidth\fR or \fB\-bd\fR \fIpixelList\fR
Borderwidth of the cell, of the same format for the table, but may also
be empty to inherit the default table borderwidth value (the default).
.TP
\fB\-padx \fIpixels\fR
As defined in the Tk options man page.
.TP
\fB\-pady \fIpixels\fR
As defined in the Tk options man page.
.TP
\fB\-relief \fIrelief\fR
The relief to use for the cell in which the window lies.  If not
specified, it uses the table's default relief.
.TP
\fB\-sticky \fIsticky\fR
Stickiness of the window inside the cell, as defined by the \fBgrid\fR command.
.TP
\fB\-window \fIpathName\fR
Specifies the name of a window (widget) to display in the annotation.  It
must exist before being specified here.  When an empty string is specified,
if a window was displayed it will cease to be managed by the table widget.
.RE

.SH "THE SELECTION"
.PP
Table selections are available as type STRING.  By default, the value of
the selection will be the values of the selected cells in nested Tcl list
form where each row is a list and each column is an element of a row list.
You can change the way this value is interpreted by setting the
\fB\-rowseparator\fR and \fB\-colseparator\fR options.  For example,
default Excel format would be to set \fB\-rowseparator\fR to '\\n' and
\fB\-colseparator\fR to '\\t'.  Changing these values affects both how the
table sends out the selection and reads in pasted data, ensuring that the
table should always be able to cut and paste to itself.  It is possible to
change how pastes are handled by editing the table library procedure
\fBtk_tablePasteHandler\fR.  This might be necessary if
\fB\-selectioncommand\fR is set.

.SH "ROW/COL SPANNING"
.PP
Individual cells can span multiple rows and/or columns.  This is done
via the \fBspans\fR command (see below for exact arguments).  Cells in
the title area that span are not permitted to span beyond the title area,
and will be constrained accordingly.  If the title area shrinks during a
configure, sanity checking will occur to ensure the above.  You may set
spans on regular cells that extend beyond the defined row/col area.  These
spans will not be constrained, so that when the defined row/col area
expands, the span will expand with it.
.PP
When setting a span, checks are made as to whether the span would overlap
an already spanning or hidden cell.  This is an error and it not allowed.
Spans can affect the overall speed of table drawing, although not
significantly.  If spans are not used, then there is no performance loss.
.PP
Cells \fIhidden\fR by spanning cells still have valid data.  This will
be seen during cut and paste operations that involve hidden cells, or
through direct access by a command like \fBget\fR or \fBset\fR.
.PP
The drawing properties of spanning cells apply to only the visual area
of the cell.  For example, if a cell is center justified over 5 columns,
then when viewing any portion of those columns, it will appear centered
in the visible area. The non-visible column area will not be considered
in the centering calculations.

.SH "COMMAND SUBSTITUTION"
.PP

The various option based commands that the table supports all support the
familiar Tk %\-substitution model (see \fBbind\fR for more details).  The
following %\-sequences are recognized and substituted by the table widget:
.TP 5
\fB%c\fR
For \fBSelectionCommand\fR, it is the maximum number of columns in any
row in the selection.  Otherwise it is the column of the triggered cell.
.TP 5
\fB%C\fR
A convenience substitution for \fI%r\fR,\fI%c\fR.
.TP 5
\fB%i\fR
For \fBSelectionCommand\fR, it is the total number of cells in the selection.
For \fBCommand\fR, it is 0 for a read (get) and 1 for a write (set).
Otherwise it is the current cursor position in the cell.
.TP 5
\fB%r\fR
For \fBSelectionCommand\fR, it is the number of rows in the selection.
Otherwise it is the row of the triggered cell.
.TP 5
\fB%s\fR
For \fBValidateCommand\fR, it is the current value of the cell being validated.
For \fBSelectionCommand\fR, it is the default value of the selection.
For \fBBrowseCommand\fR, it is the index of the last active cell.
For \fBCommand\fR, it is empty for reads (get) and the current value of the
cell for writes (set).
.TP 5
\fB%S\fR
For \fBValidateCommand\fR, it is the potential new value of the cell
being validated.
For \fBBrowseCommand\fR, it is the index of the new active cell.
.TP 5
\fB%W\fR
The pathname to the window for which the command was generated.
.LP

.SH "WIDGET COMMAND"
.PP
The \fBtable\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This command may be used to invoke various
operations on the widget.  It has the following general form:
.CS
\fIpathName option \fR?\fIarg arg ...\fR?
.CE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.
.PP
The following commands are possible for \fBtable\fR widgets:
.TP
\fIpathName \fBactivate\fR \fIindex\fR
Sets the active cell to the one indicated by \fIindex\fR.
.TP
\fIpathName \fBbbox\fR \fIfirst\fR ?\fIlast\fR?
It returns the bounding box for the specified cell (range) as a 4\-tuple of
x, y, width and height in pixels.  It clips the box to the visible portion,
if any, otherwise an empty string is returned.
.TP
\fIpathName \fBborder\fR \fIoption args\fR
This command is a voodoo hack to implement border sizing for tables.
This is normally called through bindings, with the following as valid
options:
.RS
.TP
\fIpathName \fBborder mark\fR \fIx y\fR ?\fIrow|col\fR?
Records \fIx\fR and \fIy\fR and the row and/or column border under that
point in the table window, if any; used in conjunction with later \fBborder
dragto\fR commands.  Typically this command is associated with a mouse
button press in the widget.  If \fIrow\fR or \fIcol\fR is not specified, it
returns a tuple of both border indices (an empty item means no border).
Otherwise, just the specified item is returned.
.TP
\fIpathName \fBborder dragto\fR \fIx y\fR
This command computes the difference between its \fIx\fR and \fIy\fR
arguments and the \fIx\fR and \fIy\fR arguments to the last \fBborder
mark\fR command for the widget.  It then adjusts the previously marked
border by the difference.  This command is typically associated with mouse
motion events in the widget, to produce the effect of interactive border
resizing.
.RE
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.  \fIOption\fR may have any of the values accepted
by the \fBtable\fR command.
.TP
\fIpathName \fBclear\fR \fIoption\fR ?\fIfirst\fR? ?\fIlast\fR?
This command is a convenience routine to clear certain state information
managed by the table.  \fIfirst\fR and \fIlast\fR represent valid table
indices.  If neither are specified, then the command operates on the
whole table.  The following options are recognized:
.RS
.TP
\fIpathName \fBclear cache\fR ?\fIfirst\fR? ?\fIlast\fR?
Clears the specified section of the cache, if the table has been
keeping one.
.TP
\fIpathName \fBclear sizes\fR ?\fIfirst\fR? ?\fIlast\fR?
Clears the specified row and column areas of specific height/width
dimensions.  When just one index is specified, for example \fB2,0\fR,
that is interpreted as row 2 \fBand\fR column 0.
.TP
\fIpathName \fBclear tags\fR ?\fIfirst\fR? ?\fIlast\fR?
Clears the specified area of tags (all row, column and cell tags).
.TP
\fIpathName \fBclear all\fR ?\fIfirst\fR? ?\fIlast\fR?
Performs all of the above clear functions on the specified area.
.RE
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBtable\fR
command.
.TP
\fIpathName \fBcurselection\fR ?\fIvalue\fR?
With no arguments, it returns the sorted indices of the currently selected
cells.  Otherwise it sets all the selected cells to the given value.  The
set has no effect if there is no associated Tcl array or the state is
disabled.
.TP
\fIpathName \fBcurvalue\fR ?\fIvalue\fR?
If no value is given, the value of the cell being edited (indexed by
\fBactive\fR) is returned, else it is set to the given value.
.TP
\fIpathName \fBdelete\fR \fIoption arg\fR ?\fIarg\fR?
This command is used to delete various things in a table.  It has several
forms, depending on the \fIoption\fR:
.RS
.TP
\fIpathName \fBdelete active\fR \fIindex\fR ?\fIindex\fR?
Deletes text from the active cell.  If only one index is given, it deletes
the character after that index, otherwise it deletes from the first index to
the second.  \fIindex\fR can be a number, \fBinsert\fR or \fBend\fR.
.TP
\fIpathName \fBdelete cols\fR ?\fIswitches\fR? \fIindex\fR ?\fIcount\fR?
Deletes \fIcount\fR cols starting at (and including) col \fIindex\fR.  The
\fIindex\fR will be constrained to the limits of the tables.  If
\fIcount\fR is negative, it deletes cols to the left.  Otherwise it deletes
cols to the right.  \fIcount\fR defaults to 1 (meaning just the column
specified).  At the moment, spans are
not adjusted with this action.  Optional switches are:
.RS
.TP
\fB\-holddimensions\fR
Causes the table cols to be unaffected by the deletion (empty cols may
appear).  By default the dimensions are adjusted by \fBcount\fR.
.TP
\fB\-holdselection\fR
Causes the selection to be maintained on the absolute cells values.
Otherwise, the selection will be cleared..
.TP
\fB\-holdtags\fR
Causes the tags specified by the \fItag\fR method to not move along
with the data.  Also prevents specific widths set by the \fIwidth\fR method
from being adjusted.  By default, these tags are properly adjusted.
.TP
\fB\-holdwindows\fR
Causes the embedded windows created with the \fIwindow\fR method to not
move along with the data.  By default, these windows are properly adjusted.
.TP
\fB\-keeptitles\fR
Prevents title area cells from being changed.  Otherwise they are
treated just like regular cells and will move as specified.
.TP
\fB\-\-\fR
Signifies the end of the switches.
.RE
.TP
\fIpathName \fBdelete rows\fR ?\fIswitches\fR? \fIindex\fR ?\fIcount\fR?
Deletes \fBcount\fR rows starting at (and including) row \fBindex\fR.  If
\fBcount\fR is negative, it deletes rows going up.  Otherwise it deletes
rows going down.  The selection will be cleared.  The switches are the same
as those for column deletion.
.RE
.TP
\fIpathName \fBget\fR \fIfirst\fR ?\fIlast\fR?
Returns the value of the cells specified by the table indices \fIfirst\fR
and (optionally) \fIlast\fR in a list.
.TP
\fIpathName \fBheight\fR ?\fIrow\fR? ?\fIvalue row value ...\fR?
If no \fIrow\fR is specified, returns a list describing all rows for which
a height has been set.  If \fBrow\fR is specified with no value, it prints
out the height of that row in characters (positive number) or pixels
(negative number).  If one or more \fIrow\-value\fR pairs are specified,
then it sets each row to be that height in lines (positive number) or
pixels (negative number).  If \fIvalue\fR is \fIdefault\fR, then the row
uses the default height, specified by \fB\-rowheight\fR.
.TP
\fIpathName \fBhidden\fR ?\fIindex\fR? ?\fIindex ...\fR?
When called without args, it returns all the \fIhidden\fR cells (those
cells covered by a spanning cell).  If one index is specified, it returns
the spanning cell covering that index, if any.  If multiple indices are
specified, it returns 1 if all indices are hidden cells, 0 otherwise.
.TP
\fIpathName \fBicursor\fR ?\fIarg\fR?
With no arguments, prints out the location of the insertion cursor in the
active cell.  With one argument, sets the cursor to that point in the
string.  0 is before the first character, you can also use \fBinsert\fR or
\fBend\fR for the current insertion point or the end of the text.  If
there is no active cell, or the cell or table is disabled, this will
return -1.
.TP
\fIpathName \fBindex\fR \fIindex\fR ?\fIrow|col\fR?
Returns the integer cell coordinate that corresponds to \fIindex\fR in the
form row,col.  If \fBrow\fR or \fBcol\fR is specified, then only the row or
column index is returned.
.TP
\fIpathName \fBinsert\fR \fIoption arg arg\fR
This command is used to into various things into a table.  It has several
forms, depending on the \fIoption\fR:
.RS
.TP
\fIpathName \fBinsert active\fR \fIindex value\fR
The \fIvalue\fR is a text string which is inserted at the \fIindex\fR
postion of the active cell.  The cursor is then positioned after the
new text. \fIindex\fR can be a number, \fBinsert\fR or \fBend\fR.
.TP
\fIpathName \fBinsert cols\fR ?\fIswitches\fR? \fIindex\fR ?\fIcount\fR?
Inserts \fBcount\fR cols starting at col \fBindex\fR.  If \fBcount\fR is
negative, it inserts before the specified col.  Otherwise it inserts after
the specified col.  The selection will be cleared.  The switches are the
same as those for column deletion.
.TP
\fIpathName \fBinsert rows\fR ?\fIswitches\fR? \fIindex\fR ?\fIcount\fR?
Inserts \fBcount\fR rows starting at row \fBindex\fR.  If \fBcount\fR is
negative, it inserts before the specified row.  Otherwise it inserts after
the specified row.  The selection will be cleared.  The switches are the
same as those for column deletion.
.RE
.TP
\fIpathName \fBreread\fR
Rereads the old contents of the cell back into the editing buffer.  Useful
for a key binding when <Escape> is pressed to abort the edit (a default
binding).
.TP
\fIpathName \fBscan\fR \fIoption args\fR
This command is used to implement scanning on tables.  It has
two forms, depending on \fIoption\fR:
.RS
.TP
\fIpathName \fBscan mark\fR \fIx y\fR
Records \fIx\fR and \fIy\fR and the current view in the table
window;  used in conjunction with later \fBscan dragto\fR commands.
Typically this command is associated with a mouse button press in
the widget.  It returns an empty string.
.TP
\fIpathName \fBscan dragto\fR \fIx y\fR.
This command computes the difference between its \fIx\fR and \fIy\fR
arguments and the \fIx\fR and \fIy\fR arguments to the last \fBscan mark\fR
command for the widget.  It then adjusts the view by 5 times the difference
in coordinates.  This command is typically associated with mouse motion
events in the widget, to produce the effect of dragging the list at high
speed through the window.  The return value is an empty string.
.RE
.TP
\fIpathName \fBsee\fR \fIindex\fR
Adjust the view in the table so that the cell given by \fIindex\fR is
positioned as the cell one off from top left (excluding title rows and
columns) if the cell is not currently visible on the screen.  The actual
cell may be different to keep the screen full.
.TP
\fIpathName \fBselection\fR \fIoption arg\fR
This command is used to adjust the selection within a table.  It
has several forms, depending on \fIoption\fR:
.RS
.TP
\fIpathName \fBselection anchor\fR \fIindex\fR
Sets the selection anchor to the cell given by \fIindex\fR.  The selection
anchor is the end of the selection that is fixed while dragging out a
selection with the mouse.  The index \fBanchor\fR may be used to refer to
the anchor cell.
.TP
\fIpathName \fBselection clear\fR \fIfirst \fR?\fIlast\fR?
If any of the cells between \fIfirst\fR and \fIlast\fR (inclusive) are
selected, they are deselected.  The selection state is not changed for cells
outside this range.  \fIfirst\fR may be specified as \fBall\fR to remove
the selection from all cells.
.TP
\fIpathName \fBselection includes\fR \fIindex\fR
Returns 1 if the cell indicated by \fIindex\fR is currently
selected, 0 if it isn't.
.TP
\fIpathName \fBselection set\fR \fIfirst\fR ?\fIlast\fR?
Selects all of the cells in the range between \fIfirst\fR and \fIlast\fR,
inclusive, without affecting the selection state of cells outside that
range.
.RE
.TP
\fIpathName \fBset\fR ?\fIrow|col\fR? \fIindex\fR ?\fIvalue\fR? ?\fIindex value ...\fR?
Sets the specified index to the associated value.  Table validation will
not be triggered via this method.  If \fBrow\fR or \fBcol\fR precedes the
list of index/value pairs, then the value is assumed to be a Tcl list whose
values will be split and set into the subsequent columns (if \fBrow\fR is
specified) or rows (for \fBcol\fR).  For example, \fBset row 2,3
{2,3 2,4 2,5}\fR will set 3 cells, from 2,3 to 2,5.  The setting of cells
is silently bounded by the known table dimensions.
.TP
\fIpathName \fBspans\fR ?\fIindex\fR? ?\fIrows,cols index rows,cols ...\fR?
This command is used to manipulate row/col spans.  When called with no
arguments, all known spans are returned as a list of tuples of the form
{index span}.  When called with only the \fIindex\fR, the span for that
\fIindex\fR only is returned, if any.  Otherwise an even number of
\fIindex rows,cols\fR pairs are used to set spans.  A span starts at the
\fIindex\fR and continues for the specified number of rows and cols.
Negative spans are not supported.  A span of 0,0 unsets any span on that
cell.  See EXAMPLES for more info.
.TP
\fIpathName \fBtag\fR option ?\fIarg arg ...\fR?
This command is used to manipulate tags.  The exact behavior of the command
depends on the \fIoption\fR argument that follows the \fBtag\fR argument.
\fIcget\fR, \fIcell\fR, and \fIrow|col\fR complain about unknown tag names.
The following forms of the command are currently supported:
.RS
.TP
\fIpathName \fBtag cell\fR \fItagName ?index ...?\fR
With no arguments, prints out the list of cells that use the \fItag\fR.
Otherwise it sets the specified cells to use the named tag, replacing any
tag that may have been set using this method before.  If \fItagName\fR is
{}, the cells are reset to the default \fItag\fR.  Tags added during
\-*tagcommand evaluation do not register here.  If \fItagName\fR does
not exist, it will be created with the default options.
.TP
\fIpathName \fBtag cget\fR \fItagName option\fR
This command returns the current value of the option named \fIoption\fR
associated with the tag given by \fItagName\fR.  \fIOption\fR may have any
of the values accepted by the \fBtag configure\fR widget command.
.TP
\fIpathName \fBtag col\fR \fItagName ?col ...?\fR
With no arguments, prints out the list of cols that use the \fItag\fR.
Otherwise it sets the specified columns to use the named tag, replacing any
tag that may have been set using this method before.  If \fItagName\fR is
{}, the cols are reset to the default \fItag\fR.  Tags added during
\-coltagcommand evaluation do not register here.  If \fItagName\fR does
not exist, it will be created with the default options.
.TP
\fIpathName \fBtag configure \fItagName\fR ?\fIoption\fR? ?\fIvalue\fR? ?\fIoption value ...\fR?
This command is similar to the \fBconfigure\fR widget command except that
it modifies options associated with the tag given by \fItagName\fR instead
of modifying options for the overall table widget.  If no \fIoption\fR is
specified, the command returns a list describing all of the available
options for \fItagName\fR (see \fBTk_ConfigureInfo\fR for information on
the format of this list).  If \fIoption\fR is specified with no
\fIvalue\fR, then the command returns a list describing the one named
option (this list will be identical to the corresponding sublist of the
value returned if no \fIoption\fR is specified).  If one or more
\fIoption\-value\fR pairs are specified, then the command modifies the
given option(s) to have the given value(s) in \fItagName\fR; in this case
the command returns an empty string.
See TAGS above for details on the options available for tags.
.TP
\fIpathName \fBtag delete\fR \fItagName\fR
Deletes a tag.  No error if the tag does not exist.
.TP
\fIpathName \fBtag exists\fR \fItagName\fR
Returns 1 if the named tag exists, 0 otherwise.
.TP
\fIpathName \fBtag includes\fR \fItagName index\fR
Returns 1 if the specified index has the named tag, 0 otherwise.
.TP
\fIpathName \fBtag lower\fR \fItagName\fR ?\fIbelowThis\fR?
Lower the priority of the named tag.  If \fIbelowThis\fR is not specified,
then the tag's priority is lowered to the bottom, otherwise it is lowered
to one below \fIbelowThis\fR.
.TP
\fIpathName \fBtag names\fR ?\fIpattern\fR?
If no pattern is specified, shows the names of all defined tags.
Otherwise the \fIpattern\fR is used as a glob pattern to show only
tags matching that pattern.  Tag names are returned in priority order
(highest priority tag first).
.TP
\fIpathName \fBtag raise\fR \fItagName\fR ?\fIaboveThis\fR?
Raise the priority of the named tag.  If \fIaboveThis\fR is not specified,
then the tag's priority is raised to the top, otherwise it is raised to
one above \fIaboveThis\fR.
.TP
\fIpathName \fBtag row\fR \fItagName\fR ?\fIrow ...\fR?
With no arguments, prints out the list of rows that use the \fItag\fR.
Otherwise it sets the specified columns to use the named tag, replacing any
tag that may have been set using this method before.  If \fItagName\fR is
{}, the rows are reset to use the default tag.  Tags added during
\-rowtagcommand evaluation do not register here.  If \fItagName\fR does
not exist, it will be created with the default options.
.RE
.TP
\fIpathName \fBvalidate\fR \fIindex\fR
Explicitly validates the specified index based on the current
\fB\-validatecommand\fR and returns 0 or 1 based on whether the cell was
validated.
.TP
\fIpathName \fBwidth\fR ?\fIcol\fR? ?\fIvalue col value ...\fR?
If no \fIcol\fR is specified, returns a list describing all cols for which
a width has been set.  If \fBcol\fR is specified with no value, it prints
out the width of that col in characters (positive number) or pixels
(negative number).  If one or more \fIcol\-value\fR pairs are specified,
then it sets each col to be that width in characters (positive number) or
pixels (negative number).  If \fIvalue\fR is \fIdefault\fR, then the col
uses the default width, specified by \fB\-colwidth\fR.
.TP
\fIpathName \fBwindow\fR option ?\fIarg arg ...\fR?
This command is used to manipulate embedded windows.  The exact behavior of
the command depends on the \fIoption\fR argument that follows the
\fBwindow\fR argument.  The following forms of the command are currently
supported:
.RS
.TP
\fIpathName \fBwindow cget\fR \fIindex option\fR
This command returns the current value of the option named \fIoption\fR
associated with the window given by \fIindex\fR.  \fIOption\fR may have any
of the values accepted by the \fBwindow configure\fR widget command.
.TP
\fIpathName \fBwindow configure \fIindex\fR ?\fIoption\fR? ?\fIvalue\fR? ?\fIoption value ...\fR?
This command is similar to the \fBconfigure\fR widget command except that
it modifies options associated with the embedded window given by
\fIindex\fR instead of modifying options for the overall table widget.  If
no \fIoption\fR is specified, the command returns a list describing all of
the available options for \fIindex\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified with
no \fIvalue\fR, then the command returns a list describing the one named
option (this list will be identical to the corresponding sublist of the
value returned if no \fIoption\fR is specified).  If one or more
\fIoption\-value\fR pairs are specified, then the command modifies the
given option(s) to have the given value(s) in \fIindex\fR; in this case
the command returns an empty string.
See EMBEDDED WINDOWS above for details on the options available for windows.
.TP
\fIpathName \fBwindow delete\fR \fIindex\fR ?\fIindex ...\fR?
Deletes an embedded window from the table.  The associated window will
also be deleted.
.TP
\fIpathName \fBwindow move\fR \fIindexFrom indexTo\fR
Moves an embedded window from one cell to another.  If a window already
exists in the target cell, it will be deleted.
.TP
\fIpathName \fBwindow names\fR ?\fIpattern\fR?
If no pattern is specified, shows the cells of all embedded windows.
Otherwise the \fIpattern\fR is used as a glob pattern to show only
cells matching that pattern.
.RE
.TP
\fIpathName \fBxview \fIargs\fR
This command is used to query and change the horizontal position of the
information in the widget's window.  It can take any of the following
forms:
.RS
.TP
\fIpathName \fBxview\fR
Returns a list containing two elements.
Each element is a real fraction between 0 and 1;  together they describe
the horizontal span that is visible in the window.
For example, if the first element is .2 and the second element is .6,
20% of the table's text is off\-screen to the left, the middle 40% is visible
in the window, and 40% of the text is off\-screen to the right.
These are the same values passed to scrollbars via the \fB\-xscrollcommand\fR
option.
.TP
\fIpathName \fBxview\fR \fIindex\fR
Adjusts the view in the window so that the column given by
\fIindex\fR is displayed at the left edge of the window.
.TP
\fIpathName \fBxview moveto\fI fraction\fR
Adjusts the view in the window so that \fIfraction\fR of the
total width of the table text is off\-screen to the left.
\fIfraction\fR must be a fraction between 0 and 1.
.TP
\fIpathName \fBxview scroll \fInumber what\fR
This command shifts the view in the window left or right according to
\fInumber\fR and \fIwhat\fR.
\fINumber\fR must be an integer.
\fIWhat\fR must be either \fBunits\fR or \fBpages\fR or an abbreviation
of one of these.
If \fIwhat\fR is \fBunits\fR, the view adjusts left or right by
\fInumber\fR cells on the display; if it is \fBpages\fR then the view
adjusts by \fInumber\fR screenfuls.
If \fInumber\fR is negative then cells farther to the left
become visible;  if it is positive then cells farther to the right
become visible.
.RE
.TP
\fIpathName \fByview \fI?args\fR?
This command is used to query and change the vertical position of the
text in the widget's window.  It can take any of the following forms:
.RS
.TP
\fIpathName \fByview\fR
Returns a list containing two elements, both of which are real fractions
between 0 and 1.  The first element gives the position of the table element
at the top of the window, relative to the table as a whole (0.5 means it is
halfway through the table, for example).  The second element gives the
position of the table element just after the last one in the window,
relative to the table as a whole.  These are the same values passed to
scrollbars via the \fB\-yscrollcommand\fR option.
.TP
\fIpathName \fByview\fR \fIindex\fR
Adjusts the view in the window so that the row given by
\fIindex\fR is displayed at the top of the window.
.TP
\fIpathName \fByview moveto\fI fraction\fR
Adjusts the view in the window so that the element given by \fIfraction\fR
appears at the top of the window.
\fIFraction\fR is a fraction between 0 and 1;  0 indicates the first
element in the table, 0.33 indicates the element one\-third the
way through the table, and so on.
.TP
\fIpathName \fByview scroll \fInumber what\fR
This command adjusts the view in the window up or down according to
\fInumber\fR and \fIwhat\fR.  \fINumber\fR must be an integer.  \fIWhat\fR
must be either \fBunits\fR or \fBpages\fR.  If \fIwhat\fR is \fBunits\fR,
the view adjusts up or down by \fInumber\fR cells; if it is \fBpages\fR then
the view adjusts by \fInumber\fR screenfuls.  If \fInumber\fR is negative
then earlier elements become visible; if it is positive then later elements
become visible.
.RE

.SH "DEFAULT BINDINGS"
.PP
The initialization creates class bindings that give the
following default behaviour:
.IP [1]
Clicking Button\-1 in a cell activates that cell.  Clicking
into an already active cell moves the insertion cursor to the
character nearest the mouse.
.IP [2]
Moving the mouse while Button\-1 is pressed will stroke out a selection area.
Exiting while Button\-1 is pressed causing scanning to occur on the table
along with selection.
.IP [3]
Moving the mouse while Button\-2 is pressed causes scanning to
occur without any selection.
.IP [4]
Home moves the table to have the origin in view.
.IP [5]
End moves the table to have the \fBend\fR cell in view.
.IP [6]
Control\-Home moves the table to the origin and activates that cell.
.IP [7]
Control\-End moves the table to the end and activates that cell.
.IP [8]
Shift\-Control\-Home extends the selection to the origin.
.IP [9]
Shift\-Control\-End extends the selection to the end.
.IP [10]
The left, right, up and down arrows move the active cell.
.IP [11]
Shift\-<arrow> extends the selection in that direction.
.IP [12]
Control\-leftarrow and Control\-rightarrow move the insertion
cursor within the cell.
.IP [13]
Control\-slash selects all the cells.
.IP [14]
Control\-backslash clears selection from all the cells.
.IP [15]
Backspace deletes the character before the insertion cursor
in the active cell.
.IP [16]
Delete deletes the character after the insertion cursor
in the active cell.
.IP [17]
Escape rereads the value of the active cell from the specified data source,
discarding any edits that have may been performed on the cell.
.IP [18]
Control\-a moves the insertion cursor to the beginning of the active cell.
.IP [19]
Control\-e moves the insertion cursor to the end of the active cell.
.IP [20]
Control\-minus and Control\-equals decrease and increase the
width of the column with the active cell in it.
.IP [21]
Moving the mouse while Button\-3 (the right button on Windows) is pressed
while you are over a border will cause interactive resizing of that row
and/or column to occur, based on the value of \fB\-resizeborders\fR.
.PP
Some bindings may have slightly different behavior dependent on the
\fB\-selectionmode\fR of the widget.
.PP
If the widget is disabled using the \fB\-state\fR option, then its
view can still be adjusted and cells can still be selected,
but no insertion cursor will be displayed and no cell modifications will
take place.
.PP
The behavior of tables can be changed by defining new bindings for
individual widgets or by redefining the class bindings.  The default
bindings are either compiled in or read from a file expected to
correspond to: "[lindex $tcl_pkgPath 0]/Tktable<version>/tkTable.tcl".

.SH "PERFORMANCE ISSUES"
.PP
The number of rows and columns or a table widget should not significantly
affect the speed of redraw.  Recalculation and redraw of table parameters
and cells is restricted as much as possible.
.PP
The display cell with the insert cursor is redrawn each time the cursor
blinks, which causes a steady stream of graphics traffic.  Set the
\fB\-insertofftime\fR option to 0 avoid this.  The use of a \fB\-command\fR
with the table without a cache can cause significant slow\-down, as the
command is called once for each request of a cell value.


.SH EXAMPLES
.PP
Set the topleft title area to be one spanning cell.  This overestimates
both row and column span by one, but the command does all the constraining
for us.
.CS
$table span [$table cget -roworigin],[$table cget -colorigin] [$table cget -titlerows],[$table cget -titlecols]
.CE
Force a table window refresh (useful for the slight chance that a bug
in the table is not causing proper refresh):
.CS
$table configure -padx [$table cget -padx]
.CE

.SH KEYWORDS
table, widget, extension
