#
# Tag Image File Format Library
#
# Copyright (c) 1988, 1989, 1990, 1991, 1992, 1993, 1994 Sam Leffler
# Copyright (c) 1991, 1992, 1993, 1994 Silicon Graphics, Inc.
# 
# Permission to use, copy, modify, distribute, and sell this software and 
# its documentation for any purpose is hereby granted without fee, provided
# that (i) the above copyright notices and this permission notice appear in
# all copies of the software and related documentation, and (ii) the names of
# Sam Leffler and Silicon Graphics may not be used in any advertising or
# publicity relating to the software without the specific, prior written
# permission of Sam Leffler and Silicon Graphics.
# 
# THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
# EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
# WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
# 
# IN NO EVENT SHALL SAM LEFFLER OR SILICON GRAPHICS BE LIABLE FOR
# ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
# OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
# WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
# LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
# OF THIS SOFTWARE.
#

#
# Makefile for Mac using MPW 3.3.1 and MPW C 3.2.4
#
#  Note:  This file must be run through "mactrans" before it can
#  be recognized by MPW as a valid makefile. The problem is that MPW
#  uses special non-ASCII characters, which tend to get mangled when stored
#  in unix tar files, etc. "mactrans" is built as part of the TIFF MPW build.
#
#

DEPTH   = ::

# FAX Options: If you do not wish to include the FAX options, uncomment
# the first four definitions and comment out the next four 
# definitions. Note that to build programs with the FAX libraries you
# have to include "-model far" in your compile and link statements.
#
# Also, to build the fax code (including the tif_fax3sm.c file, which is
# created by the MPW tool "mkg3states", also built below), you will
# need to size the MPW program up to about 6 megabytes or so.

#FAX_OPTIONS = 
#FAX_OBJECTS = 	
#FAX_SOURCES = tif_fax3.c 
#FAX_CONFIG = 

FAX_OPTIONS = -model far
FAX_OBJECTS = 	tif_fax3.c.o tif_fax3sm.c.o
FAX_SOURCES = tif_fax3.c tif_fax3sm.c
FAX_CONFIG = -d CCITT_SUPPORT

NULL=

RM = delete -y -i 
COPTS = 

LIBPORT=::port:libport.o

#
.c.o %c4 .c
	{C} -model far {CFLAGS} -s {Default} {DepDir}{Default}.c -o {TargDir}{Default}.c.o


CONF_LIBRARY= %b6
	-d HAVE_IEEEFP=1 %b6
	-d BSDTYPES 

CONF_COMPRESSION= %b6
	{FAX_CONFIG} %b6
	-d COMPRESSION_SUPPORT %b6
	-d PACKBITS_SUPPORT 	%b6
	-d LZW_SUPPORT 	%b6
	-d THUNDER_SUPPORT %b6
	-d NEXT_SUPPORT 

CFLAGS=	{FAX_OPTIONS} {IPATH} {CONF_LIBRARY} {CONF_COMPRESSION} 

INCS=	tiff.h tiffio.h

SRCS=	%b6
	{FAX_SOURCES} %b6
	tif_apple.c %b6
	tif_aux.c %b6
	tif_close.c %b6
	tif_codec.c %b6
	tif_compress.c %b6
	tif_dir.c %b6
	tif_dirinfo.c %b6
	tif_dirread.c %b6
	tif_dirwrite.c %b6
	tif_dumpmode.c %b6
	tif_error.c %b6
	tif_getimage.c %b6
	tif_jpeg.c %b6
	tif_flush.c %b6
	tif_lzw.c %b6
	tif_next.c %b6
	tif_open.c %b6
	tif_packbits.c %b6
	tif_predict.c %b6
	tif_print.c %b6
	tif_read.c %b6
	tif_swab.c %b6
	tif_strip.c %b6
	tif_thunder.c %b6
	tif_tile.c %b6
	tif_version.c %b6
	tif_warning.c %b6
	tif_write.c %b6
	tif_zip.c %b6
	{NULL}

OBJS=	%b6
	{FAX_OBJECTS} %b6
	tif_apple.c.o %b6
	tif_aux.c.o %b6
	tif_close.c.o %b6
	tif_codec.c.o %b6
	tif_compress.c.o %b6
	tif_dir.c.o %b6
	tif_dirinfo.c.o %b6
	tif_dirread.c.o %b6
	tif_dirwrite.c.o %b6
	tif_dumpmode.c.o %b6
	tif_error.c.o %b6
	tif_getimage.c.o %b6
	tif_jpeg.c.o %b6
	tif_flush.c.o %b6
	tif_lzw.c.o %b6
	tif_next.c.o %b6
	tif_open.c.o %b6
	tif_packbits.c.o %b6
	tif_predict.c.o %b6
	tif_print.c.o %b6
	tif_read.c.o %b6
	tif_swab.c.o %b6
	tif_strip.c.o %b6
	tif_thunder.c.o %b6
	tif_tile.c.o %b6
	tif_version.c.o %b6
	tif_warning.c.o %b6
	tif_write.c.o %b6
	tif_zip.c.o %b6
	{NULL}

ALL=libtiff.o

all %c4 {ALL}

libtiff.o %c4 {OBJS}
	Lib  {OBJS} -o libtiff.o
	

{OBJS} %c4 tiffio.h tiff.h tiffcomp.h tiffiop.h tiffconf.h

#
# The finite state machine tables used by the G3/G4 decoders
# are generated by the mkg3states program.  On systems without
# make these rules have to be manually carried out.
#
tif_fax3sm.c %c4 mkg3states tif_fax3.h
        {RM} tif_fax3sm.c || set status 0
	:mkg3states -c const tif_fax3sm.c

mkg3states.c.o %c4 mkg3states.c
   C -model far  mkg3states.c -o mkg3states.c.o

mkg3states %c4%c4 mkg3states.c.o
	Link -model far -d -c 'MPS ' -t MPST %b6
		mkg3states.c.o %b6
		{LIBPORT} %b6
		"{CLibraries}"StdClib.o %b6
		"{Libraries}"Stubs.o %b6
		"{Libraries}"Runtime.o %b6
		"{Libraries}"Interface.o %b6
		-o mkg3states

ALPHA   = "{DEPTH}dist:tiff.alpha"
VERSION = "{DEPTH}VERSION"

version.h %c4 {VERSION} {ALPHA}
        Set VERSION1 `catenate {VERSION}` 
        Set VERSION2 "{VERSION1}`streamedit -e "1 rep /%a5%c5 %c5 (%c5)%a81/ %a81" {ALPHA}`" 
        delete -y -i version.h || set status 0
	echo '#define VERSION "LIBTIFF, Version' {VERSION2} '\nCopyright (c) 1988-1995 Sam Leffler\nCopyright (c) 1991-1995 Silicon Graphics, Inc."' >version.h

tif_version.c.o %c4 version.h

clean %c4
	{RM} {ALL}  || set status 0
	{RM} {OBJS} || set status 0
	{RM} mkg3states || set status 0
	{RM} mkg3states.c.o || set status 0
	{RM} tif_fax3sm.c%c5 || set status 0
	{RM} version.h || set status 0
 
