/*
 * X-specific Tk interface to TkGS
 */

#include <tk.h>
#include <tkgs.h>

/* Include Xlib driver as static package */
#include <drivers/xlib/tkgsXlib.h>


TkGS_Device XlibDriver;


TkGS_Drawable
TkGS_GetWindowDrawable(tkwin)
    Tk_Window	tkwin;
{
    TkGS_Drawable d;
    XlibDrawableCreateData cd;

    cd.display	= Tk_Display(tkwin);
    cd.colormap = Tk_Colormap(tkwin);
    cd.d	= Tk_WindowId(tkwin);

    d = TkGS_GetDrawable(XlibDriver, (ClientData) &cd);
    return d;
}


void
TkGSpGetSystemColorRGBValues(systemColor, redPtr, greenPtr, bluePtr)
    int		   systemColor;
    unsigned short *redPtr;
    unsigned short *greenPtr;
    unsigned short *bluePtr;
{
    /* No system color for now */
    *redPtr = *greenPtr = *bluePtr = 0;
}

int
TkGSpInit(interp)
    Tcl_Interp *interp;
{
    /* Load Xlib driver as static package */
    XlibTkGS_StaticPackage(NULL);

    /* FIXME: better way to do this? */
    if (Tcl_Eval(interp, "load {} XlibTkGS") == TCL_ERROR) {
	return TKGS_ERROR;
    }

    XlibDriver = TkGS_GetDevice("Xlib");

    return TKGS_OK;
}

