#ifndef _TKGSOBJ
#define _TKGSOBJ

/*
 *--------------------------------------------------------------
 *
 * TkGS objects
 *
 *--------------------------------------------------------------
 */

/*
 * Forward declaration of TkGS_Obj to prevent an error when the forward
 * reference to TkGS_Obj is encountered in the procedure types declared 
 * below.
 */

struct TkGS_Obj;

/*
 * Base type functions
 */

typedef void (TkGS_FreeBaseProc) _ANSI_ARGS_((struct TkGS_Obj *objPtr));
typedef void (TkGS_DupBaseProc) _ANSI_ARGS_((struct TkGS_Obj *srcPtr,
	struct TkGS_Obj *dupPtr));

/*
 * The following structure represents the base type of object, which is the
 * base (ie external) representation for an object plus a set of
 * procedures that provide standard operations on objects of that type.
 */

struct TkGS_ObjType;
struct TkGS_InternalRep;

typedef struct TkGS_BaseType {
    char *name;			/* Name of the base type, eg. "GC" */
    int  size;			/* Byte size of TkGS_Objs of this type */
    int  nbIntReps;		/* Number of cached internal reps */

    TkGS_FreeBaseProc   *freeBaseProc;
				/* Called to free any storage for the type's
				 * base rep. NULL if the base rep does not 
				 * need freeing. */
    TkGS_DupBaseProc    *dupBaseProc;
    				/* Called to create a new object as a copy
				 * of an existing object. It only copies the
				 * public part of the object, not the
				 * internal part */
} TkGS_BaseType;


/*
 * Object type functions
 */

typedef void (TkGS_FreeInternalRepProc) _ANSI_ARGS_((
	struct TkGS_InternalRep *intRepPtr));
typedef int (TkGS_SetFromAnyProc) _ANSI_ARGS_((Tcl_Interp *interp,
	struct TkGS_Obj *objPtr, struct TkGS_InternalRep *intRepPtr));

/*
 * The following structure represents a type of object, which is a
 * particular internal representation for an object plus a set of
 * procedures that provide standard operations on objects of that type.
 */

typedef struct TkGS_ObjType {
    char *name;			/* Name of the type, e.g. "XlibGC". */
    TkGS_BaseType *baseTypePtr;	/* Base type, eg. GC, Drawable... */

    TkGS_FreeInternalRepProc *freeIntRepProc;
				/* Called to free any storage for the type's
				 * internal rep. NULL if the internal rep
				 * does not need freeing. */
    TkGS_SetFromAnyProc      *setFromAnyProc;
    				/* Called to convert the object's internal
				 * rep to this type. Frees the internal rep
				 * of the old type. Returns TKGS_ERROR on
				 * failure, and TKGS_OK on success. NULL if 
				 * the object is immutable */
} TkGS_ObjType;


/*
 * This structure is used to keep track of objects' internal representations.
 * Objects can cache one or several internal reps simultaneously, depending
 * on their base type.
 */

typedef struct TkGS_InternalRep {
    TkGS_ObjType *typePtr;	    /* Denotes the object's type. Always
				     * corresponds to the type of the object's
				     * internal rep. NULL indicates the object
				     * has no internal rep (has no type). */
    union {
	long longValue;			/* a long integer value */
	unsigned long ulongValue;	/* an unsigned long integer value */
	double doubleValue;		/* a double-precision floating value */
	VOID *otherValuePtr;		/* another, type-specific value */
	struct {			/* internal rep as two values */
	    union {
		long longValue;
		unsigned long ulongValue;
		VOID* otherValuePtr;
	    } value1, value2;
	} twoValue;
    } value;
} TkGS_InternalRep;


/*
 * One of the following structures exists for each object in the TkGS
 * system. An object stores a value as a device-independent part (its
 * external representation) and a device-dependent part (its internal
 * representation).
 */

typedef struct TkGS_Obj {
    int refCount;		    /* When 0 the object will be freed. */
    TkGS_BaseType *baseTypePtr;	    /* Base type, eg. GC, Drawable... */
    union {			    /* The internal representation: */
	TkGS_InternalRep single;    /*  - single internal rep. */
	TkGS_InternalRep *multiple; /*  - multiple internal reps: array of 
				     *    baseTypePtr->nbIntRep elements. */
    } internalRep;
} TkGS_Obj;


/*
 * Macros to increment and decrement a TkGS_Obj's reference count, and to
 * test whether an object is shared (i.e. has reference count > 1).
 * Note: clients should use TkGS_DecrRefCount() when they are finished using
 * an object, and should never call TkGSFreeObj() directly. TkGSFreeObj() is
 * only defined and made public in tkgs.h to support TkGS_DecrRefCount's macro
 * definition. Note also that TkGS_DecrRefCount() refers to the parameter
 * "obj" twice. This means that you should avoid calling it with an
 * expression that is expensive to compute or has side effects.
 */

EXTERN void		TkGS_IncrRefCount _ANSI_ARGS_((TkGS_Obj *objPtr));
EXTERN void		TkGS_DecrRefCount _ANSI_ARGS_((TkGS_Obj *objPtr));
EXTERN int		TkGS_IsShared _ANSI_ARGS_((TkGS_Obj *objPtr));
EXTERN TkGS_Obj *	TkGSNewObj _ANSI_ARGS_((TkGS_BaseType *baseTypePtr));
EXTERN void		TkGSFreeObj _ANSI_ARGS_((TkGS_Obj *objPtr));

#define TkGS_IncrRefCount(objPtr) \
    ++(objPtr)->refCount
#define TkGS_DecrRefCount(objPtr) \
    if (--(objPtr)->refCount <= 0) TkGSFreeObj(objPtr)
#define TkGS_IsShared(objPtr) \
    ((objPtr)->refCount > 1)

EXTERN TkGS_InternalRep *	TkGS_AddNewInternalRep _ANSI_ARGS_((
				    Tcl_Interp *interp, TkGS_Obj *objPtr,
				    TkGS_ObjType *typePtr));
EXTERN TkGS_InternalRep *	TkGS_PushInternalRep _ANSI_ARGS_((
				    TkGS_Obj *objPtr,
				    TkGS_InternalRep *intRepPtr));
EXTERN TkGS_InternalRep *	TkGS_FindInternalRep _ANSI_ARGS_((
				    TkGS_Obj *objPtr, TkGS_ObjType *typePtr));
EXTERN TkGS_Obj *		TkGS_DuplicateObj _ANSI_ARGS_((
				    TkGS_Obj *objPtr));


#endif /* _TKGSOBJ */

