#include <tk.h>
#include <tkgs.h>
#include <tkgsInt.h>
#include <drivers/canvas/tkgsCanvas.h>
#include <drivers/ps/tkgsPS.h>
#include <tkgsTk.h>
#include <tkgsTkInt.h>

/*
 * Information cached about the system at startup time.
 */

static Tcl_Encoding unicodeEncoding;



static int
TkGSCanvasInit(interp)
    Tcl_Interp *interp;
{
    /* Load Canvas driver as static package */
    CanvasTkGS_StaticPackage(NULL);

    /* FIXME: better way to do this? */
    return Tcl_Eval(interp, "load {} CanvasTkGS");
}

static int
TkGSPostScriptInit(interp)
    Tcl_Interp *interp;
{
    /* Load PS driver as static package */
    PSTkGS_StaticPackage(NULL);

    /* FIXME: better way to do this? */
    return Tcl_Eval(interp, "load {} PSTkGS");
}


/*
 *----------------------------------------------------------------------
 *
 * Tkgs_Init --
 *
 *	This function is used to initialize the package. Here we check
 *	dependencies with other packages (eg Tcl), create new commands,
 *	and register our packages
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	New commands created, and package registered (see documentation).
 *
 *----------------------------------------------------------------------
 */

int Tkgs_Init(interp)
    Tcl_Interp *interp;
{  
#ifdef USE_TCL_STUBS
    if (Tcl_InitStubs(interp, "8.3", 0) == NULL) {
	return TCL_ERROR;
    }
#endif

#ifdef USE_TK_STUBS
    if (Tk_InitStubs(interp, "8.3", 0) == NULL) {
	return TCL_ERROR;
    }
#endif

    /* Dependencies */
    if (Tcl_PkgRequire(interp, "Tcl", "8.3", 0) == NULL)
	return TCL_ERROR;
    if (Tcl_PkgRequire(interp, "Tk", "8.3", 0) == NULL)
	return TCL_ERROR;

    /* Package provided */
    if (Tcl_PkgProvide(interp, "TkGS", "1.0") == TCL_ERROR)
	return TCL_ERROR;

    /* Initialization */
    TkGSInitDriverTable();


    /*
     * Static driver packages
     */

    /* Platform-specific initialization */
    if (TkGSpInit(interp) == TCL_ERROR)
	return TCL_ERROR;

    /* Static device drivers initializarion */
    if (TkGSCanvasInit(interp) == TCL_ERROR)
	return TCL_ERROR;
    if (TkGSPostScriptInit(interp) == TCL_ERROR)
	return TCL_ERROR;

    unicodeEncoding = Tcl_GetEncoding(NULL, "unicode");

    /*
     * Tk binding initialization
     */

    TkGSTkInit(interp);

    return TCL_OK;
}


/*
 *----------------------------------------------------------------------
 *
 * Tkgs_SafeInit --
 *
 *	This function is used to initialize the package in the special case
 *	of safe interpreters (like the Tcl Plugin). Here we check
 *	dependencies with other packages (eg Tcl), create new commands,
 *	and register our packages
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	New commands created, and package registered (see documentation).
 *
 *----------------------------------------------------------------------
 */

int Tkgs_SafeInit(interp)
    Tcl_Interp *interp;
{  
    /* For now, do the same as with unsafe interpreters */
    return Tkgs_Init(interp);
}

#ifdef WIN32
/*
 *----------------------------------------------------------------------
 *
 * DllEntryPoint --
 *
 *	This wrapper function is used by Windows to invoke the
 *	initialization code for the DLL.  If we are compiling
 *	with Visual C++, this routine will be renamed to DllMain.
 *	routine.
 *
 * Results:
 *	Returns TRUE;
 *
 * Side effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */

BOOL APIENTRY
DllEntryPoint(hInst, reason, reserved)
    HINSTANCE hInst; /* Library instance handle. */
    DWORD reason;    /* Reason this function is being called. */
    LPVOID reserved; /* Not used. */
{
    return TRUE;
}
#endif /* WIN32 */


