#ifndef _TKGS
#define _TKGS

/*
 *--------------------------------------------------------------
 *
 * Tcl package initialization
 *
 *--------------------------------------------------------------
 */


#include <tk.h>

/*
 * if the BUILD_TkGS macro is defined, the assumption is that we are
 * building the dynamic library.
 */

#ifdef BUILD_TkGS
#   undef TCL_STORAGE_CLASS
#   define TCL_STORAGE_CLASS DLLEXPORT
#endif

#define EXPORT(a,b) a b

#ifdef WIN32
#   define WIN32_LEAN_AND_MEAN
#   include <windows.h>
#   undef WIN32_LEAN_AND_MEAN

#   ifndef STATIC_BUILD
#	if defined(__BORLANDC__)
#           undef EXPORT
#           define EXPORT(a,b) a _export b
#	endif
#   endif
#endif	/* WIN32 */

/*
 * The DLL's main entry point
 */

EXTERN EXPORT(int,Tkgs_Init)     _ANSI_ARGS_((Tcl_Interp *interp));
EXTERN EXPORT(int,Tkgs_SafeInit) _ANSI_ARGS_((Tcl_Interp *interp));



/*
 * Error codes
 */

#define TKGS_OK		0
#define TKGS_ERROR	1

/* 
 * String formats
 */

#define TKGS_UNICODE	1
#define TKGS_UTF	2
#define TKGS_SYSTEM	3

/* Default format */

#ifndef TKGS_STRING_FORMAT
#   define TKGS_STRING_FORMAT TKGS_UTF
#endif

/* TkGS_String */

#define TkGS_UniChar Tcl_UniChar

#define TkGS_StringUni TkGS_UniChar *
#define TkGS_StringUtf char *
#define TkGS_StringSys char *

#if (TKGS_STRING_FORMAT == TKGS_UNICODE)
#   define TkGS_String		TkGS_StringUni
#elif (TKGS_STRING_FORMAT == TKGS_UTF)
#   define TkGS_String		TkGS_StringUtf
#else
#   define TkGS_String		TkGS_StringSys
#endif



/*
 * Opaque tokens (which become transparent in debug & build mode).
 */

/* FIXME */
/*
#if !defined(_DEBUG) && !defined(BUILD_TkGS)
typedef void* TkGS_Device;
typedef void* TkGS_Drawable;
typedef void* TkGS_Color;
typedef void* TkGS_FontFaces;
typedef void* TkGS_Font;
#else
typedef struct TkGS_DeviceDriver*	TkGS_Device;
typedef struct TkGS_Drawable_*		TkGS_Drawable;
typedef struct TkGS_Color_*		TkGS_Color;
typedef struct TkGS_FontFaces_*		TkGS_FontFaces;
typedef struct TkGS_Font_*		TkGS_Font;
#endif
*/
typedef struct TkGS_DeviceDriver*	TkGS_Device;
typedef struct TkGS_Drawable_*		TkGS_Drawable;
typedef struct TkGS_Color_*		TkGS_Color;
typedef struct TkGS_FontFaces_*		TkGS_FontFaces;
typedef struct TkGS_Font_*		TkGS_Font;

/*
 * TkGS_Point  --
 * TkGS_Rectangle  --
 * 
 * Device-independent structure that holds point and rectangle coordinates.
 */

typedef struct TkGS_Point {
    int x, y;
} TkGS_Point;

typedef struct TkGS_Rectangle {
    int x, y;  
    unsigned int width, height;
} TkGS_Rectangle;

/*
 * Color types
 */

#define TKGS_COLOR_SYSTEM	1
#define TKGS_COLOR_RGB		2

/*
 * GCValues  --
 * 
 * Device-independent structure that holds drawing parameters.
 */

typedef struct TkGS_GCValues {
    TkGS_Color   foreground;
    TkGS_Color   background;
    unsigned int lineWidth;
    TkGS_Font    font;
/*
    int		arcMode;
*/
} TkGS_GCValues;

/* GCValues attributes masks */

#define TkGS_GCForeground	(1L<<1)
#define TkGS_GCBackground	(1L<<2)
#define TkGS_GCLineWidth	(1L<<3)
#define TkGS_GCFont		(1L<<4)

#define TkGS_GCAll		-1L	/* All bits set to 1. */


/*
 * The following structure is used by TkGS_GetFontMetrics() to return
 * information about the properties of a TkGS_Font.  
 */

typedef struct TkGS_FontMetrics {
    int	ascent;			/* From baseline to top of font. */
    int	descent;		/* From baseline to bottom of font. */
    int maxWidth;		/* Width of widest character in font. */
    int fixed;			/* Non-zero if this is a fixed-width font,
				 * 0 otherwise. */
    int tabWidth;		/* Width of tabs in this font. */
    int	underlinePos;		/* Offset from baseline to origin of
				 * underline bar (used for drawing underlines
				 * on a non-underlined font). */
    int underlineHeight;	/* Height of underline bar (used for drawing
				 * underlines on a non-underlined font). */
} TkGS_FontMetrics;


/*
 * TkGS_FontAttributes  --
 * 
 * Device-independent structure that describes fonts.
 * Inspired from Tk's TkFontAttributes, except for the
 * familiy specifier and the bit field attributes.
 */


typedef struct TkGS_FontAttributes {
    TkGS_FontFaces faces;	/* Face name descriptor */
    int size;			/* Pointsize of font, 0 for default size, or
				 * negative number meaning pixel size. */

    unsigned int weight     : 2;/* Weight flag; see below for def'n. */
    unsigned int slant      : 2;/* Slant flag; see below for def'n. */
    unsigned int underline  : 1;/* Non-zero for underline font. */
    unsigned int overstrike : 1;/* Non-zero for overstrike font. */
} TkGS_FontAttributes;

/*
 * Possible values for the "weight" field in a TkGS_FontAttributes structure.
 * Weight is a subjective term and depends on what the company that created
 * the font considers bold.
 */

#define TKGS_FW_NORMAL	0
#define TKGS_FW_BOLD	1

#define TKGS_FW_UNKNOWN	-1	/* Unknown weight.  This value is used for
				 * error checking and is never actually stored
				 * in the weight field. */

/*
 * Possible values for the "slant" field in a TkGS_FontAttributes structure.
 */

#define TKGS_FS_ROMAN	0	
#define TKGS_FS_ITALIC	1
#define TKGS_FS_OBLIQUE	2

#define TKGS_FS_UNKNOWN	-1	/* Unknown slant.  This value is used for
				 * error checking and is never actually stored
				 * in the slant field. */



/*
 * For now, includes tkgsInt.h for low-level access to internal structures
 */

#undef TCL_STORAGE_CLASS
#define TCL_STORAGE_CLASS DLLIMPORT

#include "tkgsInt.h"

#ifdef BUILD_TkGS
#   undef TCL_STORAGE_CLASS
#   define TCL_STORAGE_CLASS DLLEXPORT
#endif



/*
 *--------------------------------------------------------------
 *
 * Functions
 *
 *--------------------------------------------------------------
 */

/* 
 * Drawable procs 
 */

EXTERN TkGS_Drawable	TkGS_GetDrawable _ANSI_ARGS_((TkGS_Device device,
			    ClientData clientData));
EXTERN void		TkGS_ReleaseDrawable _ANSI_ARGS_((TkGS_Drawable d));
EXTERN TkGS_Device	TkGS_GetDrawableDevice _ANSI_ARGS_((TkGS_Drawable d));
EXTERN TkGS_Device	TkGS_GetDevice _ANSI_ARGS_((char *deviceName));


/* 
 * Color procs 
 */

EXTERN TkGS_Color	TkGS_GetSystemColor _ANSI_ARGS_((int systemColor));
EXTERN TkGS_Color	TkGS_GetRGBColor _ANSI_ARGS_((unsigned short red,
			    unsigned short green, unsigned short blue));
EXTERN int		TkGS_GetColorType _ANSI_ARGS_((TkGS_Color color));
EXTERN int		TkGS_GetSystemColorValue _ANSI_ARGS_((TkGS_Color color));
EXTERN void		TkGS_GetRGBColorValues _ANSI_ARGS_((TkGS_Color color,
			    unsigned short *redPtr, unsigned short *greenPtr,
			    unsigned short *bluePtr));
EXTERN void		TkGS_FreeColor _ANSI_ARGS_((TkGS_Color color));

/* 
 * Font faces procs 
 */

EXTERN TkGS_FontFaces	TkGS_GetFontFace _ANSI_ARGS_((char *name));
EXTERN TkGS_FontFaces	TkGS_GetFontFaces _ANSI_ARGS_((int nbNames,
			    char **names));
EXTERN void		TkGS_FreeFontFaces _ANSI_ARGS_((
			    TkGS_FontFaces fontFaces));
EXTERN int		TkGS_GetNbFontFaces _ANSI_ARGS_((
			    TkGS_FontFaces fontFaces));
EXTERN char *		TkGS_GetFontFaceName _ANSI_ARGS_((
			    TkGS_FontFaces fontFaces, int nb));

/* 
 * Font procs 
 */

EXTERN TkGS_Font	TkGS_GetFont _ANSI_ARGS_((TkGS_FontAttributes *faPtr));
EXTERN void		TkGS_FreeFont _ANSI_ARGS_((TkGS_Font font));
EXTERN void		TkGS_GetFontAttributes _ANSI_ARGS_((TkGS_Font font,
			    TkGS_FontAttributes *faPtr));

/* 
 * GC procs 
 */

/* Generic GCValues accessors */
EXTERN void		TkGS_SetGCValues _ANSI_ARGS_((TkGS_Drawable drawable,
			    unsigned long valueMask, TkGS_GCValues *values));
EXTERN void		TkGS_GetGCValues _ANSI_ARGS_((TkGS_Drawable drawable,
			    unsigned long valueMask, TkGS_GCValues *values));

/* GCValues attribute-specific accessors */
EXTERN void		TkGS_SetDrawableForeground _ANSI_ARGS_((
			    TkGS_Drawable drawable, TkGS_Color color));
EXTERN void		TkGS_SetDrawableBackground _ANSI_ARGS_((
			    TkGS_Drawable drawable, TkGS_Color color));
EXTERN void		TkGS_SetDrawableLineWidth  _ANSI_ARGS_((
			    TkGS_Drawable drawable, unsigned int lineWidth));
EXTERN void		TkGS_SetDrawableFont _ANSI_ARGS_((TkGS_Drawable drawable, 
			    TkGS_Font font));

EXTERN TkGS_Color	TkGS_GetDrawableForeground _ANSI_ARGS_((
			    TkGS_Drawable drawable));
EXTERN TkGS_Color	TkGS_GetDrawableBackground _ANSI_ARGS_((
			    TkGS_Drawable drawable));
EXTERN unsigned int	TkGS_GetDrawableLineWidth  _ANSI_ARGS_((
			    TkGS_Drawable drawable));
EXTERN TkGS_Font	TkGS_GetDrawableFont _ANSI_ARGS_((
			    TkGS_Drawable drawable));

/* 
 * Drawing primitives 
 */

/* Line and shape primitives */

/* The following macro allows easy definition of primitives */
#define TKGS_CALLPRIMITIVE(d, primitive, mask, args) \
    ( \
	TkGSUpdateDrawableState(d, mask), \
	TKGS_GETDEVICEMEMBER(d, primitive) args \
    )

#define TkGS_DrawRectangle(d, filled, x, y, width, height) \
    TKGS_CALLPRIMITIVE(d, drawRectangle, (TkGS_GCForeground|TkGS_GCLineWidth), \
	(d, filled, x, y, width, height))

#define TkGS_DrawRectangles(d, filled, rectangles, nbRectangles) \
    TKGS_CALLPRIMITIVE(d, drawRectangle, (TkGS_GCForeground|TkGS_GCLineWidth), \
	(d, filled, rectangles, nbRectangles))

#define TkGS_FillRectangle(d, color, x, y, width, height) \
    TKGS_CALLPRIMITIVE(d, fillRectangle, 0, \
	(d, color, x, y, width, height))

#define TkGS_FillRectangles(d, color, rectangles, nbRectangles) \
    TKGS_CALLPRIMITIVE(d, fillRectangles, 0, \
	(d, color, rectangles, nbRectangles))

#define TkGS_DrawEllipse(d, filled, x, y, width, height) \
    TKGS_CALLPRIMITIVE(d, drawEllipse, (TkGS_GCForeground|TkGS_GCLineWidth), \
	(d, filled, x, y, width, height))

#define TkGS_DrawEllipses(d, filled, ellipses, nbEllipses) \
    TKGS_CALLPRIMITIVE(d, drawEllipse, (TkGS_GCForeground|TkGS_GCLineWidth), \
	(d, filled, ellipses, nbEllipses))


/* 
 * Fonts and text primitives
 */

/* Flags passed to TkGS_MeasureChars: */

#define TKGS_WHOLE_WORDS	1
#define TKGS_AT_LEAST_ONE	2
#define TKGS_PARTIAL_OK		4


#define TkGS_GetActualFontAttributes(d, font, faPtr) \
    TKGS_CALLPRIMITIVE(d, getActualFontAttributes, 0, \
	(d, font, faPtr))

#define TkGS_GetFontMetrics(d, font, fmPtr) \
    TKGS_CALLPRIMITIVE(d, getFontMetrics, 0, \
	(d, font, fmPtr))

#define TkGS_EnumerateFontFamilies(d, name, enumProc, clientData) \
    TKGS_CALLPRIMITIVE(d, enumerateFontFamilies, 0, \
	(d, name, enumProc, clientData))

#define TkGS_FontFamilyExists(d, name) \
    TKGS_CALLPRIMITIVE(d, fontFamilyExists, 0, \
	(d, name))


/* Unicode-specific primitives */

EXTERN int		TkGS_MeasureCharsUni _ANSI_ARGS_((TkGS_Drawable d,
			    CONST TkGS_StringUni string, int length, 
			    int maxPixels, int flags, int *lengthPtr));
EXTERN int		TkGS_TextWidthUni _ANSI_ARGS_((TkGS_Drawable d,
			    CONST TkGS_StringUni string, int length));
EXTERN void		TkGS_DrawCharsUni _ANSI_ARGS_((TkGS_Drawable d,
			    CONST TkGS_StringUni string, int length,
			    int x, int y, int *widthPtr));
EXTERN void		TkGS_UnderlineCharsUni _ANSI_ARGS_((TkGS_Drawable d,
			    CONST TkGS_StringUni string, int length,
			    int x, int y, int first, int last));

/* UTF-8-specific primitives */

EXTERN int		TkGS_MeasureCharsUtf _ANSI_ARGS_((TkGS_Drawable d,
			    CONST TkGS_StringUtf string, int length, 
			    int maxPixels, int flags, int *lengthPtr));
EXTERN int		TkGS_TextWidthUtf _ANSI_ARGS_((TkGS_Drawable d,
			    CONST TkGS_StringUtf string, int length));
EXTERN void		TkGS_DrawCharsUtf _ANSI_ARGS_((TkGS_Drawable d,
			    CONST TkGS_StringUtf string, int length,
			    int x, int y, int *widthPtr));
EXTERN void		TkGS_UnderlineCharsUtf _ANSI_ARGS_((TkGS_Drawable d,
			    CONST TkGS_StringUtf string, int length,
			    int x, int y, int first, int last));

/* System-specific primitives */

EXTERN int		TkGS_MeasureCharsSys _ANSI_ARGS_((TkGS_Drawable d,
			    CONST TkGS_StringSys string, int length, 
			    int maxPixels, int flags, int *lengthPtr));
EXTERN int		TkGS_TextWidthSys _ANSI_ARGS_((TkGS_Drawable d,
			    CONST TkGS_StringSys string, int length));
EXTERN void		TkGS_DrawCharsSys _ANSI_ARGS_((TkGS_Drawable d,
			    CONST TkGS_StringSys string, int length,
			    int x, int y, int *widthPtr));
EXTERN void		TkGS_UnderlineCharsSys _ANSI_ARGS_((TkGS_Drawable d,
			    CONST TkGS_StringSys string, int length,
			    int x, int y, int first, int last));

/* Generic primitives */

#if (TKGS_STRING_FORMAT == TKGS_UNICODE)
#   define TkGS_MeasureChars		TkGS_MeasureCharsUni
#   define TkGS_TextWidth		TkGS_TextWidthUni
#   define TkGS_DrawChars		TkGS_DrawCharsUni
#   define TkGS_UnderlineChars		TkGS_UnderlineCharsUni
#elif (TKGS_STRING_FORMAT == TKGS_UTF)
#   define TkGS_MeasureChars		TkGS_MeasureCharsUtf
#   define TkGS_TextWidth		TkGS_TextWidthUtf
#   define TkGS_DrawChars		TkGS_DrawCharsUtf
#   define TkGS_UnderlineChars		TkGS_UnderlineCharsUtf
#else
#   define TkGS_MeasureChars		TkGS_MeasureCharsSys
#   define TkGS_TextWidth		TkGS_TextWidthSys
#   define TkGS_DrawChars		TkGS_DrawCharsSys
#   define TkGS_UnderlineChars		TkGS_UnderlineCharsSys
#endif





/* Tk-specific procedure: retrieve a drawable from a window */

EXTERN TkGS_Drawable	TkGS_GetWindowDrawable _ANSI_ARGS_((Tk_Window tkwin));




/*
 * end of tkgs.h
 * reset TCL_STORAGE_CLASS to DLLIMPORT.
 */

#undef TCL_STORAGE_CLASS
#define TCL_STORAGE_CLASS DLLIMPORT


#endif /* _TKGS */
