#include "tkgs.h"
#include "tkgsInt.h"


/* 
 * Public interface
 */

TkGS_Drawable
TkGS_GetDrawable(device, clientData)
    TkGS_Device	device;
    ClientData	clientData;
{
    TkGS_Drawable d = ((TkGS_DeviceDriver *) device)->getDrawable(clientData);;

    if (d) {
	TkGS_IncrRefCount((TkGS_Obj *) d);
    }
    return d;
}

void
TkGS_ReleaseDrawable(d)
    TkGS_Drawable d;
{
    TkGS_DecrRefCount((TkGS_Obj *) d);
}

TkGS_Device
TkGS_GetDrawableDevice(d)
    TkGS_Drawable d;
{
    return TkGSDrawable_Device(d);
}





TkGS_Color
TkGS_GetSystemColor(systemColor)
    int systemColor;
{
    TkGS_Color_ *colorPtr = TkGSNewSystemColor(systemColor);
    TkGS_IncrRefCount((TkGS_Obj *) colorPtr);

    return (TkGS_Color) colorPtr;
}

TkGS_Color
TkGS_GetRGBColor(red, green, blue)
    unsigned short red;
    unsigned short green;
    unsigned short blue;
{
    TkGS_Color_ *colorPtr = TkGSNewRGBColor(red, green, blue);
    TkGS_IncrRefCount((TkGS_Obj *) colorPtr);

    return (TkGS_Color) colorPtr;
}

int
TkGS_GetColorType(color)
    TkGS_Color color;
{
    return TkGSColor_Type(color);
}

int
TkGS_GetSystemColorValue(color)
    TkGS_Color color;
{
    if (TkGSColor_Type(color) == TKGS_COLOR_SYSTEM) {
	return TkGSColor_SystemColor(color);
    } else {
	return -1;
    }
}

void
TkGS_GetRGBColorValues(color, redPtr, greenPtr, bluePtr)
    TkGS_Color     color;
    unsigned short *redPtr;
    unsigned short *greenPtr;
    unsigned short *bluePtr;
{
    switch (TkGSColor_Type(color)) {
	case TKGS_COLOR_SYSTEM:
	    TkGSpGetSystemColorRGBValues(TkGSColor_SystemColor(color), 
		redPtr, greenPtr, bluePtr);
	    break;

	case TKGS_COLOR_RGB: {
	    unsigned short *rgb = TkGSColor_RGB(color);
	    *redPtr   = rgb[0];
	    *greenPtr = rgb[1];
	    *bluePtr  = rgb[2];
	    break;
	}
    }
}


void
TkGS_FreeColor(color)
    TkGS_Color color;
{
    TkGS_DecrRefCount((TkGS_Obj *) color);
}



TkGS_FontFaces
TkGS_GetFontFace(name)
    char *name;
{
    TkGS_FontFaces_ *fnPtr = TkGSNewFontFace(name);
    TkGS_IncrRefCount((TkGS_Obj *) fnPtr);

    return (TkGS_FontFaces) fnPtr;
}

TkGS_FontFaces
TkGS_GetFontFaces(nbNames, names)
    int  nbNames;
    char **names;
{
    TkGS_FontFaces_ *fnPtr = TkGSNewFontFaces(nbNames, names);
    TkGS_IncrRefCount((TkGS_Obj *) fnPtr);

    return (TkGS_FontFaces) fnPtr;
}

void
TkGS_FreeFontFaces(fontFaces)
    TkGS_FontFaces fontFaces;
{
    TkGS_DecrRefCount((TkGS_Obj *) fontFaces);
}

int
TkGS_GetNbFontFaces(fontFaces)
    TkGS_FontFaces fontFaces;
{
    return TkGSFontFaces_NbNames(fontFaces);
}

char *
TkGS_GetFontFaceName(fontFaces, nb)
    TkGS_FontFaces fontFaces;
    int		   nb;
{
    return TkGSFontFaces_Names(fontFaces)[nb];
}



TkGS_Font
TkGS_GetFont(faPtr)
    TkGS_FontAttributes *faPtr;
{
    TkGS_Font_ *fontPtr = TkGSNewFont(faPtr);
    TkGS_IncrRefCount((TkGS_Obj *) fontPtr);

    return (TkGS_Font) fontPtr;
}

void
TkGS_FreeFont(font)
    TkGS_Font font;
{
    TkGS_DecrRefCount((TkGS_Obj *) font);
}

void
TkGS_GetFontAttributes(font, faPtr)
    TkGS_Font		font;
    TkGS_FontAttributes *faPtr;
{
    *faPtr = TkGSFont_Attributes(font);
}






void 
TkGS_SetGCValues(drawable, valueMask, values)
    TkGS_Drawable drawable;
    unsigned long valueMask;
    TkGS_GCValues *values;
{
    register TkGS_GCValues *gcValues = &TkGSDrawable_GCValues(drawable);


    if (valueMask & TkGS_GCForeground) {
	TkGS_IncrRefCount((TkGS_Obj *) values->foreground);
	TkGS_DecrRefCount((TkGS_Obj *) gcValues->foreground);
	gcValues->foreground = values->foreground;
    }
    if (valueMask & TkGS_GCBackground) {
	TkGS_IncrRefCount((TkGS_Obj *) values->background);
	TkGS_DecrRefCount((TkGS_Obj *) gcValues);
	gcValues->background = values->background;
    }
    if (valueMask & TkGS_GCLineWidth) {
	gcValues->lineWidth = values->lineWidth;
    }
    if (valueMask & TkGS_GCFont) {
	TkGS_IncrRefCount((TkGS_Obj *) values->font);
	TkGS_DecrRefCount((TkGS_Obj *) gcValues->font);
	gcValues->font = values->font;
    }
    TkGSDrawable_GCValueMask(drawable) |= valueMask;
}

void 
TkGS_GetGCValues(drawable, valueMask, values)
    TkGS_Drawable drawable;
    unsigned long valueMask;
    TkGS_GCValues *values;
{
    register TkGS_GCValues *gcValues = &TkGSDrawable_GCValues(drawable);

    if (valueMask & TkGS_GCForeground) {
	values->foreground = gcValues->foreground;
    }
    if (valueMask & TkGS_GCBackground) {
	values->background = gcValues->background;
    }
    if (valueMask & TkGS_GCLineWidth) {
	values->lineWidth = gcValues->lineWidth;
    }
    if (valueMask & TkGS_GCFont) {
	/* FIXME: do we have to increment the refcount? Given that
	 * TkGS_GCValues structures are not refcounted. We must
	 * document that.
	 */
	values->font = gcValues->font;
    }
}

void 
TkGS_SetDrawableForeground(drawable, color)
    TkGS_Drawable drawable;
    TkGS_Color    color;
{
    register TkGS_GCValues *gcValues = &TkGSDrawable_GCValues(drawable);

    TkGS_IncrRefCount((TkGS_Obj *) color);
    TkGS_DecrRefCount((TkGS_Obj *) gcValues->foreground);
    gcValues->foreground = color;
    TkGSDrawable_GCValueMask(drawable) |= TkGS_GCForeground;
}

TkGS_Color
TkGS_GetDrawableForeground(drawable)
    TkGS_Drawable drawable;
{
    return TkGSDrawable_GCValues(drawable).foreground;
}

void 
TkGS_SetDrawableBackground(drawable, color)
    TkGS_Drawable drawable;
    TkGS_Color    color;
{
    register TkGS_GCValues *gcValues = &TkGSDrawable_GCValues(drawable);

    TkGS_IncrRefCount((TkGS_Obj *) color);
    TkGS_DecrRefCount((TkGS_Obj *) gcValues->background);
    gcValues->background = color;
    TkGSDrawable_GCValueMask(drawable) |= TkGS_GCBackground;
}

TkGS_Color
TkGS_GetDrawableBackground(drawable)
    TkGS_Drawable drawable;
{
    return TkGSDrawable_GCValues(drawable).background;
}

void 
TkGS_SetDrawableLineWidth(drawable, lineWidth)
    TkGS_Drawable drawable;
    unsigned int  lineWidth;
{
    register TkGS_GCValues *gcValues = &TkGSDrawable_GCValues(drawable);

    gcValues->lineWidth = lineWidth;
    TkGSDrawable_GCValueMask(drawable) |= TkGS_GCLineWidth;
}

unsigned int
TkGS_GetDrawableLineWidth(drawable)
    TkGS_Drawable drawable;
{
    return TkGSDrawable_GCValues(drawable).lineWidth;
}

void 
TkGS_SetDrawableFont(drawable, font)
    TkGS_Drawable drawable;
    TkGS_Font     font;
{
    register TkGS_GCValues *gcValues = &TkGSDrawable_GCValues(drawable);

    TkGS_IncrRefCount((TkGS_Obj *) font);
    if (gcValues->font) {
	TkGS_DecrRefCount((TkGS_Obj *) gcValues->font);
    }
    gcValues->font = font;
    TkGSDrawable_GCValueMask(drawable) |= TkGS_GCFont;
}

TkGS_Font
TkGS_GetDrawableFont(drawable)
    TkGS_Drawable drawable;
{
    return TkGSDrawable_GCValues(drawable).font;
}




