/* 
 * tkgsSquare.c --
 *
 *  This file was converted from the tkSquare.c in the Tk distribution,
 *  and converted to use TkGS instead of plain Tk/Xlib calls. Original
 *  header information:
 *
 *	This module implements "square" widgets that are object
 *	based.  A "square" is a widget that displays a single square that can 
 *	be moved around and resized.  This file is intended as an example
 *	of how to build a widget;  it isn't included in the
 *	normal wish, but it is included in "tktest".
 *
 * Copyright (c) 1997 Sun Microsystems, Inc.
 *
 * Copyright (c) 1999-2000 Frederic BONNET.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * RCS: @(#) $Id: tkgsSquare.c,v 1.10 2001/09/02 20:59:44 fbonnet Exp $
 */

#include "tkgsSquare.h"

#include <tkgs.h>
#include <tkgsTk.h>

/* For fonts */
#include <tkgsTkFont.h>

/* For canvas string output */
#include <drivers/canvas/tkgsCanvas.h>
TkGS_Device CanvasDriver;

/* For PostScript output */
#include <drivers/ps/tkgsPS.h>
TkGS_Device PSDriver;

/* TkGS_Color object type conversion */
TkGS_Color		TkGS_GetColorFromObj _ANSI_ARGS_((Tcl_Interp *interp, 
			    Tcl_Obj *objPtr));


/*
 * A data structure of the following type is kept for each square
 * widget managed by this file:
 */

typedef struct {
    Tk_Window tkwin;		/* Window that embodies the square.  NULL
				 * means window has been deleted but
				 * widget record hasn't been cleaned up yet. */
    Display *display;		/* X's token for the window's display. */
    Tcl_Interp *interp;		/* Interpreter associated with widget. */
    Tcl_Command widgetCmd;	/* Token for square's widget command. */
    Tk_OptionTable optionTable;	/* Token representing the configuration
				 * specifications. */
    Tcl_Obj *xPtr, *yPtr;	/* Position of square's upper-left corner
				 * within widget. */
    int x, y;
    Tcl_Obj *sizeObjPtr;	/* Width and height of square. */

    /*
     * Information used when displaying widget:
     */

    Tcl_Obj *borderWidthPtr;	/* Width of 3-D border around whole widget. */
    Tcl_Obj *bgBorderPtr;
    Tcl_Obj *fgBorderPtr;
    Tcl_Obj *fontPtr;
    TkGSTk_3DBorder background2;
    TkGSTk_3DBorder foreground2;
    TkGSTk_Font tkfont2;		/* Font to use. */

    Tcl_Obj *reliefPtr;
    Tcl_Obj *doubleBufferPtr;	/* Non-zero means double-buffer redisplay
				 * with pixmap;  zero means draw straight
				 * onto the display. */
    int updatePending;		/* Non-zero means a call to SquareDisplay
				 * has already been scheduled. */
} Square;

/*
 * Information used for argv parsing.
 */

static Tk_OptionSpec configSpecs[] = {
    {TK_OPTION_STRING, "-background", "background", "Background",
	    "#d9d9d9", Tk_Offset(Square, bgBorderPtr), -1, 0,
	    (ClientData) "white"},
    {TK_OPTION_SYNONYM, "-bd", (char *) NULL, (char *) NULL,
	    (char *) NULL, 0, -1, 0, (ClientData) "-borderwidth"},
    {TK_OPTION_SYNONYM, "-bg", (char *) NULL, (char *) NULL,
	    (char *) NULL, 0, -1, 0, (ClientData) "-background"},
    {TK_OPTION_PIXELS, "-borderwidth", "borderWidth", "BorderWidth",
	    "2", Tk_Offset(Square, borderWidthPtr), -1},
    {TK_OPTION_BOOLEAN, "-dbl", "doubleBuffer", "DoubleBuffer",
	    "1", Tk_Offset(Square, doubleBufferPtr), -1},
    {TK_OPTION_SYNONYM, "-fg", (char *) NULL, (char *) NULL,
	    (char *) NULL, 0, -1, 0, (ClientData) "-foreground"},
    {TK_OPTION_STRING, "-font", "font", "Font",
	    "Helvetica 12", Tk_Offset(Square, fontPtr), -1},
    {TK_OPTION_STRING, "-foreground", "foreground", "Foreground",
	    "#b03060", Tk_Offset(Square, fgBorderPtr), -1, 0,
	    (ClientData) "black"},
    {TK_OPTION_PIXELS, "-posx", "posx", "PosX", "0",
	    Tk_Offset(Square, xPtr), -1},
    {TK_OPTION_PIXELS, "-posy", "posy", "PosY", "0",
	    Tk_Offset(Square, yPtr), -1},
    {TK_OPTION_RELIEF, "-relief", "relief", "Relief",
	    "raised", Tk_Offset(Square, reliefPtr), -1},
    {TK_OPTION_PIXELS, "-size", "size", "Size", "20",
	    Tk_Offset(Square, sizeObjPtr), -1},
    {TK_OPTION_END}
};

/*
 * Forward declarations for procedures defined later in this file:
 */

int			SquareObjCmd _ANSI_ARGS_((ClientData clientData,
			    Tcl_Interp *interp, int objc, 
			    Tcl_Obj * CONST objv[]));
static void		SquareDeletedProc _ANSI_ARGS_((
			    ClientData clientData));
static int		SquareConfigure _ANSI_ARGS_((Tcl_Interp *interp,
			    Square *squarePtr));
static void		SquareDestroy _ANSI_ARGS_((char *memPtr));
static void		SquareTkGSDraw _ANSI_ARGS_((Square *squarePtr,
			    TkGS_Drawable drawable, int width, int height));
static void		SquareDisplay _ANSI_ARGS_((ClientData clientData));
static void		KeepInWindow _ANSI_ARGS_((Square *squarePtr));
static void		SquareObjEventProc _ANSI_ARGS_((ClientData clientData,
			    XEvent *eventPtr));
static int		SquareWidgetCmd _ANSI_ARGS_((ClientData clientData,
			    Tcl_Interp *, int objc, Tcl_Obj * CONST objv[]));
static int		SquareCanvasScript _ANSI_ARGS_((Tcl_Interp *, 
			    Square *));
static int		SquarePostScript _ANSI_ARGS_((Tcl_Interp *, 
			    Square *));

/*
 *--------------------------------------------------------------
 *
 * SquareCmd --
 *
 *	This procedure is invoked to process the "square" Tcl
 *	command.  It creates a new "square" widget.
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	A new widget is created and configured.
 *
 *--------------------------------------------------------------
 */

int
SquareObjCmd(clientData, interp, objc, objv)
    ClientData clientData;	/* Main window associated with
				 * interpreter. */
    Tcl_Interp *interp;		/* Current interpreter. */
    int objc;			/* Number of arguments. */
    Tcl_Obj * CONST objv[];	/* Argument objects. */
{
    Square *squarePtr;
    Tk_Window tkwin;
    Tk_OptionTable optionTable = (Tk_OptionTable) clientData;
    Tcl_CmdInfo info;
    char *commandName;
    Tk_SavedOptions savedOptions;

    if (optionTable == NULL) {
	/*
	 * The first time this procedure is invoked, optionTable will
	 * be NULL.  We then create the option table from the template
	 * and store the table pointer as the command's clinical so
	 * we'll have easy access to it in the future.
	 */

	optionTable = Tk_CreateOptionTable(interp, configSpecs);
	commandName = Tcl_GetStringFromObj(objv[0], (int *) NULL);
	Tcl_GetCommandInfo(interp, commandName, &info);
	info.clientData = (ClientData) optionTable;
	Tcl_SetCommandInfo(interp, commandName, &info);
    }

    if (objc < 2) {
	Tcl_WrongNumArgs(interp, 1, objv, "pathName ?options?");
	return TCL_ERROR;
    }

    tkwin = Tk_CreateWindowFromPath(interp, Tk_MainWindow(interp), 
	    Tcl_GetStringFromObj(objv[1], NULL), (char *) NULL);
    if (tkwin == NULL) {
	return TCL_ERROR;
    }
    Tk_SetClass(tkwin, "Square");

    /*
     * Allocate and initialize the widget record.
     */

    squarePtr = (Square *) ckalloc(sizeof(Square));
    squarePtr->tkwin = tkwin;
    squarePtr->display = Tk_Display(tkwin);
    squarePtr->interp = interp;
    squarePtr->widgetCmd = Tcl_CreateObjCommand(interp,
	    Tk_PathName(squarePtr->tkwin), SquareWidgetCmd,
	    (ClientData) squarePtr, SquareDeletedProc);
    squarePtr->xPtr = NULL;
    squarePtr->yPtr = NULL;
    squarePtr->x = 0;
    squarePtr->y = 0;
    squarePtr->sizeObjPtr = NULL;
    squarePtr->borderWidthPtr = NULL;
    squarePtr->bgBorderPtr = NULL;
    squarePtr->fgBorderPtr = NULL;
    squarePtr->fontPtr = NULL;
    squarePtr->reliefPtr = NULL;
    squarePtr->doubleBufferPtr = NULL;
    squarePtr->updatePending = 0;
    squarePtr->optionTable = optionTable;

    if (Tk_InitOptions(interp, (char *) squarePtr, optionTable, tkwin)
	    != TCL_OK) {
	Tk_DestroyWindow(squarePtr->tkwin);
	ckfree((char *) squarePtr);
	return TCL_ERROR;
    }

    Tk_CreateEventHandler(squarePtr->tkwin, ExposureMask|StructureNotifyMask,
	    SquareObjEventProc, (ClientData) squarePtr);
    if (Tk_SetOptions(interp, (char *) squarePtr, optionTable, objc - 2,
	    objv + 2, tkwin, &savedOptions, (int *) NULL) != TCL_OK) {
	goto error;
    }
    if (SquareConfigure(interp, squarePtr) != TCL_OK) {	
	Tk_RestoreSavedOptions(&savedOptions);
	goto error;
    }
    Tk_FreeSavedOptions(&savedOptions);

    Tcl_SetObjResult(interp, Tcl_NewStringObj(Tk_PathName(squarePtr->tkwin),
	    -1));
    return TCL_OK;

error:
    Tk_DestroyWindow(squarePtr->tkwin);
    return TCL_ERROR;
}

/*
 *--------------------------------------------------------------
 *
 * SquareWidgetCmd --
 *
 *	This procedure is invoked to process the Tcl command
 *	that corresponds to a widget managed by this module.
 *	See the user documentation for details on what it does.
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	See the user documentation.
 *
 *--------------------------------------------------------------
 */

static int
SquareWidgetCmd(clientData, interp, objc, objv)
    ClientData clientData;		/* Information about square widget. */
    Tcl_Interp *interp;			/* Current interpreter. */
    int objc;				/* Number of arguments. */
    Tcl_Obj * CONST objv[];		/* Argument objects. */
{
    Square *squarePtr = (Square *) clientData;
    int result = TCL_OK;
    static char *squareOptions[] = {"canvasscript", "cget", "configure", 
	"postscript", (char *) NULL};
    enum {
	SQUARE_CANVASSCRIPT, SQUARE_CGET, SQUARE_CONFIGURE, SQUARE_POSTSCRIPT
    };
    Tcl_Obj *resultObjPtr;
    int index;

    if (objc < 2) {
	Tcl_WrongNumArgs(interp, 1, objv, "option ?arg arg...?");
	return TCL_ERROR;
    }

    if (Tcl_GetIndexFromObj(interp, objv[1], squareOptions, "command",
	    0, &index) != TCL_OK) {
	return TCL_ERROR;
    }

    Tcl_Preserve((ClientData) squarePtr);
    
    switch (index) {
	case SQUARE_CGET: {
	    if (objc != 3) {
		Tcl_WrongNumArgs(interp, 2, objv, "option");
		goto error;
	    }
	    resultObjPtr = Tk_GetOptionValue(interp, (char *) squarePtr,
		    squarePtr->optionTable, objv[2], squarePtr->tkwin);
	    if (resultObjPtr == NULL) {
		result = TCL_ERROR;
	    } else {
		Tcl_SetObjResult(interp, resultObjPtr);
	    }
	    break;
	}
	case SQUARE_CONFIGURE: {
	    resultObjPtr = NULL;
	    if (objc == 2) {
		resultObjPtr = Tk_GetOptionInfo(interp, (char *) squarePtr,
			squarePtr->optionTable, (Tcl_Obj *) NULL,
			squarePtr->tkwin);
		if (resultObjPtr == NULL) {
		    result = TCL_ERROR;
		}
	    } else if (objc == 3) {
		resultObjPtr = Tk_GetOptionInfo(interp, (char *) squarePtr,
			squarePtr->optionTable, objv[2], squarePtr->tkwin);
		if (resultObjPtr == NULL) {
		    result = TCL_ERROR;
		}
	    } else {
		Tk_SavedOptions savedOptions;

		result = Tk_SetOptions(interp, (char *) squarePtr,
			squarePtr->optionTable, objc - 2, objv + 2,
			squarePtr->tkwin, &savedOptions, (int *) NULL);
		if (result == TCL_OK) {
		    result = SquareConfigure(interp, squarePtr);
		    if (result == TCL_ERROR) {
			Tk_RestoreSavedOptions(&savedOptions);
		    } else {
			Tk_FreeSavedOptions(&savedOptions);
		    }
		}
		if (!squarePtr->updatePending) {
		    Tcl_DoWhenIdle(SquareDisplay, (ClientData) squarePtr);
		    squarePtr->updatePending = 1;
		}
	    }
	    if (resultObjPtr != NULL) {
		Tcl_SetObjResult(interp, resultObjPtr);
	    }
	    break;
	}
	case SQUARE_CANVASSCRIPT: {
	    if (!CanvasDriver) {
		Tcl_AppendResult(interp, "canvas driver not available", NULL);
		result = TCL_ERROR;
	    } else {
		result = SquareCanvasScript(interp, squarePtr);
	    }
	    break;
	}
	case SQUARE_POSTSCRIPT: {
	    if (!PSDriver) {
		Tcl_AppendResult(interp, "postscript driver not available", NULL);
		result = TCL_ERROR;
		break;
	    } else {
		result = SquarePostScript(interp, squarePtr);
	    }
	    break;
	}
    }
    Tcl_Release((ClientData) squarePtr);
    return result;

    error:
    Tcl_Release((ClientData) squarePtr);
    return TCL_ERROR;
}

/*
 *----------------------------------------------------------------------
 *
 * SquareConfigure --
 *
 *	This procedure is called to process an argv/argc list in
 *	conjunction with the Tk option database to configure (or
 *	reconfigure) a square widget.
 *
 * Results:
 *	The return value is a standard Tcl result.  If TCL_ERROR is
 *	returned, then the interp's result contains an error message.
 *
 * Side effects:
 *	Configuration information, such as colors, border width,
 *	etc. get set for squarePtr;  old resources get freed,
 *	if there were any.
 *
 *----------------------------------------------------------------------
 */

static int
SquareConfigure(interp, squarePtr)
    Tcl_Interp *interp;			/* Used for error reporting. */
    Square *squarePtr;			/* Information about widget. */
{
    int borderWidth;
    int doubleBuffer;

    /*
     * Allocate specific options.
     */

    /* Parse colors */
    if (!TkGSTk_Alloc3DBorderFromObj(interp, squarePtr->bgBorderPtr)) {
	return TCL_ERROR;
    }
    if (!TkGSTk_Alloc3DBorderFromObj(interp, squarePtr->fgBorderPtr)) {
	return TCL_ERROR;
    }

    /* Parse font */
    if (!TkGSTk_AllocFontFromObj(interp, squarePtr->tkwin, squarePtr->fontPtr)) {
	return TCL_ERROR;
    }

    /*
     * Set the background for the window 
     */
    /* TODO: set window background */
    /*Tk_SetWindowBackground(squarePtr->tkwin,
	    Tk_3DBorderColor(bgBorder)->pixel);*/

    Tcl_GetBooleanFromObj(NULL, squarePtr->doubleBufferPtr, &doubleBuffer);

    /*
     * Register the desired geometry for the window.  Then arrange for
     * the window to be redisplayed.
     */

    Tk_GeometryRequest(squarePtr->tkwin, 200, 150);
    Tk_GetPixelsFromObj(NULL, squarePtr->tkwin, squarePtr->borderWidthPtr,
	    &borderWidth);
    Tk_SetInternalBorder(squarePtr->tkwin, borderWidth);
    if (!squarePtr->updatePending) {
	Tcl_DoWhenIdle(SquareDisplay, (ClientData) squarePtr);
	squarePtr->updatePending = 1;
    }
    KeepInWindow(squarePtr);
    return TCL_OK;
}

/*
 *--------------------------------------------------------------
 *
 * SquareObjEventProc --
 *
 *	This procedure is invoked by the Tk dispatcher for various
 *	events on squares.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	When the window gets deleted, internal structures get
 *	cleaned up.  When it gets exposed, it is redisplayed.
 *
 *--------------------------------------------------------------
 */

static void
SquareObjEventProc(clientData, eventPtr)
    ClientData clientData;	/* Information about window. */
    XEvent *eventPtr;		/* Information about event. */
{
    Square *squarePtr = (Square *) clientData;

    if (eventPtr->type == Expose) {
	if (!squarePtr->updatePending) {
	    Tcl_DoWhenIdle(SquareDisplay, (ClientData) squarePtr);
	    squarePtr->updatePending = 1;
	}
    } else if (eventPtr->type == ConfigureNotify) {
	KeepInWindow(squarePtr);
	if (!squarePtr->updatePending) {
	    Tcl_DoWhenIdle(SquareDisplay, (ClientData) squarePtr);
	    squarePtr->updatePending = 1;
	}
    } else if (eventPtr->type == DestroyNotify) {
	if (squarePtr->tkwin != NULL) {
	    /*
	     * Free specific options.
	     */

	    /* Colors */
	    TkGSTk_Free3DBorderFromObj(squarePtr->bgBorderPtr);
	    TkGSTk_Free3DBorderFromObj(squarePtr->fgBorderPtr);

	    /* Font */
	    TkGSTk_FreeFontFromObj(squarePtr->tkwin, squarePtr->fontPtr);

	    /*
	     * Free generic options.
	     */

	    Tk_FreeConfigOptions((char *) squarePtr, squarePtr->optionTable,
		    squarePtr->tkwin);

	    squarePtr->tkwin = NULL;
	    Tcl_DeleteCommandFromToken(squarePtr->interp,
		    squarePtr->widgetCmd);
	}
	if (squarePtr->updatePending) {
	    Tcl_CancelIdleCall(SquareDisplay, (ClientData) squarePtr);
	}
	Tcl_EventuallyFree((ClientData) squarePtr, SquareDestroy);
    }
}

/*
 *----------------------------------------------------------------------
 *
 * SquareDeletedProc --
 *
 *	This procedure is invoked when a widget command is deleted.  If
 *	the widget isn't already in the process of being destroyed,
 *	this command destroys it.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	The widget is destroyed.
 *
 *----------------------------------------------------------------------
 */

static void
SquareDeletedProc(clientData)
    ClientData clientData;	/* Pointer to widget record for widget. */
{
    Square *squarePtr = (Square *) clientData;
    Tk_Window tkwin = squarePtr->tkwin;

    /*
     * This procedure could be invoked either because the window was
     * destroyed and the command was then deleted (in which case tkwin
     * is NULL) or because the command was deleted, and then this procedure
     * destroys the widget.
     */

    if (tkwin != NULL) {
	Tk_DestroyWindow(tkwin);
    }
}

/*
 *--------------------------------------------------------------
 *
 * SquareDisplay --
 *
 *	This procedure redraws the contents of a square window.
 *	It is invoked as a do-when-idle handler, so it only runs
 *	when there's nothing else for the application to do.
 *	It invokes the TkGS drawing procedure SquareTkGSDraw on
 *	the window's TkGS drawable.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	Information appears on the screen.
 *
 *--------------------------------------------------------------
 */

static void
SquareDisplay(clientData)
    ClientData clientData;	/* Information about window. */
{
    Square *squarePtr = (Square *) clientData;
    Tk_Window tkwin = squarePtr->tkwin;

    TkGS_Drawable tkgsd;

    squarePtr->updatePending = 0;
    if (!Tk_IsMapped(tkwin)) {
	return;
    }

    /* Get a TkGS drawable from the Tk window */
    tkgsd = TkGS_GetWindowDrawable(tkwin);

    /* Call device-independent TkGS drawing proc */
    SquareTkGSDraw(squarePtr, tkgsd, Tk_Width(tkwin), Tk_Height(tkwin));

    TkGS_ReleaseDrawable(tkgsd);
}

/*
 *--------------------------------------------------------------
 *
 * InterpAppendResult --
 *
 *	Callback used by SquareCanvasScript and SquarePostScript to append
 *	their result to the given interpreter.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	None.
 *
 *--------------------------------------------------------------
 */

static void InterpAppendResult(clientData, string, length)
    ClientData clientData;
    char *string;
    int length;
{
    Tcl_Interp *interp = (Tcl_Interp *) clientData;

    Tcl_AppendToObj(Tcl_GetObjResult(interp), string, length);
}

/*
 *--------------------------------------------------------------
 *
 * SquareCanvasScript --
 *
 *	This procedure generates a string containing Tk canvas 
 *	commands from a square window.
 *	It invokes the TkGS drawing procedure SquareTkGSDraw on
 *	a newly created canvas TkGS drawable.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	None.
 *
 *--------------------------------------------------------------
 */

static int		
SquareCanvasScript(interp, squarePtr)
    Tcl_Interp *interp;
    Square *squarePtr;
{
    TkGS_Drawable tkgsd;
    Tk_Window tkwin = squarePtr->tkwin;
    CanvasDrawableCreateData cd;

    /* 
     * Initialize drawable creation data 
     */

    cd.appendResultProc = (CanvasDrawableAppendResultProc*) InterpAppendResult;
    cd.clientData = (ClientData) interp;


    Tcl_ResetResult(interp);

    /* Get a "canvas script" drawable */
    tkgsd = TkGS_GetDrawable(CanvasDriver, (ClientData) &cd);

    /* Call device-independent TkGS drawing proc */
    SquareTkGSDraw(squarePtr, tkgsd, Tk_Width(tkwin), Tk_Height(tkwin));

    TkGS_ReleaseDrawable(tkgsd);

    return TCL_OK;
}

/*
 *--------------------------------------------------------------
 *
 * SquarePostScript --
 *
 *	This procedure generates a string containing Tk canvas 
 *	commands from a square window.
 *	It invokes the TkGS drawing procedure SquareTkGSDraw on
 *	a newly created PostScript TkGS drawable.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	None.
 *
 *--------------------------------------------------------------
 */

static int		
SquarePostScript(interp, squarePtr)
    Tcl_Interp *interp;
    Square *squarePtr;
{
    TkGS_Drawable tkgsd;
    Tk_Window tkwin = squarePtr->tkwin;
    PSDrawableCreateData cd;

    /* 
     * Initialize drawable creation data 
     */

    /* Width and height of display area */
    cd.width  = Tk_Width(tkwin);
    cd.height = Tk_Height(tkwin);

    /* Pixel scaling. For now, doesn't use the screen's pixel width */
    cd.pixelWidth = cd.pixelHeight = 1.0;   

    cd.appendResultProc = (PSDrawableAppendResultProc*) InterpAppendResult;
    cd.clientData = (ClientData) interp;


    Tcl_ResetResult(interp);

    /* Get a PostScript drawable */
    tkgsd = TkGS_GetDrawable(PSDriver, (ClientData) &cd);

    /* Call device-independent TkGS drawing proc */
    SquareTkGSDraw(squarePtr, tkgsd, Tk_Width(tkwin), Tk_Height(tkwin));

    TkGS_ReleaseDrawable(tkgsd);

    return TCL_OK;
}

/*
 *--------------------------------------------------------------
 *
 * SquareTkGSDraw --
 *
 *	This procedure redraws the contents of a square window.
 *	It invokes TkGS primitives on the specified drawable.
 *	It is a device-independent procedure, the drawable
 *	can belong to any TkGS-supported device (display, 
 *	printer...).
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	Information appears on the drawable.
 *
 *--------------------------------------------------------------
 */

static void
SquareTkGSDraw(squarePtr, drawable, width, height)
    Square *squarePtr;
    TkGS_Drawable drawable;
    int width;
    int height;
{
    int borderWidth, size, relief;
    TkGSTk_3DBorder bgBorder, fgBorder;
    TkGSTk_Font font;

    /*
     * Redraw the widget's background and border.
     */

    Tk_GetPixelsFromObj(NULL, squarePtr->tkwin, squarePtr->borderWidthPtr,
	    &borderWidth);
    bgBorder = TkGSTk_Get3DBorderFromObj(squarePtr->bgBorderPtr);
    Tk_GetReliefFromObj(NULL, squarePtr->reliefPtr, &relief);
    TkGSTk_Fill3DRectangle(drawable, bgBorder, 0, 0, width, height,
	    borderWidth, relief);

    /*
     * Display the square.
     */

    Tk_GetPixelsFromObj(NULL, squarePtr->tkwin, squarePtr->sizeObjPtr, &size);
    fgBorder = TkGSTk_Get3DBorderFromObj(squarePtr->fgBorderPtr);
    TkGSTk_Fill3DRectangle(drawable, fgBorder, squarePtr->x, squarePtr->y, size, 
	    size, borderWidth, TK_RELIEF_RAISED);

    {
	/* 
	 * Test of the new font handling:
	 *   we build 3 strings in Unicode, UTF-8 and system encoding, and
	 *   display them in the drawable. The results should be identical
	 *   for the three strings on a given drawable, with the exception
	 *   of characters not displayable by the system-specific call.
	 *   Note that some drivers only provide one version. If this is the
	 *   system-specific one, then of course some Unicode chars won't be 
	 *   displayed. The strings below use Latin-1 (iso8859-1). So if the 
	 *   system uses a different encoding (eg MacOS), only plain ASCII 
	 *   chars will be displayed correctly.
	 */

	Tcl_UniChar stringUni[] = {
	    'U', 'n', 'i', 'c', 'o' ,'d', 'e', ' ', 'e', 'n', 'c', 'o', 'd',
	    'i', 'n', 'g', ':', ' ', 0xE7, 0xC8, 0x2284, 0x06a9, 0x2115, '\0'
	};
	int lengthUni = 23;

	char stringUtf[] = {
	    'U', 'T', 'F', '-', '8', ' ', 'e', 'n', 'c', 'o', 'd', 'i', 'n',
	    'g', ':', ' ', (char) 0xC3, (char) 0xA7, (char) 0xC3, (char) 0x88, 
	    (char) 0xE2, (char) 0x8A, (char) 0x84, (char) 0xDA, (char) 0xA9, 
	    (char) 0xE2, (char) 0x84, (char) 0x95, '\0'
	};
	int lengthUtf = strlen(stringUtf);

	char *stringSys = "System encoding: \xE7\xC8";
	int lengthSys = strlen(stringSys);

	TkGS_Color color = TkGS_GetRGBColor(0xFFFF, 0, 0);
	TkGS_SetDrawableForeground(drawable, color);
	font = TkGSTk_GetFontFromObj(squarePtr->tkwin, squarePtr->fontPtr);
	TkGS_SetDrawableFont(drawable, ((TkGSTkFont *) font)->font);

	TkGS_DrawCharsUni(drawable, stringUni, lengthUni, 10, 20, NULL);
	TkGS_DrawCharsUtf(drawable, stringUtf, lengthUtf, 10, 40, NULL);
	TkGS_DrawCharsSys(drawable, stringSys, lengthSys, 10, 60, NULL);

	TkGS_FreeColor(color);
    }

}

/*
 *----------------------------------------------------------------------
 *
 * SquareDestroy --
 *
 *	This procedure is invoked by Tcl_EventuallyFree or Tcl_Release
 *	to clean up the internal structure of a square at a safe time
 *	(when no-one is using it anymore).
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	Everything associated with the square is freed up.
 *
 *----------------------------------------------------------------------
 */

static void
SquareDestroy(memPtr)
    char *memPtr;		/* Info about square widget. */
{
    Square *squarePtr = (Square *) memPtr;
    
    ckfree((char *) squarePtr);
}

/*
 *----------------------------------------------------------------------
 *
 * KeepInWindow --
 *
 *	Adjust the position of the square if necessary to keep it in
 *	the widget's window.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	The x and y position of the square are adjusted if necessary
 *	to keep the square in the window.
 *
 *----------------------------------------------------------------------
 */

static void
KeepInWindow(squarePtr)
    register Square *squarePtr;		/* Pointer to widget record. */
{
    int i, bd, relief;
    int borderWidth, size;

    Tk_GetPixelsFromObj(NULL, squarePtr->tkwin, squarePtr->borderWidthPtr,
	    &borderWidth);
    Tk_GetPixelsFromObj(NULL, squarePtr->tkwin, squarePtr->xPtr, 
	    &squarePtr->x);
    Tk_GetPixelsFromObj(NULL, squarePtr->tkwin, squarePtr->yPtr, 
	    &squarePtr->y);
    Tk_GetPixelsFromObj(NULL, squarePtr->tkwin, squarePtr->sizeObjPtr, &size);
    Tk_GetReliefFromObj(NULL, squarePtr->reliefPtr, &relief);
    bd = 0;
    if (relief != TK_RELIEF_FLAT) {
	bd = borderWidth;
    }
    i = (Tk_Width(squarePtr->tkwin) - bd) - (squarePtr->x + size);
    if (i < 0) {
	squarePtr->x += i;
    }
    i = (Tk_Height(squarePtr->tkwin) - bd) - (squarePtr->y + size);
    if (i < 0) {
	squarePtr->y += i;
    }
    if (squarePtr->x < bd) {
	squarePtr->x = bd;
    }
    if (squarePtr->y < bd) {
	squarePtr->y = bd;
    }
}


/*
 * TkgsColor object type used for option management
 */

static void		DupTkGSColorObjProc _ANSI_ARGS_((Tcl_Obj *srcPtr,
			    Tcl_Obj *copyPtr));
static void		FreeTkGSColorObjProc _ANSI_ARGS_((Tcl_Obj *listPtr));
static int		SetTkGSColorFromAny _ANSI_ARGS_((Tcl_Interp *interp,
			    Tcl_Obj *objPtr));

Tcl_ObjType tkgsColorObjType = {
    "tkgsColor",			/* name */
    FreeTkGSColorObjProc,		/* freeIntRepProc */
    DupTkGSColorObjProc,		/* dupIntRepProc */
    NULL,				/* updateStringProc */
    SetTkGSColorFromAny			/* setFromAnyProc */
};

static void
FreeTkGSColorObjProc(objPtr)
    Tcl_Obj *objPtr;		/* The object we are releasing. */
{
    TkGS_Color color = (TkGS_Color) objPtr->internalRep.otherValuePtr;
    TkGS_FreeColor(color);
}

static void
DupTkGSColorObjProc(srcObjPtr, dupObjPtr)
    Tcl_Obj *srcObjPtr;		/* The object we are copying from. */
    Tcl_Obj *dupObjPtr;		/* The object we are copying to. */
{
    TkGS_Color color = (TkGS_Color) srcObjPtr->internalRep.otherValuePtr;

    dupObjPtr->typePtr = srcObjPtr->typePtr;
    dupObjPtr->internalRep.otherValuePtr = (VOID *) color;
    TkGS_IncrRefCount((TkGS_Obj *) color);
}

static int 
SetTkGSColorFromAny(interp, objPtr)
    Tcl_Interp *interp;
    Tcl_Obj *objPtr;
{
    Tcl_ObjType *typePtr;
    XColor *xcolor;
    TkGS_Color color;

    /* For now, do a simple call to Tk_GetColor */
    /* TODO: write a real color parsing proc, with X format (eg #rrggbb)
     * as well as extended format such as "rgb(r,g,b)", "cmyk(c,m,y,k)"... */
    xcolor = Tk_GetColor(interp, Tk_MainWindow(interp), Tcl_GetString(objPtr));
    if (xcolor == NULL)
	return TCL_ERROR;

    /*
     * Free the old internalRep before setting the new one. 
     */

    typePtr = objPtr->typePtr;
    if ((typePtr != NULL) && (typePtr->freeIntRepProc != NULL)) {
	(*typePtr->freeIntRepProc)(objPtr);
    }

    objPtr->typePtr = &tkgsColorObjType;

    color = TkGS_GetRGBColor(xcolor->red, xcolor->green, xcolor->blue);
    objPtr->internalRep.otherValuePtr = (VOID *) color;

    Tk_FreeColor(xcolor);
    return TCL_OK;
}

TkGS_Color
TkGS_GetColorFromObj(interp, objPtr)
    Tcl_Interp *interp;
    Tcl_Obj *objPtr;
{
    int result;

    if (objPtr->typePtr != &tkgsColorObjType) {
	result = SetTkGSColorFromAny(interp, objPtr);
	if (result != TCL_OK) {
	    return NULL;
	}
    }
    return (TkGS_Color) objPtr->internalRep.otherValuePtr;
}

/*
 *----------------------------------------------------------------------
 *
 * Tkgs_square_Init --
 *
 *	This function is used to initialize the package. Here we check
 *	dependencies with other packages (eg Tcl), create new commands,
 *	and register our packages
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	New commands created, and package registered (see documentation).
 *
 *----------------------------------------------------------------------
 */

int Tkgs_square_Init(interp)
    Tcl_Interp *interp;
{  
#ifdef USE_TCL_STUBS
    if (Tcl_InitStubs(interp, "8.3", 0) == NULL) {
	return TCL_ERROR;
    }
#endif

#ifdef USE_TK_STUBS
    if (Tk_InitStubs(interp, "8.3", 0) == NULL) {
	return TCL_ERROR;
    }
#endif

    /* Dependencies */
    if (Tcl_PkgRequire(interp, "Tcl", "8.3", 0) == NULL)
	return TCL_ERROR;
    if (Tcl_PkgRequire(interp, "Tk", "8.3", 0) == NULL)
	return TCL_ERROR;
    if (Tcl_PkgRequire(interp, "TkGS", "1.0", 0) == NULL)
	return TCL_ERROR;

    /* 
     * Drivers 
     */

    /* PostScript driver */
    PSDriver = TkGS_GetDevice("PostScript");

    /* Canvas driver */
    CanvasDriver = TkGS_GetDevice("Canvas");

    Tcl_ResetResult(interp);


    /* Package provided */
    if (Tcl_PkgProvide(interp, "TkGS_Square", "1.0") == TCL_ERROR)
	return TCL_ERROR;

    /* Commands creation */
    Tcl_CreateObjCommand(interp, "square", (Tcl_ObjCmdProc *) SquareObjCmd,
	(ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);

    return TCL_OK;
}

/*
 *----------------------------------------------------------------------
 *
 * Tkgs_square_SafeInit --
 *
 *	This function is used to initialize the package in the special case
 *	of safe interpreters (like the Tcl Plugin). Here we check
 *	dependencies with other packages (eg Tcl), create new commands,
 *	and register our packages
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	New commands created, and package registered (see documentation).
 *
 *----------------------------------------------------------------------
 */

int Tkgs_square_SafeInit(interp)
    Tcl_Interp *interp;
{  
    /* Potentially unsafe, thus disallowed */
    return TCL_ERROR;
}

#ifdef WIN32
/*
 *----------------------------------------------------------------------
 *
 * DllEntryPoint --
 *
 *	This wrapper function is used by Windows to invoke the
 *	initialization code for the DLL.  If we are compiling
 *	with Visual C++, this routine will be renamed to DllMain.
 *	routine.
 *
 * Results:
 *	Returns TRUE;
 *
 * Side effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */

BOOL APIENTRY
DllEntryPoint(hInst, reason, reserved)
    HINSTANCE hInst; /* Library instance handle. */
    DWORD reason;    /* Reason this function is being called. */
    LPVOID reserved; /* Not used. */
{
    return TRUE;
}
#endif /* WIN32 */
