# tclc.tcl --
#
#	This Tcl script translates Tcl commands to C strings so that
#       they can be linked into a DLL or an executable.
#
#       see generic/tixInit.c for how the generated file is used.
#
# Usage:
#	[tclsh] tclc.tcl file1.tcl [file2.tcl ...]
#
#	The output is printed in the standard output.
#
# Copyright (c) 1993-1999 Ioi Kim Lam.
# Copyright (c) 2000-2001 Tix Project Group.
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#
# $Id: tclc_s.tcl,v 1.2 2001/01/08 06:16:41 ioilam Exp $


# ParseFile --
#
#	Converts one file into a C string. The name of the C string is
#       like script_1[], script_2[], etc.
#
proc ParseFile {fileName n} {
    set fd [open $fileName {RDONLY}]
    set lineNum 1

    puts "static char script_$n\[\] = \{"

    set N [format \n]
    set T [format \t]
    set NTS [format "\n\t\ "]
    set sep ""
    while {![eof $fd]} {
	set line [gets $fd]

	# Check whether this line is backslash-ended. If so, merge this line
	# with the next one
	#
	regsub -all $N $line " " foo
	append foo \na
	set foo [subst -nocommands -novariables $foo]
	if [regexp $N $foo] {
	    set cmd "$line\n"
	} else {
	    regsub -all \\\\\[$NTS\]*$ $line " " line
	    set cmd "$line"
	}
	set cmd '[join [split $cmd ""] ',']'
	regsub -all \\\\ $cmd \\\\\\\\ cmd
	regsub -all $N $cmd \\n cmd
	regsub -all $T $cmd \\t cmd
	regsub -all ''' $cmd '\\'' cmd
	regsub -all '\"' $cmd '\\\"' cmd

        puts -nonewline $sep$cmd
	set sep ,\n
    }
    puts "$sep'\\0'\};"
    close $fd
}

proc tclc_Main {} {
    global argv argv0

    set files [lrange $argv 0 end]

    set n 0
    foreach fileName $argv {
	ParseFile $fileName $n
	incr n
    }

    puts "static int LoadScripts(interp)"
    puts "    Tcl_Interp * interp;"
    puts "\{"

    if {$n > 0} {
	puts "    char *scripts\[$n\];"
	puts "    int i;"

	for {set k 0} {$k < $n} {incr k} {
	    puts "    scripts\[$k\] = script_$k;"
	}

	puts "    for (i=0; i<$n; i++) \{"
	puts "        if (Tcl_Eval(interp, scripts\[i\]) != TCL_OK) \{"
	puts "            return TCL_ERROR;"
	puts "        \}"
	puts "    \}"
    }

    puts "    return TCL_OK;"
    puts "\}"
}

tclc_Main
