# makebitmap.tcl --
#
#	Generates a .h file that includes all built-in bitmaps and 
#	pixmaps in the Tix library. These are the files
#       library/bitmaps/{*.xpm,*.xbm} inside the Tix source tree)
#
#       see generic/tixInit.c for how the generated file is used.
#
# Copyright (c) 1993-1999 Ioi Kim Lam.
# Copyright (c) 2000-2001 Tix Project Group.
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#
# $Id: makebitmap.tcl,v 1.2 2001/01/08 06:16:28 ioilam Exp $

set PWD [pwd]

puts {
/*
 * tixBitmaps.h --
 *
 *      This file is auto-generated by the Makefile using
 *      tools/makebitmap.tcl. Do not edit.
 *
 */

#ifndef _TIX_BITMAPS_H_
#define _TIX_BITMAPS_H_
static int LoadBitmaps _ANSI_ARGS_((Tcl_Interp * interp));

static int LoadBitmaps(interp)
    Tcl_Interp * interp;
}

puts "{"

foreach dir $argv {
    cd $dir

    foreach filename [glob -nocomplain *] {
	case [file ext $filename] {
	    {.xbm} {
		set root [file root $filename]
		if {$root == ""} {
		    continue
		}

		set bitsName {}
		set widthName {}
		set heightName {}
		set data [exec cat $filename]
		regexp {[A-z_0-9]*_bits} $data bitsName
		regexp {[A-z_0-9]*_width} $data widthName
		regexp {[A-z_0-9]*_height} $data heightName
		if ![regexp unsigned $data] {
		    regsub char $data "unsigned char" data
		}

		if {$bitsName == {} ||
		    $widthName == {} ||
		    $heightName == {}} {

		    puts stderr \
		"Warning: bad XBM format in file $dir/$filename, file excluded"
		} else {
		    puts "\{"
		    puts [exec cat $filename]
		    puts -nonewline "Tk_DefineBitmap(interp, "
		    puts -nonewline "Tk_GetUid(\"$root\"), "
		    puts -nonewline "$bitsName, "
		    puts -nonewline "$widthName, "
		    puts -nonewline "$heightName);"
		    puts ""
		    puts "\}"
		}

	    }
	    {.xpm} {
		set name [file root $filename]
		set data [exec cat $filename]
		if [regexp char\[^\\\[\]* $data root] {
		    regsub char   $root "" root
		    regsub \[\*\] $root "" root
		    set root [string trim $root]
		} else {
		    set root [file root $filename]\_xpm
		}
		puts "\{"
		puts [exec cat $filename]
		puts -nonewline "Tix_DefinePixmap(interp, "
		puts -nonewline "Tk_GetUid(\"$name\"), "
		puts -nonewline "$root);"
		puts ""
		puts "\}"
	    }
	}
    }
    cd $PWD
}

puts {
return TCL_OK;
}
puts "}"
puts {
/*
 * End of auto-generated file
 */
#endif /*_TIX_BITMAPS_H_*/
}
