tcltest::test 5.1.2-itf-1 { int to float conversion may lose precision } {
    constant_expression T512itf1 {1.23456792e8f == (float)123456789}
} PASS

tcltest::test 5.1.2-itf-2 { int to float conversion rounds down to nearest
        if remainder < .5} {
    constant_expression T512itf2 {(float)0x7fffff3f == (float)0x7fffff00}
} PASS

tcltest::test 5.1.2-itf-3 { int to float conversion rounds up to nearest
        if remainder > .5} {
    constant_expression T512itf3 {(float)0x70ffffc1 == (float)0x71000000}
} PASS

tcltest::test 5.1.2-itf-4 { int to float conversion rounds to least
        significant bit 0 if remainder = .5} {
    constant_expression T512itf4 {(float)0x7fffff40 == (float)0x7fffff00}
} PASS

tcltest::test 5.1.2-itf-5 { int to float conversion rounds to least
        significant bit 0 if remainder = .5} {
    constant_expression T512itf5 {(float)0x70ffffc0 == (float)0x71000000}
} PASS

tcltest::test 5.1.2-itf-6 { int to float boundary case } {
    constant_expression T512itf6 {(float)Integer.MAX_VALUE == 2.14748365E9f}
} PASS

tcltest::test 5.1.2-itf-7 { int to float boundary case } {
    constant_expression T512itf7 {(float)0 == 0f} {1/(float)0 == Float.POSITIVE_INFINITY}
} PASS

tcltest::test 5.1.2-itf-8 { int to float boundary case } {
    constant_expression T512itf8 {(float)Integer.MIN_VALUE == -2.14748365E9f}
} PASS

tcltest::test 5.1.2-itd-1 { int to double conversion never loses precision } {
    constant_expression T512itd1 {123456789.0 == (double)123456789}
} PASS

tcltest::test 5.1.2-itd-2 { int to double boundary case } {
    constant_expression T512itd2 {(double)Integer.MAX_VALUE == 2.147483647E9}
} PASS

tcltest::test 5.1.2-itd-3 { int to double boundary case } {
    constant_expression T512itd3 {(double)0 == 0.0} {1/(double)0 == Double.POSITIVE_INFINITY}
} PASS

tcltest::test 5.1.2-itd-4 { int to double boundary case } {
    constant_expression T512itd4 {(double)Integer.MIN_VALUE == -2.147483648e9}
} PASS

# FIXME: Add test for boundary cases like Integer.MAX_VALUE and so on, same for others.

tcltest::test 5.1.2-ltf-1 { long to float conversion may lose precision } {
    constant_expression T512ltf1 {1.23456792e8f == (float)123456789L}
} PASS

tcltest::test 5.1.2-ltf-2 { long to float conversion rounds down to nearest
        if remainder < .5} {
    constant_expression T512ltf2 {(float)0x7fffff3fL == (float)0x7fffff00L}
} PASS

tcltest::test 5.1.2-ltf-3 { long to float conversion rounds up to nearest if
        remainder > .5} {
    constant_expression T512ltf3 {(float)0x7fffffc1L == (float)0x80000000L}
} PASS

tcltest::test 5.1.2-ltf-4 { long to float conversion rounds to least
        significant bit 0 if remainder = .5} {
    constant_expression T512ltf4 {(float)0x7fffff40L == (float)0x7fffff00L}
} PASS

tcltest::test 5.1.2-ltf-5 { long to float conversion rounds to least
        significant bit 0 if remainder = .5} {
    constant_expression T512ltf5 {(float)0x7fffffc0L == (float)0x80000000L}
} PASS

tcltest::test 5.1.2-ltf-6 { long to float conversion rounds down to
        nearest if remainder < .5} {
    constant_expression T512ltf6 \
        {(float)0xffffff7ffffffbfL == (float)0xffffff000000000L}
} PASS

tcltest::test 5.1.2-ltf-7 { long to float conversion rounds down to
        nearest if remainder < .5. Hardware FP  that rounds to 64-bit
        double precision before rounding to 32-bit single precision
        will fail for this test case } {
    constant_expression T512ltf7 \
        {(float)0xffffff7ffffffffL == (float)0xffffff000000000L}
} PASS

tcltest::test 5.1.2-ltd-1 { long to double conversion may lose precision } {
    constant_expression T512ltd1 {0x123456789abcde0L == (double)0x123456789abcde7L}
} PASS

tcltest::test 5.1.2-ltd-2 { long to double conversion rounds down to nearest
        if remainder < .5} {
    constant_expression T512ltd2 {(double)0xffffff7ffffffbfL == 0xffffff7ffffff80L}
} PASS

tcltest::test 5.1.2-ltd-3 { long to double conversion rounds up to nearest
        if remainder > .5} {
    constant_expression T512ltd3 {(double)0xffffff7ffffffc1L == 0xffffff800000000L}
} PASS

tcltest::test 5.1.2-ltd-4 { long to double conversion rounds to least
        significant bit 0 if remainder = .5} {
    constant_expression T512ltd4 {(double)0xffffff7ffffff40L == 0xffffff7ffffff00L}
} PASS

tcltest::test 5.1.2-ltd-5 { long to double conversion rounds to least
        significant bit 0 if remainder = .5} {
    constant_expression T512ltd5 {(double)0xffffff7ffffffc0L == 0xffffff800000000L}
} PASS

tcltest::test 5.1.2-ftd-1 { float to double conversion never loses precision } {
    constant_expression T512ftd1 {(double)1234567.75f == 1234567.75}
} PASS
