###########################################################################
#                                                                         #
# Procedures to manage the cache of vertices and nodes for a tged editor. #
#                                                                         #
# This file is part of the tged package.                                  #
#                                                                         #
###########################################################################

# Copyright (c) 2000-2003, JYL Software Inc.
# 
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
# 
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

proc ::tged::getOrCacheNode {tree id} {
    variable data

    if {[catch {set node $data(i,$tree,cachednode,$id)}]} {
	set storage $data(i,$tree,storage)
	set node [$storage get node $id]
	set data(i,$tree,cachednode,$id) $node
    }
    return $node
}

proc ::tged::getOrCacheVertex {tree id} {
    variable data

    if {[catch {set vertex $data(i,$tree,cachedvertex,$id)}]} {
	set storage $data(i,$tree,storage)
	set vertex [$storage get vertex $id]
	set data(i,$tree,cachedvertex,$id) $vertex
    }
    return $vertex
}

proc ::tged::forgetCachedNode {tree id} {
    variable data

    catch {unset data(i,$tree,cachednode,$id)}
}

proc ::tged::forgetCachedVertex {tree id} {
    variable data

    catch {unset data(i,$tree,cachedvertex,$id)}
}
