/*
 * test.h --
 *
 * Header file for test harness for e4graph.
 *
 * Copyright (c) 2000-2003, JYL Software Inc.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE, EVEN IF
 * JYL SOFTWARE INC. IS MADE AWARE OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef	__TEST_CORE_H__
#define	__TEST_CORE_H__

#include "e4graph.h"

/*
 * Defined constants for each kind of test.
 */

#define TEST_ALL	-1
#define TEST_NONE	0
#define TEST_DSTRING	(1 << 0)
#define TEST_STORAGE	(1 << 1)
#define TEST_NODE	(1 << 2)
#define TEST_VERTEX	(1 << 3)
#define TEST_VVISITOR	(1 << 4)
#define TEST_NVISITOR	(1 << 5)
#define TEST_SVISITOR	(1 << 6)
#define TEST_CALLBACK	(1 << 7)
#define TEST_REFCOUNT	(1 << 8)
#define TEST_DETACH	(1 << 9)

/*
 * External functions:
 */

extern bool		clean_storage(const char *name, e4_Storage &s);

extern int		test_dstring();
extern int		test_storage();
extern int		test_node();
extern int		test_vertex();
extern int		test_vertexvisitor();
extern int		test_nodevisitor();
extern int		test_storagevisitor();
extern int		test_callback();
extern int		test_refcount();
extern int		test_detach();

#endif	/* !__TEST_CORE_H__ */
