/*
 * e4fvisitor.cpp --
 *
 *	Implementation of the e4_StorageVisitor class defined in e4graph.h.
 *
 *	Authors: Jacob Levy and Jean-Claude Wippler.
 *		 jyl@best.com	jcw@equi4.com
 *
 * Copyright (c) 2000-2003, JYL Software Inc.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE, EVEN IF
 * JYL SOFTWARE INC. IS MADE AWARE OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "e4graphimpl.h"

/*
 * Default constructor:
 */

e4_StorageVisitor::e4_StorageVisitor()
{
    e4_StorageImpl *nsi;

    done = false;
    nsi = e4_StorageImpl::GetFirstStorageImpl();
    if (nsi != NULL) {
	e4_Storage ss(nsi);

	s = ss;
    }
    if (!s.IsValid()) {
	done = true;
    }
}

/*
 * Copying constructor:
 */

e4_StorageVisitor::e4_StorageVisitor(const e4_StorageVisitor &referrer)
    : s(referrer.s),
      done(referrer.done)
{
}

/*
 * Assignment operator:
 */

e4_StorageVisitor &
e4_StorageVisitor::operator=(const e4_StorageVisitor &referrer) 
{
    s = referrer.s;
    done = referrer.done;

    return *this;
}

/*
 * Comparison operators:
 */

bool
e4_StorageVisitor::operator==(const e4_StorageVisitor &compared) const
{
    if (s == compared.s) {
	return true;
    }
    return false;
}

bool
e4_StorageVisitor::operator!=(const e4_StorageVisitor &compared) const
{
    if (s == compared.s) {
	return false;
    }
    return true;
}

/*
 * Destructor:
 */

e4_StorageVisitor::~e4_StorageVisitor()
{
    s = invalidStorage;
}

/*
 * Is this visitor done?
 */

bool
e4_StorageVisitor::IsDone()
{
    if (done) {
	return true;
    }
    if (!s.IsValid()) {
	done = true;
    }
    return done;
}

/*
 * Get the currently visited storage.
 */

bool
e4_StorageVisitor::CurrentStorage(e4_Storage &ss) 
{
    if (!s.IsValid()) {
	done = true;
	return false;
    }
    ss = s;
    return true;
}

/*
 * Get the currently visited storage and advance to the next one.
 */

bool
e4_StorageVisitor::CurrentStorageAndAdvance(e4_Storage &ss)
{
    if (!CurrentStorage(ss) || IsDone()) {
	return false;
    }
    (void) Advance();
    return true;
}

/*
 * Advance to the next storage to be visited and retrieve it.
 */

bool
e4_StorageVisitor::NextStorage(e4_Storage &ss)
{
    e4_StorageImpl *nsi;

    if (done) {
	return false;
    }
    if (!s.IsValid()) {
	done = true;
	return false;
    }
    nsi = e4_StorageImpl::GetNextStorageImpl(s.GetStorageImpl());
    if (nsi == NULL) {
	done = true;
	return false;
    } else {
	e4_Storage ns(nsi);

	s = ns;
    }	
    if (!s.IsValid()) {
	done = true;
	return false;
    }
    ss = s;
    return true;
}

/*
 * Advance to the next storage without returning it.
 */

bool
e4_StorageVisitor::Advance()
{
    e4_StorageImpl *nsi;

    if (done) {
	return false;
    }
    if (!s.IsValid()) {
	done = true;
	return false;
    }
    nsi = e4_StorageImpl::GetNextStorageImpl(s.GetStorageImpl());
    if (nsi == NULL) {
	done = true;
	return false;
    } else {
	e4_Storage ns(nsi);

	s = ns;
    }
    if (!s.IsValid()) {
	done = true;
	return false;
    }
    return true;
}

/*
 * Is this visitor valid?
 */

bool
e4_StorageVisitor::IsValid()
{
    if (!s.IsValid()) {
	done = true;
	return false;
    }
    return true;
}
