#!/bin/sh
#
# This shell script may be of use to build e4Graph and all the packages
# it depends on. The script expects the following directory structure:
#
#   dirc/e4graph-version
#	/tcl-version
#	/expat-version
#	/metakt-version
#
# In other words, all depended-upon packages' sources are found in the
# same directory as where the e4Graph sources are.
#
# Additionally, if your system supports Java, it must be find-able in one
# of the standard places (/usr/java/*).
#
# Run this script with 'sh build_everything.sh or simply 'build_everything.sh'.
#
# Copyright (c) 2000-2003, JYL Software Inc.
# 
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
# 
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE, EVEN IF
# JYL SOFTWARE INC. IS MADE AWARE OF THE POSSIBILITY OF SUCH DAMAGE.

# INSTALLCOMP:
#
# The directory where everything will be installed. Change it to where you
# want to install the products of building everything.

SRCCOMP=`(cd ../..; pwd)`
INSTALLCOMP=$SRCCOMP/install

# What versions of all packages are we going to build:

TCLVERSION=tcl8.4.1
MKTVERSION=metakit-2.4.9
EXPVERSION=expat-1.95.5
E4GVERSION=e4graph-1.0a8

# You should not have to change anything below this line

TCLSRC=$SRCCOMP/$TCLVERSION
TCLBLD=$TCLSRC/unix

MKTSRC=$SRCCOMP/$MKTVERSION
MKTBLD=$MKTSRC/builds

EXPSRC=$SRCCOMP/$EXPVERSION

E4GSRC=$SRCCOMP/$E4GVERSION
E4GBLD=$E4GSRC/all

# Now just go through, configure and build everything

echo making in $TCLBLD
cd $TCLBLD
/bin/rm -f config.status config.cache config.log
./configure --prefix=$INSTALLCOMP
make clean install
echo making in $MKTBLD
cd $MKTBLD
/bin/rm -f config.status config.cache config.log
../unix/configure --prefix=$INSTALLCOMP
make clean install
echo making in $EXPSRC
cd $EXPSRC
/bin/rm -f config.status config.cache config.log
./configure --prefix=$INSTALLCOMP
make clean install
echo making in $E4GBLD
cd $E4GBLD
/bin/rm -f config.status config.cache config.log
autoconf
./configure --enable-tcl --enable-xml --enable-java --prefix=$INSTALLCOMP
make clean install
