;
; SunScript look generation functions
;
; Laurent Demailly & Brent Welch 
;
; 12/1997 - SunScript
;
; SCCS: @(#) sunscript1.scm 1.4 97/12/12 21:40:16
;

(define (text-width extents)
  (car extents))

(define (text-height extents)
  (cadr extents))

(define (text-ascent extents)
  (caddr extents))

(define (text-descent extents)
  (cadr (cddr extents)))

(set! sunscript-red '(204 51 0))
(set! sunscript-blue '(0 51 153))
(set! sunscript-font-foundry "*")
(set! sunscript-font-family "utopia")
(set! sunscript-font-weight "medium")
(set! sunscript-font-slant "r")
(set! sunscript-font-set-width "normal")
(set! sunscript-font-spacing "p")
(set! sunscript-font-size 15)
(set! sunscript-img-width 110)
(set! sunscript-img-height 24)
(set! sunscript-bevel-width 4)

(define (script-fu-sunscript-button1 text filename onFlag)
  (let* (
	 (num-colors 32)
	 (img (car (gimp-image-new sunscript-img-width
				   sunscript-img-height 
				   RGB)))
	 (background (car (gimp-layer-new img sunscript-img-width 
					  sunscript-img-height 
					  RGB_IMAGE
					  "Background" 100 NORMAL)))
	 (bumpmap (car (gimp-layer-new img sunscript-img-width 
					  sunscript-img-height 
					  RGB_IMAGE
					  "BumpMap" 100 NORMAL)))
	 (text-extents (gimp-text-get-extents text
					      sunscript-font-size
					      PIXELS
					      sunscript-font-foundry
					      sunscript-font-family
					      sunscript-font-weight
					      sunscript-font-slant
					      sunscript-font-set-width
					      sunscript-font-spacing))
	 (color (if (= onFlag TRUE) sunscript-blue sunscript-red))
	 )
    (gimp-palette-set-foreground '(255 255 255))
    (gimp-palette-set-background color)
    (gimp-drawable-fill background BG-IMAGE-FILL)
    (gimp-image-add-layer img background 1)
    (gimp-text
		       img background

		       (+
			(/
			 (- sunscript-img-width (text-width text-extents))
			 2)
			2)
		       (+
			(/
			 (- sunscript-img-height (* .8 
						    sunscript-font-size))
			2)
			onFlag)
		       text
		       0
		       0 ; anti aliasing
		       sunscript-font-size
		       PIXELS
		       sunscript-font-foundry
		       sunscript-font-family
		       sunscript-font-weight
		       sunscript-font-slant
		       sunscript-font-set-width
		       sunscript-font-spacing)

    (gimp-image-add-layer img bumpmap 2)
    (gimp-palette-set-foreground '(0 0 0))
    (gimp-palette-set-background '(255 255 255))
    (gimp-edit-fill img bumpmap)

    (gimp-rect-select img 0 0 sunscript-bevel-width sunscript-img-height REPLACE FALSE 0)
    (blend-bumpmap img bumpmap 0 0 (- sunscript-bevel-width 1) 0)

    (gimp-rect-select img 0 0 sunscript-img-width sunscript-bevel-width REPLACE FALSE 0)
    (blend-bumpmap img bumpmap 0 0 0 (- sunscript-bevel-width 1))

    (gimp-rect-select img (- sunscript-img-width sunscript-bevel-width) 0 sunscript-bevel-width sunscript-img-height REPLACE FALSE 0)
    (blend-bumpmap img bumpmap (- sunscript-img-width 1) 0 (- sunscript-img-width sunscript-bevel-width) 0)

    (gimp-rect-select img 0 (- sunscript-img-height sunscript-bevel-width) sunscript-img-width sunscript-bevel-width REPLACE FALSE 0)
    (blend-bumpmap img bumpmap 0 (- sunscript-img-height 1) 0 (- sunscript-img-height sunscript-bevel-width))

    
   (gimp-selection-none img)

   (plug-in-bump-map 1 img background bumpmap 135 45 sunscript-bevel-width 0 0 0 0 TRUE onFlag 0)


    (let ((background (car (gimp-image-flatten img))))
      (gimp-convert-indexed img 0 2 num-colors "")
      (file-gif-save 1 img background filename filename 0 0 0 0)
;      (gimp-display-new img)
;      (gimp-image-clean-all img)
      (gimp-image-delete img)
      )
    
)
)
; Register!

(script-fu-register "script-fu-sunscript-button"
		    "<Toolbox>/Xtns/Script-Fu/SunScript/button"
		    "Test 1"
		    "Laurent Demailly & Brent Welch"
		    "SunScript"
		    "December 1997"
		    ""
		    SF-VALUE "Text" "\"Home\""
		    SF-VALUE "Text" "\"img.gif\""
		    SF-TOGGLE "Active?" FALSE)


