/*
 * Declaration of the GraphItem canvas item type.  It needs to be declared
 * in a separate file because the DatasetItem type refers to elements
 * of this structure
 */

#ifndef _XYGRAPH_INCLUDED
#define _XYGRAPH_INCLUDED 1

#define AUTOSCALE_XMIN 1
#define AUTOSCALE_YMIN 2
#define AUTOSCALE_XMAX 4
#define AUTOSCALE_YMAX 8

#define NORTH_TICK_IN	0x01
#define NORTH_TICK_OUT	0x02
#define SOUTH_TICK_IN	0x04
#define SOUTH_TICK_OUT	0x08
#define EAST_TICK_IN	0x10
#define EAST_TICK_OUT	0x20
#define WEST_TICK_IN	0x40
#define WEST_TICK_OUT	0x80
#define TICK_IN    NORTH_TICK_IN|SOUTH_TICK_IN|EAST_TICK_IN|WEST_TICK_IN
#define TICK_OUT   NORTH_TICK_OUT|SOUTH_TICK_OUT|EAST_TICK_OUT|WEST_TICK_OUT
#define NORTH_TICK	NORTH_TICK_IN|NORTH_TICK_OUT
#define SOUTH_TICK	SOUTH_TICK_IN|SOUTH_TICK_OUT
#define WEST_TICK	WEST_TICK_IN|WEST_TICK_OUT
#define EAST_TICK	EAST_TICK_IN|EAST_TICK_OUT

typedef struct GraphItem  {
    Tk_Item header;		/* Generic stuff that's the same for all
				 * types.  MUST BE FIRST IN STRUCTURE. */
    Tk_Outline outline;		/* Outline structure */
    Tk_Outline axisline_outline;/* Outline structure */
    Tk_Outline tick_outline;	/* Outline structure */
    double bbox[4];		/* Coordinates of bounding box for rectangle
				 * or oval (x1, y1, x2, y2).  Item includes
				 * x1 and x2 but not y1 and y2. */
    Tk_Tile fillTile;		/* Tile for filling rectangle/oval. */
    Tk_Tile activeFillTile;	/* Tile for filling rectangle/oval if state is active. */
    Tk_Tile disabledFillTile;	/* Tile for filling rectangle/oval if state is disabled. */
    XColor *fillColor;		/* Color for filling rectangle/oval. */
    XColor *activeFillColor;	/* Color for filling rectangle/oval if state is active. */
    XColor *disabledFillColor;	/* Color for filling rectangle/oval if state is disabled. */
    Pixmap fillStipple;		/* Stipple bitmap for filling item. */
    Pixmap activeFillStipple;	/* Stipple bitmap for filling item if state is active. */
    Pixmap disabledFillStipple;	/* Stipple bitmap for filling item if state is disabled. */
    GC fillGC;			/* Graphics context for filling item. */
    GC drawableGC;		/* Graphics context for copying the drawable
				 * onto the canvas */
    Pixmap drawable;
    Pixmap clipMask;
    double xaxismin, xaxismax;	/* axis limits. */
    double yaxismin, yaxismax;	/* axis limits. */
    double xmajortickinterval;	/* Tick intervals */
    double xminortickinterval;	/* Tick intervals */
    double ymajortickinterval;	/* Tick intervals */
    double yminortickinterval;	/* Tick intervals */
    int xmajorticksize;		/* Size of tickmarks. */
    int xminorticksize;		/* Size of tickmarks. */
    int ymajorticksize;		/* Size of tickmarks. */
    int yminorticksize;		/* Size of tickmarks. */
    double xtickorigin;		/* origin for drawing ticks.  defaults to 0. */
    double ytickorigin;		/* origin for drawing ticks.  defaults to 0. */
    char *xtickformat;		/* Precision of x tick labels */
    char *ytickformat;		/* Precision of y tick labels */
    int tickprops;		/* Tickmark properties  (in, out, position) */
    int nxaxislines;		/* Number of x=n axis lines currently defined */
    int nyaxislines;		/* Number of y=n axis lines currently defined */
    double *xaxislines;		/* x=n lines to draw on graph */
    double *yaxislines;		/* y=n lines to draw on graph */
    int resize_id;		/* Id of the last graph resize.  Datasets
				 * should use this value to determine if they
				 * need to be rescaled. */
    char *configCmd;		/* Command to execute whenever the graph
				 * item is configured */
    int	master;			/* Canvas id of the master for this item */
    int nchildren;		/* Number of children */
    int child_arr_size;		/* Size fo children array */
    Tk_Item **children;		/* Array of Tk_Item *'s specifying the 
				 * children of this item */
} GraphItem;

#endif
