#
# Callback for Help menu items
# Displays help information using Steve Uhler's html display library
#
proc displayHelp {{helptype intro}} {
    global menued_parms

    set cursor [. cget -cursor]
    set text_cursor ""

    if {[info commands .helpDlg] == ""} {
        toplevel .helpDlg
	. configure -cursor watch
	.helpDlg configure -cursor watch
        wm title .helpDlg "Menu Editor Help"
        menu_help_ui .helpDlg

	set text_cursor [.helpDlg.helpText cget -cursor]
	.helpDlg.helpText configure \
	    -cursor watch \
	    -state disabled
	

	destroy .helpDlg.hackLabel
        .helpDlg.dismissButton configure -command dismissHelp
	.helpDlg.helpText configure -font *courier-medium-r-normal*14*
	
	.helpDlg.statusLabel configure -text "Working"
	.helpDlg.statusFrame configure -width 16 -height 10
	.helpDlg.statusFrame configure -bg red
	raise .helpDlg.statusFrame

	update
    } else {
	wm deiconify .helpDlg
	raise .helpDlg
    }

    if {$text_cursor == ""} {
	set text_cursor [.helpDlg.helpText cget -cursor]
    }

    .helpDlg.helpText configure -state normal
    .helpDlg.helpText delete 1.0 end
    HMinit_win .helpDlg.helpText

    switch $helptype {
	intro {
	    set helpfile "help"
	}
	programmer {
	    set helpfile "proghelp"
	}
    }
    # set help_fileid [open $helpfile.html]
    # set menued_parms(helpHtml) [read $help_fileid]
    # close $help_fileid
	set menued_parms(helpHtml) [$helpfile.html]
    
    HMset_state .helpDlg.helpText -size 4
    HMparse_html $menued_parms(helpHtml) "updateHelpDlg .helpDlg.helpText"

    .helpDlg.helpText configure -state disabled

    .helpDlg.statusLabel configure -text ""
    lower .helpDlg.statusFrame
    . configure -cursor $cursor
    .helpDlg configure -cursor $cursor
    .helpDlg.helpText configure -cursor $text_cursor
    set menued_parms(html_progress) 0
}

#
# This is called after every tag by HMparse_html
# It updates the progress bar.
#
proc updateHelpDlg {args} {
    global menued_parms

    incr menued_parms(html_progress)

    set width [expr 10 * $menued_parms(html_progress) + 16]
    if {$width > 416} {
	set width 416
    }
    .helpDlg.statusFrame configure -width $width
    update

    # Now actually render the html
    set cmd "HMrender $args"
    eval $cmd
}


# Callback for the "Dismiss" button on the help window
proc dismissHelp {} {
    if {[info commands .helpDlg] != ""} {
	wm withdraw .helpDlg
    }
}

# Callback for images.
proc HMset_image {win handle src} {
    
    if {[file exists $src]} {
	if {[file readable $src]} {
	    set myimage [image create photo -file $src]
	    if {$myimage != {}} {
		HMgot_image $handle $myimage
	    }
	} else {
	    tk_dialog .html_error "Error" \
                    "The help file '$src' isn't readable." \
                    error 0 "Rats!"
    	}
    } else {
	tk_dialog .html_error "Error" \
                "The help file '$src' doesn't exist." \
                error 0 "Rats!"
    }
}

proc help.html {} { return [exec cat h.html]}
