/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Vector;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.JavaInvoke;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.reflect.PkgInvoker;

class FuncSig
extends InternalRep {
    Class targetCls;
    PkgInvoker pkgInvoker;
    Object func;
    static Hashtable allDeclMethTable = new Hashtable();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    FuncSig(Class cls, PkgInvoker p, Object f) {
        this.targetCls = cls;
        this.pkgInvoker = p;
        this.func = f;
    }

    protected InternalRep duplicate() {
        return new FuncSig(this.targetCls, this.pkgInvoker, this.func);
    }

    static FuncSig get(Interp interp, Class cls, TclObject signature, TclObject[] argv, int startIdx, int count) throws TclException {
        Executable match;
        boolean isConstructor = cls == null;
        int sigLength = TclList.getLength((Interp)interp, (TclObject)signature);
        String methodName = null;
        boolean foundSameName = false;
        if (sigLength == 0) {
            throw new TclException(interp, "bad signature \"" + signature + "\"");
        }
        if (isConstructor) {
            cls = JavaInvoke.getClassByName(interp, TclList.index((Interp)interp, (TclObject)signature, (int)0).toString());
        } else {
            methodName = TclList.index((Interp)interp, (TclObject)signature, (int)0).toString();
        }
        if (sigLength > 1 || sigLength == 1 && count == 0) {
            int sigNumArgs = sigLength - 1;
            Class[] paramTypes = new Class[sigNumArgs];
            int i = 0;
            while (i < sigNumArgs) {
                String clsName = TclList.index((Interp)interp, (TclObject)signature, (int)(i + 1)).toString();
                paramTypes[i] = JavaInvoke.getClassByName(interp, clsName);
                ++i;
            }
            if (isConstructor) {
                try {
                    match = cls.getDeclaredConstructor(paramTypes);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (sigLength > 1) {
                        throw new TclException(interp, "no such constructor \"" + signature + "\"");
                    }
                    throw new TclException(interp, "can't find constructor with " + count + " argument(s) for class \"" + cls.getName() + "\"");
                }
            } else {
                match = FuncSig.lookupMethod(interp, cls, methodName, paramTypes, signature);
            }
        } else {
            match = FuncSig.matchSignature(interp, cls, signature, methodName, isConstructor, argv, startIdx, count);
        }
        FuncSig sig = new FuncSig(cls, PkgInvoker.getPkgInvoker(cls), match);
        signature.setInternalRep(sig);
        return sig;
    }

    static Method lookupMethod(Interp interp, Class cls, String methodName, Class[] paramTypes, TclObject signature) throws TclException {
        Method[] methods = FuncSig.getAllDeclaredMethods(cls);
        boolean foundSameName = false;
        int i = 0;
        while (i < methods.length) {
            if (methodName.equals(methods[i].getName())) {
                foundSameName = true;
                Class<?>[] pt = methods[i].getParameterTypes();
                if (pt.length == paramTypes.length) {
                    boolean good = true;
                    int j = 0;
                    while (j < pt.length) {
                        if (pt[j] != paramTypes[j]) {
                            good = false;
                            break;
                        }
                        ++j;
                    }
                    if (good) {
                        return methods[i];
                    }
                }
            }
            ++i;
        }
        if (paramTypes.length > 0 || !foundSameName) {
            throw new TclException(interp, "no such method \"" + signature + "\" in class " + cls.getName());
        }
        throw new TclException(interp, "can't find method \"" + signature + "\" with " + paramTypes.length + " argument(s) for class \"" + cls.getName() + "\"");
    }

    static Object matchSignature(Interp interp, Class cls, TclObject signature, String methodName, boolean isConstructor, TclObject[] argv, int startIdx, int argv_count) throws TclException {
        boolean foundSameName = false;
        Vector<Executable> match_vector = new Vector<Executable>();
        Executable[] funcs = isConstructor ? cls.getDeclaredConstructors() : FuncSig.getAllDeclaredMethods(cls);
        int i = 0;
        while (i < funcs.length) {
            block34: {
                Class<?>[] paramTypes;
                block33: {
                    block32: {
                        if (!isConstructor) break block32;
                        paramTypes = ((Constructor)funcs[i]).getParameterTypes();
                        break block33;
                    }
                    Method method = (Method)funcs[i];
                    if (!methodName.equals(method.getName())) break block34;
                    foundSameName = true;
                    paramTypes = method.getParameterTypes();
                }
                if (paramTypes.length == argv_count) {
                    match_vector.addElement(funcs[i]);
                }
            }
            ++i;
        }
        if (match_vector.size() == 1) {
            return match_vector.elementAt(0);
        }
        if (match_vector.size() > 1) {
            int j;
            Class<?>[] match_classes;
            Class[] argv_classes = new Class[argv_count];
            i = 0;
            while (i < argv_count) {
                TclObject tobj = argv[startIdx + i];
                InternalRep ir = tobj.getInternalRep();
                argv_classes[i] = ir instanceof ReflectObject ? ReflectObject.getClass(interp, argv[startIdx + i]) : (class$java$lang$String != null ? class$java$lang$String : FuncSig.class$("java.lang.String"));
                ++i;
            }
            i = 0;
            while (i < match_vector.size()) {
                match_classes = isConstructor ? ((Constructor)match_vector.elementAt(i)).getParameterTypes() : ((Method)match_vector.elementAt(i)).getParameterTypes();
                boolean exact = true;
                j = 0;
                while (j < argv_count) {
                    if (match_classes[j] != argv_classes[j]) {
                        exact = false;
                        break;
                    }
                    ++j;
                }
                if (exact) {
                    return match_vector.elementAt(i);
                }
                ++i;
            }
            i = match_vector.size() - 1;
            while (i >= 0) {
                match_classes = isConstructor ? ((Constructor)match_vector.elementAt(i)).getParameterTypes() : ((Method)match_vector.elementAt(i)).getParameterTypes();
                boolean match = true;
                j = 0;
                while (j < argv_count) {
                    if (match_classes[j] != argv_classes[j] && !match_classes[j].isAssignableFrom(argv_classes[j])) {
                        match_vector.removeElementAt(i);
                        break;
                    }
                    ++j;
                }
                --i;
            }
            if (match_vector.size() == 1) {
                return match_vector.elementAt(0);
            }
            if (match_vector.size() > 1) {
                Class[][] argv_classes_lookup = new Class[argv_count][];
                Vector class_vector = new Vector();
                i = 0;
                while (i < argv_count) {
                    Class c = argv_classes[i];
                    while (c != null) {
                        class_vector.addElement(null);
                        FuncSig.addInterfaces(c, class_vector);
                        c = c.getSuperclass();
                    }
                    class_vector.removeElementAt(0);
                    Object[] classes = new Class[class_vector.size()];
                    class_vector.copyInto(classes);
                    argv_classes_lookup[i] = classes;
                    class_vector.removeAllElements();
                    ++i;
                }
                int[] super_steps = new int[match_vector.size()];
                int[] total_steps = new int[match_vector.size()];
                boolean[] trim_matches = new boolean[match_vector.size()];
                j = 0;
                while (j < argv_count) {
                    int min_super_step = Integer.MAX_VALUE;
                    int min_total_step = Integer.MAX_VALUE;
                    Class min_class = class$java$lang$Object != null ? class$java$lang$Object : FuncSig.class$("java.lang.Object");
                    i = 0;
                    while (i < match_vector.size()) {
                        match_classes = isConstructor ? ((Constructor)match_vector.elementAt(i)).getParameterTypes() : ((Method)match_vector.elementAt(i)).getParameterTypes();
                        Class<?> match_to = match_classes[j];
                        Class[] arg_classes = argv_classes_lookup[j];
                        int super_step = 0;
                        int total_step = 0;
                        while (total_step < arg_classes.length) {
                            Class c = arg_classes[total_step];
                            if (c == null) {
                                ++super_step;
                            } else if (c == match_to) {
                                super_steps[i] = super_step;
                                total_steps[i] = total_step;
                                if (super_step > min_super_step || c.isInterface() && min_class != (class$java$lang$Object != null ? class$java$lang$Object : FuncSig.class$("java.lang.Object")) && !min_class.isInterface()) break;
                                min_class = c;
                                min_super_step = super_step;
                                if (total_step >= min_total_step) break;
                                min_total_step = total_step;
                                break;
                            }
                            ++total_step;
                        }
                        ++i;
                    }
                    i = match_vector.size() - 1;
                    while (i >= 0) {
                        if (super_steps[i] > min_super_step || super_steps[i] == min_super_step && total_steps[i] > min_total_step) {
                            trim_matches[i] = true;
                        }
                        --i;
                    }
                    ++j;
                }
                i = match_vector.size() - 1;
                while (i >= 0) {
                    if (trim_matches[i]) {
                        match_vector.removeElementAt(i);
                    }
                    --i;
                }
            }
            if (match_vector.size() == 1) {
                return match_vector.elementAt(0);
            }
            throw new TclException(interp, "ambiguous " + (isConstructor ? "constructor" : "method") + " signature \"" + signature + "\"");
        }
        if (isConstructor) {
            throw new TclException(interp, "can't find constructor with " + argv_count + " argument(s) for class \"" + cls.getName() + "\"");
        }
        if (!foundSameName) {
            throw new TclException(interp, "no such method \"" + signature + "\" in class " + cls.getName());
        }
        throw new TclException(interp, "can't find method \"" + signature + "\" with " + argv_count + " argument(s) for class \"" + cls.getName() + "\"");
    }

    static void addInterfaces(Class cls, Vector v) {
        v.addElement(cls);
        Class<?>[] interfaces = cls.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            FuncSig.addInterfaces(interfaces[i], v);
            ++i;
        }
    }

    static Method[] getAllDeclaredMethods(Class cls) {
        Object[] methods = (Method[])allDeclMethTable.get(cls);
        if (methods != null) {
            return methods;
        }
        Vector vec = new Vector();
        Class c = cls;
        while (c != null) {
            FuncSig.mergeMethods(c, c.getDeclaredMethods(), vec);
            Class<?>[] interfaces = c.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                FuncSig.mergeMethods(interfaces[i], interfaces[i].getMethods(), vec);
                ++i;
            }
            c = c.getSuperclass();
        }
        methods = new Method[vec.size()];
        vec.copyInto(methods);
        allDeclMethTable.put(cls, methods);
        return methods;
    }

    static void mergeMethods(Class c, Method[] methods, Vector vec) {
        int i = 0;
        while (i < methods.length) {
            boolean sameSigExists = false;
            Method newMeth = methods[i];
            int j = 0;
            while (j < vec.size()) {
                Method oldMeth = (Method)vec.elementAt(j);
                if (FuncSig.methodSigEqual(oldMeth, newMeth)) {
                    int oldRank;
                    sameSigExists = true;
                    Class<?> oldCls = oldMeth.getDeclaringClass();
                    int newRank = FuncSig.getMethodRank(c, newMeth);
                    if (newRank <= (oldRank = FuncSig.getMethodRank(oldCls, oldMeth))) break;
                    vec.setElementAt(newMeth, j);
                    break;
                }
                ++j;
            }
            if (!sameSigExists) {
                vec.addElement(newMeth);
            }
            ++i;
        }
    }

    static boolean methodSigEqual(Method method1, Method method2) {
        Class<?>[] param2;
        if (!method1.getName().equals(method2.getName())) {
            return false;
        }
        Class<?>[] param1 = method1.getParameterTypes();
        if (param1.length != (param2 = method2.getParameterTypes()).length) {
            return false;
        }
        int i = 0;
        while (i < param1.length) {
            if (param1[i] != param2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static int getMethodRank(Class declaringCls, Method method) {
        int methMod = method.getModifiers();
        if (Modifier.isPrivate(methMod)) {
            return 0;
        }
        int clsMod = declaringCls.getModifiers();
        if (Modifier.isPublic(methMod) && Modifier.isPublic(clsMod)) {
            return 2;
        }
        return 0;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }
}

