/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.BeanEventMgr;
import tcl.lang.BeanEventParamSet;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.JavaInvoke;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

class JavaEventCmd
implements Command {
    BeanEventMgr eventMgr;
    private static final String[] validOpts = new String[]{"-index"};
    static final int OPT_INDEX = 0;

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        BeanEventParamSet p;
        int index;
        if (argv.length > 4) {
            throw new TclNumArgsException(interp, 1, argv, "?-index num? ?propertyName?");
        }
        if (argv.length <= 2) {
            index = 0;
        } else {
            TclIndex.get(interp, argv[1], validOpts, "option", 0);
            index = TclInteger.get(interp, argv[2]);
        }
        TclObject propObj = argv.length == 2 ? argv[1] : (argv.length == 4 ? argv[3] : null);
        if (this.eventMgr == null) {
            this.eventMgr = BeanEventMgr.getBeanEventMgr(interp);
        }
        if ((p = this.eventMgr.peekEventParamSet()) == null) {
            throw new TclException(interp, "\"" + argv[0] + "\" cannot be invoked outside of an event handler");
        }
        if (index < 0 || index >= p.params.length) {
            throw new TclException(interp, "event parameter #" + index + " doesn't exist");
        }
        TclObject param = JavaInvoke.convertJavaObject(interp, p.paramTypes[index], p.params[index]);
        if (propObj == null) {
            interp.setResult(param);
        } else {
            interp.setResult(JavaInvoke.getProperty(interp, param, propObj, true));
        }
    }

    JavaEventCmd() {
    }
}

