/*
 * Decompiled with CFR 0.152.
 */
package com.oroinc.text.regex;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public final class Perl5StreamInput {
    private static final int __DEFAULT_BUFFER_INCREMENT = 4096;
    private int __bufferIncrement;
    private Reader __input;
    boolean _endOfStream;
    boolean _tentativeEOS;
    int _bufferSize;
    int _streamOffset;
    int _bufferOffset;
    int _matchEndOffset;
    char[] _buffer;
    char[] _originalBuffer;

    public Perl5StreamInput(Reader reader, int n) {
        this.__input = reader;
        this.__bufferIncrement = n;
        this._endOfStream = false;
        this._tentativeEOS = false;
        this._streamOffset = 0;
        this._bufferOffset = 0;
        this._bufferSize = 0;
        this._buffer = new char[n];
        this._originalBuffer = this._buffer;
        this._matchEndOffset = -1;
    }

    public Perl5StreamInput(Reader reader) {
        this(reader, 4096);
    }

    public Perl5StreamInput(InputStream inputStream, int n) {
        this(new InputStreamReader(inputStream), n);
    }

    public Perl5StreamInput(InputStream inputStream) {
        this(new InputStreamReader(inputStream), 4096);
    }

    private void __fillBuffer(int n, int n2) {
        n2 += n;
        while (n < n2) {
            char c = this._originalBuffer[n];
            this._buffer[n] = Character.isUpperCase(c) ? Character.toLowerCase(c) : c;
            ++n;
        }
    }

    void _setMatchEndOffset(int n) {
        this._matchEndOffset = n;
    }

    int _getMatchEndOffset() {
        return this._matchEndOffset;
    }

    void _reallocate(int n, boolean bl) throws IOException {
        if (this._endOfStream) {
            return;
        }
        if (this._tentativeEOS) {
            this._tentativeEOS = false;
            this._endOfStream = true;
            return;
        }
        int n2 = this._bufferSize - n;
        if (n2 < 0) {
            throw new IOException("Non-negative offset assertion violation.\nPlease report this error to bugs@oroinc.com\n");
        }
        char[] cArray = new char[n2 + this.__bufferIncrement];
        int n3 = this.__input.read(cArray, n2, this.__bufferIncrement);
        if (n3 <= 0) {
            this._endOfStream = true;
            if (n3 == 0) {
                throw new IOException("read from input Reader returned 0 chars.");
            }
        } else {
            this._streamOffset += n;
            this._bufferSize = n2 + n3;
            while (this._bufferSize < cArray.length) {
                int n4 = this.__input.read(cArray, this._bufferSize, cArray.length - this._bufferSize);
                if (n4 == 0) {
                    throw new IOException("read from input Reader returned 0 chars.");
                }
                if (n4 < 0) {
                    this._tentativeEOS = true;
                    break;
                }
                this._bufferSize += n4;
                n3 += n4;
            }
            System.arraycopy(this._originalBuffer, n, cArray, 0, n2);
            this._originalBuffer = cArray;
            if (bl) {
                cArray = new char[n2 + this.__bufferIncrement];
                System.arraycopy(this._buffer, n, cArray, 0, n2);
                this._buffer = cArray;
                this.__fillBuffer(n2, n3);
                return;
            }
            this._buffer = this._originalBuffer;
        }
    }

    boolean _read(boolean bl) throws IOException {
        this._streamOffset += this._bufferSize;
        int n = this._bufferSize = this.__input.read(this._originalBuffer);
        if (this._bufferSize > 0) {
            while (this._bufferSize < this._originalBuffer.length) {
                n = this.__input.read(this._originalBuffer, this._bufferSize, this._originalBuffer.length - this._bufferSize);
                if (n == 0) {
                    throw new IOException("read from input Reader returned 0 chars.");
                }
                if (n >= 0) {
                    this._bufferSize += n;
                    continue;
                }
                break;
            }
        } else {
            this._endOfStream = true;
        }
        if (!this._endOfStream && bl) {
            this._buffer = new char[this._originalBuffer.length];
            this.__fillBuffer(0, this._bufferSize);
        }
        return !this._endOfStream;
    }

    public boolean endOfStream() {
        return this._endOfStream;
    }
}

