/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.CallFrame;
import tcl.lang.CharPointer;
import tcl.lang.Command;
import tcl.lang.CommandWithDispose;
import tcl.lang.Interp;
import tcl.lang.NamespaceCmd;
import tcl.lang.Parser;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.WrappedCommand;

class Procedure
implements Command,
CommandWithDispose {
    TclObject[][] argList;
    boolean isVarArgs;
    CharPointer body;
    int body_length;
    NamespaceCmd.Namespace ns;
    String srcFileName;
    int srcLineNumber;

    Procedure(Interp interp, NamespaceCmd.Namespace namespace, String string, TclObject tclObject, TclObject tclObject2, String string2, int n) throws TclException {
        this.ns = namespace;
        this.srcFileName = string2;
        this.srcLineNumber = n;
        int n2 = TclList.getLength(interp, tclObject);
        this.argList = new TclObject[n2][2];
        int n3 = 0;
        while (n3 < n2) {
            TclObject tclObject3 = TclList.index(interp, tclObject, n3);
            int n4 = TclList.getLength(interp, tclObject3);
            if (n4 == 0) {
                throw new TclException(interp, "procedure \"" + string + "\" has argument with no name");
            }
            if (n4 > 2) {
                throw new TclException(interp, "too many fields in argument specifier \"" + tclObject3 + "\"");
            }
            this.argList[n3][0] = TclList.index(interp, tclObject3, 0);
            this.argList[n3][0].preserve();
            if (n4 == 2) {
                this.argList[n3][1] = TclList.index(interp, tclObject3, 1);
                this.argList[n3][1].preserve();
            } else {
                this.argList[n3][1] = null;
            }
            ++n3;
        }
        this.isVarArgs = n2 > 0 && this.argList[n2 - 1][0].toString().equals("args");
        this.body = new CharPointer(tclObject2.toString());
        this.body_length = this.body.length();
    }

    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        CallFrame callFrame = interp.newCallFrame(this, tclObjectArray);
        interp.pushDebugStack(this.srcFileName, this.srcLineNumber);
        try {
            try {
                Parser.eval2(interp, this.body.array, this.body.index, this.body_length, 0);
            }
            catch (TclException tclException) {
                int n = tclException.getCompletionCode();
                if (n == 2) {
                    int n2 = interp.updateReturnInfo();
                    if (n2 != 0) {
                        tclException.setCompletionCode(n2);
                        throw tclException;
                    }
                }
                if (n == 1) {
                    interp.addErrorInfo("\n    (procedure \"" + tclObjectArray[0] + "\" line " + interp.errorLine + ")");
                    throw tclException;
                }
                if (n == 3) {
                    throw new TclException(interp, "invoked \"break\" outside of a loop");
                }
                if (n == 4) {
                    throw new TclException(interp, "invoked \"continue\" outside of a loop");
                }
                throw tclException;
            }
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            interp.popDebugStack();
            if (interp.errInProgress) {
                callFrame.dispose();
                interp.errInProgress = true;
            } else {
                callFrame.dispose();
            }
            throw throwable;
        }
        interp.popDebugStack();
        if (interp.errInProgress) {
            callFrame.dispose();
            interp.errInProgress = true;
        } else {
            callFrame.dispose();
        }
    }

    public void disposeCmd() {
        this.body = null;
        int n = 0;
        while (n < this.argList.length) {
            this.argList[n][0].release();
            this.argList[n][0] = null;
            if (this.argList[n][1] != null) {
                this.argList[n][1].release();
                this.argList[n][1] = null;
            }
            ++n;
        }
        this.argList = null;
    }

    static boolean isProc(WrappedCommand wrappedCommand) {
        return wrappedCommand.cmd instanceof Procedure;
    }

    static Procedure findProc(Interp interp, String string) {
        WrappedCommand wrappedCommand;
        try {
            wrappedCommand = NamespaceCmd.findCommand(interp, string, null, 0);
        }
        catch (TclException tclException) {
            throw new TclRuntimeError("unexpected TclException: " + (Object)((Object)tclException));
        }
        if (wrappedCommand == null) {
            return null;
        }
        WrappedCommand wrappedCommand2 = NamespaceCmd.getOriginalCommand(wrappedCommand);
        if (wrappedCommand2 != null) {
            wrappedCommand = wrappedCommand2;
        }
        if (!(wrappedCommand.cmd instanceof Procedure)) {
            return null;
        }
        return (Procedure)wrappedCommand.cmd;
    }
}

