/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Hashtable;
import tcl.lang.ArrayObject;
import tcl.lang.CommandWithDispose;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.JavaInvoke;
import tcl.lang.TclException;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.Util;

public class ReflectObject
extends InternalRep
implements CommandWithDispose {
    Object javaObj;
    Interp ownerInterp;
    int refID;
    private int useCount;
    private boolean isValid;
    Hashtable bindings;

    private static ReflectObject makeReflectObject(Interp interp, Object object) {
        ReflectObject reflectObject = null;
        if (object != null) {
            reflectObject = (ReflectObject)interp.reflectObjTable.get(object);
        }
        if (reflectObject != null) {
            ++reflectObject.useCount;
            return reflectObject;
        }
        reflectObject = object != null && object.getClass().isArray() ? new ArrayObject() : new ReflectObject();
        reflectObject.ownerInterp = interp;
        reflectObject.javaObj = object;
        if (reflectObject.javaObj != null) {
            ++interp.reflectObjCount;
            reflectObject.refID = (int)interp.reflectObjCount;
            interp.createCommand("java0x" + Integer.toHexString(reflectObject.refID), reflectObject);
            interp.reflectIDTable.put(new Integer(reflectObject.refID), reflectObject);
            interp.reflectObjTable.put(object, reflectObject);
        } else {
            reflectObject.refID = 0;
        }
        reflectObject.useCount = 1;
        reflectObject.isValid = true;
        return reflectObject;
    }

    protected void dispose() {
        --this.useCount;
        if (this.useCount == 0 && this.refID != 0) {
            this.ownerInterp.deleteCommand("java0x" + Integer.toHexString(this.refID));
            this.ownerInterp.reflectIDTable.remove(new Integer(this.refID));
            this.ownerInterp.reflectObjTable.remove(this.javaObj);
            this.ownerInterp = null;
            this.javaObj = null;
            this.refID = 0;
            this.bindings = null;
        }
    }

    protected InternalRep duplicate() {
        ++this.useCount;
        return this;
    }

    private static void setReflectObjectFromAny(Interp interp, TclObject tclObject) throws TclException {
        ReflectObject reflectObject;
        InternalRep internalRep = tclObject.getInternalRep();
        if (internalRep instanceof ReflectObject) {
            reflectObject = (ReflectObject)internalRep;
            if (reflectObject.isValid && reflectObject.ownerInterp == interp) {
                return;
            }
        }
        try {
            String string = tclObject.toString();
            if (string.startsWith("java")) {
                int n = Util.getInt(interp, string.substring(4));
                if (n == 0) {
                    tclObject.setInternalRep((InternalRep)ReflectObject.makeReflectObject(interp, null));
                    return;
                }
                reflectObject = (ReflectObject)interp.reflectIDTable.get(new Integer(n));
                if (reflectObject != null && reflectObject.isValid) {
                    ++reflectObject.useCount;
                    tclObject.setInternalRep((InternalRep)reflectObject);
                    return;
                }
            }
        }
        catch (TclException tclException) {}
        throw new TclException(interp, "unknown java object \"" + tclObject + "\"");
    }

    public static TclObject newInstance(Interp interp, Object object) {
        return new TclObject((InternalRep)ReflectObject.makeReflectObject(interp, object));
    }

    public static Object get(Interp interp, TclObject tclObject) throws TclException {
        ReflectObject.setReflectObjectFromAny(interp, tclObject);
        ReflectObject reflectObject = (ReflectObject)tclObject.getInternalRep();
        return reflectObject.javaObj;
    }

    static ReflectObject getReflectObject(Interp interp, TclObject tclObject) throws TclException {
        ReflectObject.setReflectObjectFromAny(interp, tclObject);
        return (ReflectObject)tclObject.getInternalRep();
    }

    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        int n;
        boolean bl;
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "?-noconvert? signature ?arg arg ...?");
        }
        String string = tclObjectArray[1].toString();
        if (string.length() >= 2 && "-noconvert".startsWith(string)) {
            bl = false;
            n = 2;
        } else {
            bl = true;
            n = 1;
        }
        if (tclObjectArray.length < n + 1) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "?-noconvert? signature ?arg arg ...?");
        }
        int n2 = n + 1;
        int n3 = tclObjectArray.length - n2;
        interp.setResult(JavaInvoke.callMethod(interp, tclObjectArray[0], tclObjectArray[n], tclObjectArray, n2, n3, bl));
    }

    public void disposeCmd() {
        this.isValid = false;
    }

    public String toString() {
        return "java0x" + Integer.toHexString(this.refID);
    }

    static void init(Interp interp) {
        interp.reflectIDTable = new Hashtable();
        interp.reflectObjTable = new Hashtable();
        interp.reflectObjCount = 0L;
    }
}

