/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.BackSlashResult;
import tcl.lang.CharPointer;
import tcl.lang.Interp;
import tcl.lang.ParseResult;
import tcl.lang.Parser;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclParse;
import tcl.lang.TclString;
import tcl.lang.TclToken;

class ParseAdaptor {
    static ParseResult parseVar(Interp interp, String string, int n, int n2) throws TclException {
        ParseResult parseResult = Parser.parseVar(interp, string.substring(--n, n2));
        parseResult.nextIndex += n;
        return parseResult;
    }

    static ParseResult parseNestedCmd(Interp interp, String string, int n, int n2) throws TclException {
        CharPointer charPointer = new CharPointer(string);
        charPointer.index = n;
        interp.evalFlags |= 1;
        Parser.eval2(interp, charPointer, n2 - n, 0);
        TclObject tclObject = interp.getResult();
        tclObject.preserve();
        return new ParseResult(tclObject, n + interp.termOffset + 1);
    }

    static ParseResult parseQuotes(Interp interp, String string, int n, int n2) throws TclException {
        CharPointer charPointer = new CharPointer(string);
        charPointer.index = n;
        TclParse tclParse = new TclParse(interp, string.toCharArray(), n + n2 - 1, null, 0);
        tclParse.commandStart = charPointer.index;
        TclToken tclToken = tclParse.getToken(0);
        tclToken.type = 1;
        tclToken.script.array = charPointer.array;
        tclToken.script.index = charPointer.index;
        ++tclParse.numTokens;
        ++tclParse.numWords;
        tclParse = Parser.parseTokens(charPointer, 8, tclParse);
        charPointer.index = tclParse.termIndex + 1;
        tclToken = tclParse.getToken(0);
        tclToken.size = charPointer.index - tclToken.script.index;
        tclToken.numComponents = tclParse.numTokens - 1;
        if (tclToken.numComponents == 1 && tclParse.getToken((int)1).type == 4) {
            tclToken.type = 2;
        }
        tclParse.commandSize = charPointer.index - tclParse.commandStart;
        if (tclParse.numTokens <= 0) {
            throw new TclException(interp, "parseQuotes error: null obj result");
        }
        TclObject tclObject = Parser.evalTokens(interp, tclParse.tokenList, 1, tclParse.numTokens - 1);
        return new ParseResult(tclObject, charPointer.index);
    }

    static ParseResult parseBraces(Interp interp, String string, int n, int n2) throws TclException {
        CharPointer charPointer = new CharPointer(string);
        charPointer.index = n;
        int n3 = 1;
        while (true) {
            char c;
            if (Parser.typeTable[c = charPointer.charAt()] == '\u0000') {
                ++charPointer.index;
                continue;
            }
            if (charPointer.charAt() == '}') {
                if (--n3 == 0) break;
                ++charPointer.index;
                continue;
            }
            if (charPointer.charAt() == '{') {
                ++n3;
                ++charPointer.index;
                continue;
            }
            if (charPointer.charAt() == '\\') {
                BackSlashResult backSlashResult = Parser.backslash(charPointer);
                charPointer.index = backSlashResult.nextIndex;
                continue;
            }
            if (charPointer.index >= n2) {
                throw new TclException(interp, "missing close-brace");
            }
            ++charPointer.index;
        }
        String string2 = new String(charPointer.array, n, charPointer.index - n);
        return new ParseResult(TclString.newInstance((String)string2), charPointer.index + 1);
    }

    ParseAdaptor() {
    }
}

