/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import tcl.lang.CallFrame;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.Parser;
import tcl.lang.Procedure;
import tcl.lang.TclBoolean;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;

class InfoCmd
implements Command {
    private static final String[] validCmds = new String[]{"args", "body", "cmdcount", "commands", "complete", "default", "exists", "globals", "hostname", "level", "library", "loaded", "locals", "nameofexecutable", "patchlevel", "procs", "script", "sharedlibextension", "tclversion", "vars"};
    static final int OPT_ARGS = 0;
    static final int OPT_BODY = 1;
    static final int OPT_CMDCOUNT = 2;
    static final int OPT_COMMANDS = 3;
    static final int OPT_COMPLETE = 4;
    static final int OPT_DEFAULT = 5;
    static final int OPT_EXISTS = 6;
    static final int OPT_GLOBALS = 7;
    static final int OPT_HOSTNAME = 8;
    static final int OPT_LEVEL = 9;
    static final int OPT_LIBRARY = 10;
    static final int OPT_LOADED = 11;
    static final int OPT_LOCALS = 12;
    static final int OPT_NAMEOFEXECUTABLE = 13;
    static final int OPT_PATCHLEVEL = 14;
    static final int OPT_PROCS = 15;
    static final int OPT_SCRIPT = 16;
    static final int OPT_SHAREDLIBEXTENSION = 17;
    static final int OPT_TCLVERSION = 18;
    static final int OPT_VARS = 19;

    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "option ?arg arg ...?");
        }
        int n = TclIndex.get(interp, tclObjectArray[1], validCmds, "option", 0);
        switch (n) {
            case 0: {
                Command command;
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "procname");
                }
                Hashtable hashtable = interp.cmdTable;
                TclObject tclObject = tclObjectArray[2];
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                if ((command = (Command)hashtable.get(tclObject.stringRep)) == null || !(command instanceof Procedure)) {
                    throw new TclException(interp, "\"" + tclObjectArray[2] + "\" isn't a procedure");
                }
                Procedure procedure = (Procedure)command;
                tclObject = TclList.newInstance();
                int n2 = 0;
                while (n2 < procedure.argList.length) {
                    TclObject tclObject2 = procedure.argList[n2][0];
                    String string = ((Object)tclObject2).toString();
                    tclObject2 = new TclObject(new TclString(), string);
                    TclList.append(interp, tclObject, tclObject2);
                    ++n2;
                }
                interp.setResult(tclObject);
                return;
            }
            case 1: {
                Command command;
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "procname");
                }
                Hashtable hashtable = interp.cmdTable;
                TclObject tclObject = tclObjectArray[2];
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                if ((command = (Command)hashtable.get(tclObject.stringRep)) == null || !(command instanceof Procedure)) {
                    throw new TclException(interp, "\"" + tclObjectArray[2] + "\" isn't a procedure");
                }
                Procedure procedure = (Procedure)command;
                tclObject = procedure.body;
                String string = ((Object)tclObject).toString();
                tclObject = new TclObject(new TclString(), string);
                interp.setResult(tclObject);
                return;
            }
            case 2: {
                if (tclObjectArray.length != 2) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, null);
                }
                int n3 = interp.cmdCount;
                interp.setResult(TclInteger.newInstance(n3));
                return;
            }
            case 3: {
                if (tclObjectArray.length != 2 && tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "?pattern?");
                }
                if (tclObjectArray.length == 2) {
                    this.matchAndAppend(interp, interp.cmdTable.keys(), null);
                    return;
                }
                Enumeration enumeration = interp.cmdTable.keys();
                TclObject tclObject = tclObjectArray[2];
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                this.matchAndAppend(interp, enumeration, tclObject.stringRep);
                return;
            }
            case 4: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "command");
                }
                Object object = tclObjectArray[2];
                if (((TclObject)object).stringRep == null) {
                    ((TclObject)object).stringRep = ((TclObject)object).internalRep.toString();
                }
                object = ((TclObject)object).stringRep;
                interp.setResult(TclBoolean.newInstance(Parser.commandComplete((String)object, ((String)object).length())));
                return;
            }
            case 5: {
                Command command;
                if (tclObjectArray.length != 5) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "procname arg varname");
                }
                Object object = tclObjectArray[2];
                if (((TclObject)object).stringRep == null) {
                    ((TclObject)object).stringRep = ((TclObject)object).internalRep.toString();
                }
                object = ((TclObject)object).stringRep;
                Object object2 = tclObjectArray[3];
                if (((TclObject)object2).stringRep == null) {
                    ((TclObject)object2).stringRep = ((TclObject)object2).internalRep.toString();
                }
                object2 = ((TclObject)object2).stringRep;
                Hashtable hashtable = interp.cmdTable;
                TclObject tclObject = tclObjectArray[2];
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                if ((command = (Command)hashtable.get(tclObject.stringRep)) == null || !(command instanceof Procedure)) {
                    throw new TclException(interp, "\"" + tclObjectArray[2] + "\" isn't a procedure");
                }
                Procedure procedure = (Procedure)command;
                int n4 = 0;
                while (n4 < procedure.argList.length) {
                    Object object3 = procedure.argList[n4][0];
                    if (((TclObject)object3).stringRep == null) {
                        ((TclObject)object3).stringRep = ((TclObject)object3).internalRep.toString();
                    }
                    if (((String)object2).equals(((TclObject)object3).stringRep)) {
                        object3 = tclObjectArray[4];
                        if (((TclObject)object3).stringRep == null) {
                            ((TclObject)object3).stringRep = ((TclObject)object3).internalRep.toString();
                        }
                        object3 = ((TclObject)object3).stringRep;
                        try {
                            if (procedure.argList[n4][1] != null) {
                                TclObject tclObject3 = procedure.argList[n4][1];
                                interp.varFrame.setVar((String)object3, tclObject3, 0);
                                interp.setResult(TclInteger.newInstance(1));
                                return;
                            }
                            TclObject tclObject4 = TclString.newInstance("");
                            interp.varFrame.setVar((String)object3, tclObject4, 0);
                            interp.setResult(TclInteger.newInstance(0));
                            return;
                        }
                        catch (TclException tclException) {
                            throw new TclException(interp, "couldn't store default value in variable \"" + (String)object3 + "\"");
                        }
                    }
                    ++n4;
                }
                throw new TclException(interp, "procedure \"" + (String)object + "\" doesn't have an argument \"" + (String)object2 + "\"");
            }
            case 6: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "varName");
                }
                CallFrame callFrame = interp.varFrame;
                TclObject tclObject = tclObjectArray[2];
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                boolean bl = callFrame.exists(tclObject.stringRep);
                interp.setResult(TclBoolean.newInstance(bl));
                return;
            }
            case 7: {
                if (tclObjectArray.length != 2 && tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "?pattern?");
                }
                if (tclObjectArray.length == 2) {
                    this.matchAndAppend(interp, interp.globalFrame.getVarNames(), null);
                    return;
                }
                Vector vector = interp.globalFrame.getVarNames();
                TclObject tclObject = tclObjectArray[2];
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                this.matchAndAppend(interp, vector, tclObject.stringRep);
                return;
            }
            case 8: {
                if (tclObjectArray.length != 2) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, null);
                }
                if ("no host info" == null) {
                    interp.resetResult();
                    return;
                }
                interp.setResult(TclString.newInstance("no host info"));
                return;
            }
            case 9: {
                if (tclObjectArray.length != 2 && tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "?number?");
                }
                if (tclObjectArray.length == 2) {
                    if (interp.varFrame == null) {
                        interp.setResult(TclInteger.newInstance(0));
                        return;
                    }
                    int n5 = interp.varFrame.m_level;
                    interp.setResult(TclInteger.newInstance(n5));
                    return;
                }
                int n6 = TclInteger.get(interp, tclObjectArray[2]);
                if (n6 > 0) {
                    if (interp.varFrame == null) {
                        throw new TclException(interp, "bad level \"" + n6 + "\"");
                    }
                    n6 -= interp.varFrame.m_level;
                }
                CallFrame callFrame = interp.varFrame;
                int n7 = n6;
                while (n7 != 0) {
                    if (callFrame == null) break;
                    callFrame = callFrame.callerVar;
                    ++n7;
                }
                if (callFrame == null || callFrame.m_argv == null) {
                    throw new TclException(interp, "bad level \"" + n6 + "\"");
                }
                TclObject tclObject = TclList.newInstance();
                int n8 = 0;
                while (n8 < callFrame.m_argv.length) {
                    TclObject tclObject5 = callFrame.m_argv[n8];
                    String string = ((Object)tclObject5).toString();
                    TclObject tclObject6 = new TclObject(new TclString(), string);
                    TclList.append(interp, tclObject, tclObject6);
                    ++n8;
                }
                interp.setResult(tclObject);
                return;
            }
            case 10: {
                if (tclObjectArray.length != 2) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, null);
                }
                TclObject tclObject = interp.varFrame.getVar("tcl_library", 2049);
                if (tclObject != null) {
                    interp.setResult(tclObject);
                    return;
                }
                throw new TclException(interp, "no library has been specified for Tcl");
            }
            case 11: {
                if (tclObjectArray.length != 2 && tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "?interp?");
                }
                throw new TclException(interp, "info loaded not implemented");
            }
            case 12: {
                if (tclObjectArray.length != 2 && tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "?pattern?");
                }
                if (interp.varFrame == interp.globalFrame) {
                    return;
                }
                if (tclObjectArray.length == 2) {
                    this.matchAndAppend(interp, interp.varFrame.getLocalVarNames(), null);
                    return;
                }
                Vector vector = interp.varFrame.getLocalVarNames();
                TclObject tclObject = tclObjectArray[2];
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                this.matchAndAppend(interp, vector, tclObject.stringRep);
                return;
            }
            case 13: {
                if (tclObjectArray.length != 2) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, null);
                }
                interp.setResult(TclString.newInstance(""));
                return;
            }
            case 14: {
                if (tclObjectArray.length != 2) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, null);
                }
                interp.setResult(interp.varFrame.getVar("tcl_patchLevel", 1));
                return;
            }
            case 15: {
                Object object;
                String string = null;
                if (tclObjectArray.length != 2 && tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "?pattern?");
                }
                if (tclObjectArray.length == 3) {
                    object = tclObjectArray[2];
                    if (((TclObject)object).stringRep == null) {
                        ((TclObject)object).stringRep = ((TclObject)object).internalRep.toString();
                    }
                    string = ((TclObject)object).stringRep;
                }
                object = new StringBuffer();
                Enumeration enumeration = interp.cmdTable.keys();
                while (enumeration.hasMoreElements()) {
                    Command command;
                    String string2 = (String)enumeration.nextElement();
                    if (string != null && !Util.stringMatch(string2, string) || !((command = (Command)interp.cmdTable.get(string2)) instanceof Procedure)) continue;
                    Util.appendElement(interp, (StringBuffer)object, string2);
                }
                interp.setResult(TclString.newInstance((StringBuffer)object));
                return;
            }
            case 16: {
                if (tclObjectArray.length != 2) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, null);
                }
                interp.setResult(TclString.newInstance(interp.scriptFile));
                return;
            }
            case 17: {
                if (tclObjectArray.length != 2) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, null);
                }
                if (".class" == null) {
                    interp.resetResult();
                    return;
                }
                interp.setResult(TclString.newInstance(".class"));
                return;
            }
            case 18: {
                if (tclObjectArray.length != 2) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, null);
                }
                interp.setResult(interp.varFrame.getVar("tcl_version", 1));
                return;
            }
            case 19: {
                if (tclObjectArray.length != 2 && tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "?pattern?");
                }
                if (tclObjectArray.length == 2) {
                    this.matchAndAppend(interp, interp.varFrame.getVarNames(), null);
                    return;
                }
                Vector vector = interp.varFrame.getVarNames();
                TclObject tclObject = tclObjectArray[2];
                if (tclObject.stringRep == null) {
                    tclObject.stringRep = tclObject.internalRep.toString();
                }
                this.matchAndAppend(interp, vector, tclObject.stringRep);
                return;
            }
        }
        throw new TclException(interp, String.valueOf(tclObjectArray[0]) + " " + tclObjectArray[1] + " function not yet implemented");
    }

    private void matchAndAppend(Interp interp, Enumeration enumeration, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string != null && !Util.stringMatch(string2, string)) continue;
            try {
                Util.appendElement(interp, stringBuffer, string2);
            }
            catch (TclException tclException) {
                throw new TclRuntimeError("unexpected TclException: " + tclException);
            }
        }
        interp.setResult(TclString.newInstance(stringBuffer));
    }

    private void matchAndAppend(Interp interp, Vector vector, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)vector.elementAt(n2);
            if (string == null || Util.stringMatch(string2, string)) {
                try {
                    Util.appendElement(interp, stringBuffer, string2);
                }
                catch (TclException tclException) {
                    throw new TclRuntimeError("unexpected TclException: " + tclException);
                }
            }
            ++n2;
        }
        interp.setResult(TclString.newInstance(stringBuffer));
    }

    InfoCmd() {
    }
}

