'\" -*- tcl -*- doctools manpage
'\"
'\" Generated from ../tcllib/modules/ftpd/ftpd.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "ftpd" n 1.1.2 ftpd "Tcl FTP Server Package"
.BS
.SH NAME
ftpd \- Tcl FTP server implementation
.SH "SYNOPSIS"
package require \fBTcl 8.3\fR
.sp
package require \fBftpd ?1.1.2?\fR
.sp
\fB::ftpd::server\fR ?\fImyaddr\fR?\fR
.sp
\fB::ftpd::config\fR ?\fIoption value\fR? ?\fIoption value ...\fR?\fR
.sp
\fIfsCmd\fR \fBappend\fR \fIpath\fR\fR
.sp
\fIfsCmd\fR \fBdelete\fR \fIpath\fR \fIchannel\fR\fR
.sp
\fIfsCmd\fR \fBdlist\fR \fIpath\fR \fIstyle\fR \fIchannel\fR\fR
.sp
\fIfsCmd\fR \fBexists\fR \fIpath\fR\fR
.sp
\fIfsCmd\fR \fBmkdir\fR \fIpath\fR \fIchannel\fR\fR
.sp
\fIfsCmd\fR \fBmtime\fR \fIpath\fR \fIchannel\fR\fR
.sp
\fIfsCmd\fR \fBpermissions\fR \fIpath\fR\fR
.sp
\fIfsCmd\fR \fBrename\fR \fIpath\fR \fInewpath\fR \fIchannel\fR\fR
.sp
\fIfsCmd\fR \fBretr\fR \fIpath\fR\fR
.sp
\fIfsCmd\fR \fBrmdir\fR \fIpath\fR \fIchannel\fR\fR
.sp
\fIfsCmd\fR \fBsize\fR \fIpath\fR \fIchannel\fR\fR
.sp
\fIfsCmd\fR \fBstore\fR \fIpath\fR\fR
.sp
.BE
.SH "DESCRIPTION"
The \fBftpd\fR package provides a simple Tcl-only server library
for the FTP protocol.  It works by listening on the standard FTP
socket.  Most server errors are returned as error messages with the
appropriate code attached to them.  Since the server code for the ftp
daemon is executed in the event loop, it is possible that a
\fBbgerror\fR will be thrown on the server if there are problems with
the code in the module.
.SH "COMMANDS"
.TP
\fB::ftpd::server\fR ?\fImyaddr\fR?\fR
Open a listening socket to listen to and accept ftp connections.
myaddr is an optional argument.  \fImyaddr\fR is the domain-style name
or numerical IP address of the client-side network interface to use
for the connection.
.TP
\fB::ftpd::config\fR ?\fIoption value\fR? ?\fIoption value ...\fR?\fR
The value is always the name of the command to call as the
callback. The option specifies which callback should be configured.
See section \fBCALLBACKS\fR for descriptions of the arguments and
return values for each of the callbacks.
.RS
.TP
-authIpCmd \fIproc\fR
Callback to authenticate new connections based on the ip-address of
the peer.
.TP
-authUsrCmd \fIproc\fR
Callback to authenticate new connections based on the user logging in
(and the users password).
.TP
-authFileCmd \fIproc\fR
Callback to accept or deny a users access to read and write to a
specific path or file.
.TP
-logCmd \fIproc\fR
Callback for log information generated by the FTP engine.
.TP
-fsCmd \fIproc\fR
Callback to connect the engine to the filesystem it operates on.
.RE
.SH "CALLBACKS"
.TP
\fBauthIpCmd callback\fR
The authIpCmd receives the ip-address of the peer attempting to
connect to the ftp server as its argument. It returns a 1 to allow
users from the specified IP to attempt to login and a 0 to reject the
login attempt from the specified IP.
.TP
\fBauthUsrCmd callback\fR
The authUsrCmd receives the username and password as its two
arguments. It returns a 1 to accept the attempted login to the ftpd
and a 0 to reject the attempted login.
.TP
\fBauthFileCmd callback\fR
The authFileCmd receives the user (that is currently logged in), the
path or filename that is about to be read or written, and
\fBread\fR or \fBwrite\fR as its three arguments.  It returns a
1 to allow the path or filename to be read or written, and a 0 to
reject the attempted read or write with a permissions error code.
.TP
\fBlogCmd callback\fR
The logCmd receives a severity and a message as its two arguments.
The severities used within the ftpd package are \fBnote\fR,
\fBdebug\fR, and \fBerror\fR. The logCmd doesn't return
anything.
.TP
\fBfsCmd callback\fR
The fsCmd receives a subcommand, a filename or path, and optional
additional arguments (depending on the subcommand).
.sp
The subcommands supported by the fsCmd are:
.RS
.TP
\fIfsCmd\fR \fBappend\fR \fIpath\fR\fR
The append subcommand receives the filename to append to as its
argument. It returns a writable tcl channel as its return value.
.TP
\fIfsCmd\fR \fBdelete\fR \fIpath\fR \fIchannel\fR\fR
The delete subcommand receives the filename to delete, and a channel
to write to as its two arguments.  The file specified is deleted and
the appropriate ftp message is written to the channel that is passed
as the second argument.  The delete subcommand returns nothing.
.TP
\fIfsCmd\fR \fBdlist\fR \fIpath\fR \fIstyle\fR \fIchannel\fR\fR
The dlist subcommand receives the path that it should list the files
that are in, the style in which the files should be listed which is
either \fBnlst\fR or \fBlist\fR, and a channel to write to as
its three arguments.  The files in the specified path are printed to
the specified channel one per line.  If the style is \fBnlst\fR
only the name of the file is printed to the channel.  If the style is
\fBlist\fR then the file permissions, number of links to the file,
the name of the user that owns the file, the name of the group that
owns the file, the size (in bytes) of the file, the modify time of the
file, and the filename are printed out to the channel in a formatted
space separated format.  The \fBdlist\fR subcommand returns
nothing.
.TP
\fIfsCmd\fR \fBexists\fR \fIpath\fR\fR
The exists subcommand receives the name of a file to check the
existence of as its only argument.  The exists subcommand returns a 1
if the path specified exists and the path is not a directory.
.TP
\fIfsCmd\fR \fBmkdir\fR \fIpath\fR \fIchannel\fR\fR
The mkdir subcommand receives the path of a directory to create and a
channel to write to as its two arguments.  The mkdir subcommand
creates the specified directory if necessary and possible.  The mkdir
subcommand then prints the appropriate success or failure message to
the channel.  The mkdir subcommand returns nothing.
.TP
\fIfsCmd\fR \fBmtime\fR \fIpath\fR \fIchannel\fR\fR
The mtime subcommand receives the path of a file to check the modify
time on and a channel as its two arguments.  If the file exists the
mtime is printed to the channel in the proper FTP format, otherwise an
appropriate error message and code are printed to the channel.  The
mtime subcommand returns nothing.
.TP
\fIfsCmd\fR \fBpermissions\fR \fIpath\fR\fR
The permissions subcommand receives the path of a file to retrieve the
permissions of.  The permissions subcommand returns the octal file
permissions of the specified file.  The file is expected to exist.
.TP
\fIfsCmd\fR \fBrename\fR \fIpath\fR \fInewpath\fR \fIchannel\fR\fR
The rename subcommand receives the path of the current file, the new
file path, and a channel to write to as its three arguments.  The
rename subcommand renames the current file to the new file path if the
path to the new file exists, and then prints out the appropriate
message to the channel.  If the new file path doesn't exist the
appropriate error message is printed to the channel.  The rename
subcommand returns nothing.
.TP
\fIfsCmd\fR \fBretr\fR \fIpath\fR\fR
The retr subcommand receives the path of a file to read as its only
argument.  The retr subcommand returns a readable channel that the
specified file can be read from.
.TP
\fIfsCmd\fR \fBrmdir\fR \fIpath\fR \fIchannel\fR\fR
The rmdir subcommand receives the path of a directory to remove and a
channel to write to as its two arguments.  The rmdir subcommand
removes the specified directory (if possible) and prints the
appropriate message to the channel (which may be an error if the
specified directory does not exist or is not empty).  The rmdir
subcommand returns nothing.
.TP
\fIfsCmd\fR \fBsize\fR \fIpath\fR \fIchannel\fR\fR
The size subcommand receives the path of a file to get the size (in
bytes) of and a channel to write to as its two arguments.  The size
subcommand prints the appropriate code and the size of the file if the
specified path is a file, otherwise an appropriate error code and
message are printed to the channel.  The size subcommand returns
nothing.
.TP
\fIfsCmd\fR \fBstore\fR \fIpath\fR\fR
The store subcommand receives the path of a file to write as its only
argument.  The store subcommand returns a writable channel.
.RE
.SH "VARIABLES"
.TP
\fB::ftpd::cwd\fR
The current working directory for a session when someone first
connects to the FTPD or when the \fBREIN\fR ftp command is received.
.TP
\fB::ftpd::contact\fR
The e-mail address of the person that is the contact for the ftp
server.  This address is printed out as part of the response to the
\fBFTP HELP\fR command.
.TP
\fB::ftpd::port\fR
The port that the ftp server should listen on.
.TP
\fB::ftpd::welcome\fR
The message that is printed out when the user first connects to the
ftp server.
.SH "KEYWORDS"
ftpd, ftp, ftpserver, services, rfc 959
