'\"
'\" Copyright (c) 1998-2000 by Ajuba Solutions.
'\" All rights reserved.
'\" 
'\" RCS: @(#) $Id: counter.n,v 1.1 2000/10/03 03:52:59 welch Exp $
'\" 
.so man.macros
.TH counter n 1.0 Counter "Counters and Histograms"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
::counter \- Procedures for counters and histograms.
.SH SYNOPSIS
.BS
.sp
\fBcounter::init\fR \fItag\fR \fIargs\fR
.sp
\fBcounter::count\fR \fItag {delta 1} args\fR
.sp
\fBcounter::reset\fR \fItag\fR
.sp
\fBcounter::get\fR \fItag args\fR
.sp
\fBcounter::start\fR \fItag\fR
.sp
\fBcounter::stop\fR \fItag\fR
.sp
\fBcounter::exists\fR \fItag\fR
.sp
\fBcounter::names\fR \fItag\fR
.sp
\fBcounter::histHtmlDisplay\fR \fItag args\fR
.BE
.SH DESCRIPTION
.PP
The \fB::counter\fR package provides a counter facility and
can compute statistics and histograms over the collected data.

.TP
\fBcounter::init\fR \fItag args\fR
This defines a counter with the name \fItag\fP.
The \fIargs\fP determines the characteristics of the counter.
The \fIargs\fP are

.TP
\fB-group\fR \fIname\fR
Keep a grouped counter where the name of the histogram bucket
is passed into \fBcounter::count\fP.

.TP
\fB-hist\fR \fIbucketsize\fR
Accumulate the counter into histogram buckets of size
\fIbucketsize\fP.  For example, if the samples are millesecond
time values and \fIbucketsize\fP is 10, then each
histogram bucket represents time values of
0 to 10 msec, 10 to 20 msec, 20 to 30 msec, and so on.

.TP
\fB-hist2x\fR \fIbucketsize\fR
Accumulate the statistic into histogram buckets.
The size of the first bucket is 
\fIbucketsize\fP, each other bucket holds values
2 times the size of the previous bucket.
For example, if \fIbucketsize\fP is 10, then each
histogram bucket represents time values of
0 to 10 msec, 10 to 20 msec, 20 to 40 msec, 40 to 80 msec, and so on.

.TP
\fB-hist10x\fR \fIbucketsize\fR
Accumulate the statistic into histogram buckets.
The size of the first bucket is 
\fIbucketsize\fP, each other bucket holds values
10 times the size of the previous bucket.
For example, if \fIbucketsize\fP is 10, then each
histogram bucket represents time values of
0 to 10 msec, 10 to 100 msec, 100 to 1000 msec, and so on.

.TP
\fB-lastn\fR \fIN\fR
Save the last \fIN\fP values of the counter to maintain
a "running average" over the last \fIN\fP values.

.TP
\fB-timehist\fR \fIsecsPerMinute\fR
Keep a time-based histogram.
The counter is summed into a histogram bucket based on the current time.
There are 60 per-minute buckets that have a size determined by
\fIsecsPerMinute\fP, which
is normally 60, but for testing purposes can be less.
Every "hour" (i.e., 60 "minutes") the contents of the per-minute buckets are summed
into the next hourly bucket.
Every 24 "hours" the contents of the per-hour buckets are summed into
the next daily bucket.
The counter package keeps all time-based histograms in sync, so the first
\fIsecsPerMinute\fP value seen by the package is used for all subsequent
time-based histograms.

.TP
\fBcounter::count\fR \fItag {delta 1} {instance {}}\fR
Increment the counter identified by \fItag\fP.
The default increment is 1, although you can increment
by any value, integer or real, by specifying \fIdelta\fP.
You must declare each counter with \fBcounter::init\fP to define
the characteristics of counter before you start to use it.
If the counter type is \fB-group\fP, then the counter
indentified by \fIinstance\fP is incremented.

.TP
\fBcounter::start\fR \fItag instance\fR
Record the starting time of an interval.
The \fItag\fP is the name of the counter defined as
a \fB-hist\fP value-based histogram.
The \fIinstance\fP is used to distinquish this interval from
any other intervals that might be overlapping this one.

.TP
\fBcounter::stop\fR \fItag instance\fR
Record the ending time of an interval.
The delta time since the corresponding \fBcountStart\fP call
for \fIinstance\fP is recorded in the histogram
identified by \fItag\fP.

.TP
\fBcounter::get\fR \fItag args\fR
Return statistics about a counter
identified by \fItag\fP.
The \fIargs\fP determine what value to return:
.TP
\fB-total\fP
Return the total value of the counter.  This is the default
if \fIargs\fP is not specified.
.TP
\fB-totalVar\fP
Return the name of the total variable.  Useful for
specifying with -textvariable in a Tk widget.
.TP
\fB-N\fP
Return the number of samples accumulated into the counter.
.TP
\fB-avg\fP
Return the average of samples accumulated into the counter.
.TP
\fB-avgn\fP
Return the average over the last \fIN\fP samples taken.
The \fIN\fP value is set in the \fBcounter::init\fP call.
.TP
\fB-hist\fP \fIbucket\fP
If \fIbucket\fP is specified, then the value in that bucket
of the histogram is returned.
Otherwise the complete histogram is returned
in array get format sorted by bucket.
.TP
\fB-histVar\fP
Return the name of the histogram array variable.
.TP
\fB-histHour\fP
Return the complete hourly histogram
in array get format sorted by bucket.
.TP
\fB-histHourVar\fP
Return the name of the hourly histogram array variable.
.TP
\fB-histDay\fP
Return the complete daily histogram
in array get format sorted by bucket.
.TP
\fB-histDayVar\fP
Return the name of the daily histogram array variable.
.TP
\fB-resetDate\fP
Return the clock seconds value recorded when the
counter was last reset.
.TP
\fB-all\fP
Return an array get of the array used to store the counter.
This includes the total, the number of samples (N), and any
type-specific information.  This does not include the
histogram array.

.TP
\fBcounter::exists\fR \fItag\fR
Returns 1 if the counter is defined.

.TP
\fBcounter::names\fR
Returns a list of all counters defined.

.TP
\fBcounter::histHtmlDisplay\fR \fItag args\fR
Generate HTML to display a histogram for a counter.
The \fIargs\fP control the format of the display.
They are:

.TP
\fB-title\fI string\fP
Label to display above bar chart
.TP
\fB-unit\fI unit\fP
Specify \fBminutes\fP, \fBhours\fP, or \fBdays\fP for the time-base histograms.
For value-based histograms, the \fIunit\fP is used in the title.
.TP
\fB-images\fI url\fP
URL of /images directory.
.TP
\fB-gif\fI filename\fP
Image for normal histogram bars.
The \fIfilename\fP is relative to the \fP-images\fP directory.
.TP
\fB-ongif\fI filename\fP
Image for the active histogram bar.
The \fIfilename\fP is relative to the \fP-images\fP directory.
.TP
\fB-max\fI N\fP
Maximum number of value-based buckets to display.
.TP
\fB-height\fI N\fP
Pixel height of the highest bar.
.TP
\fB-width\fI N\fP
Pixel width of each bar.
.TP
\fB-skip\fI N\fP
Buckets to skip when labeling value-based histograms.
.TP
\fB-format\fI string\fP
Format used to display labels of buckets.
.TP
\fB-text\fI boolean\fP
If 1, a text version of the histogram is dumped,
otherwise a graphical one is generated.
