/**********************************************************************
 exmh.c

 Modified from NC's sample elm.c for use with EXMH

 Add the following to your ~/.netscape/preferences.js file:

 user_pref("mail.use_altmail", true);
 user_pref("mail.altmail_dll", "/u/malmer/exmh.so");

 Copyright 1997 Netscape Communications Corporation, all rights reserved.
**********************************************************************/


#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include "postal.h"

#define EXMHUP "ExmhNsUp"
#define EXMHCOMP "ExmhNsComp"
#define EXMHNEWS "ExmhNsNews"

#define XTERM "/usr/local/bin/xterm"
#define TRN "/usr/local/bin/trn"


/*
 * fork_and_exec
 */
static int
fork_and_exec(char* argv[])
{
	if ( argv == NULL || argv[0] == NULL ) {
		return -1;
	}

	switch ( fork() ) {
		case -1:
			return -1;
		case 0:
			if ( execv(argv[0], argv) == -1 ) {
				perror(argv[0]);
				exit(errno);
			}
		default:	
			return 0;
	}
}


/*
 * create_tmp_file
 * Writes the message body to a temp file so we can pass the filename
 * to elm.
 */
static char*
create_tmp_file(char* body)
{
	char* name = tmpnam(NULL);
	FILE* file;

	if ( name && body && ((file = fopen(name, "w")) != NULL) ) {
		fwrite(body, sizeof(char), strlen(body), file);
		fclose(file);
	}

	return name;
}


/*
 * RegisterMailClient
 * Called when the Navigator is lauched.
 * Don't need to do anything for elm. (or exmh)
 */
int
RegisterMailClient(void)
{
	return 0;
}


/*
 * UnRegisterMailClient
 * Called on Navigator exit.
 * Don't need to do anything for elm. (or exmh)
 */
int
UnRegisterMailClient(void)
{
	return 0;
}


/*
 * OpenMailSession
 * Called when the first mail function is called.
 * Don't need to do anything for elm.
 * For EXMH, make sure it's running at this point
 */
int
OpenMailSession(void* reserved1, void* reserved2)
{
	char *argv[] = {EXMHSCRIPT EXMHUP, NULL};

	return fork_and_exec(argv);
}


/*
 * CloseMailSession
 * Called on Navigator exit.
 * Don't need to do anything for exmh.
 */
int
CloseMailSession(void)
{
	return 0;
}


/*
 * ComposeMailMessage
 * Called when mailto: link is selected, or "Send Link" menu item is chosen.
 * Only 'to', 'subject' and 'body' are used.
 * Tells exmh to fire up a new draft
 */
int 
ComposeMailMessage(void* reserved, char* to, char* org, char* subject,
		   char* body, char* cc, char* bcc)
{
	char *tempfile = tmpnam(NULL);
	FILE *schmutz;
	char *argv[3] = {EXMHSCRIPT EXMHCOMP, NULL, NULL};
	/* Schmutz everything into a file and let the script cope */
	if ((schmutz = fopen(tempfile, "w")) == NULL) {
		return -1;
	}
	if (to)
		fprintf(schmutz, "To: %s\n", to);
	else
		fprintf(schmutz, "To: \n");

	if (subject)
		fprintf(schmutz, "Subject: %s\n", subject);
	else
		fprintf(schmutz, "Subject: \n");

	fprintf(schmutz, "--------\n%s", body);

	fclose(schmutz);

	/* We now have a live draft. Pop off and do it */
	argv[1] = tempfile;
	return fork_and_exec(argv);
}


/*
 * ShowMailBox
 * Called when "Messenger Mailbox" menu item is chosen.
 * Run exmh if it isn't already
 */
int
ShowMailBox(void)
{
	char *argv[] = {EXMHSCRIPT EXMHUP, NULL};

	return fork_and_exec(argv);
}


/*
 * ShowMessageCenter
 * Called when "Collabra Discussions" menu item is chosen.
 * Does Nothing
 */
int
ShowMessageCenter(void)
{
	return 0;
}

/*
 * GetMenuItemString
 * Returns the string that should be used in place of "Messenger Mailbox".
 */
char*
GetMenuItemString(void)
{
	return "Launch Exmh";
}


/*
 * GetNewsMenuItemString
 * Returns the string that should be used in place of "Collabra Discussions".
 */
char*
GetNewsMenuItemString(void)
{
	return "Launch Newsreader";
}

/*
 * HandleNewsUrl
 * Called when news: link is selected.
 * Launches trn, ignores the url argument.
 */
int
HandleNewsUrl(char* url)
{
	char *argv[] = {EXMHSCRIPT EXMHNEWS, NULL, NULL};

	argv[1] = url;
	return fork_and_exec(argv);
}
