/* random.c */
#include <stdio.h>
#include <stdlib.h>
#include <tcl.h>

#if defined(__SVR4) || defined(__svr4__)
#define random() rand()
#endif

/*
 * RandomCmd --
 *	The implementation of the "random" Tcl command.  With no arguments
 *	the command returns a random positive integer.  If an argument is given,
 *	then it is used as the maximum value for the random number.
 */
int
RandomCmd( clientData, interp, argc, argv)
    ClientData clientData;
    Tcl_Interp *interp;
    int argc;
    char *argv[];
{
	int x, error;
	int limit = 0;
	if (argc > 2) {
		interp->result = "Usage: random ?range?";
		return TCL_ERROR;
	}
	if (argc == 2) {
		error = Tcl_GetInt(interp, argv[1], &limit);
		if (error != TCL_OK) {
			return error;
		}
	}
	x = random();
	if (limit != 0) {
		x = x % limit;
	}
	sprintf(interp->result, "%d", x);
	return TCL_OK;
}
