'\" Copyright 1989 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: /sprite/src/lib/tcl/RCS/Tcl_Merge.man,v 1.2 89/03/24 14:16:16 ouster Exp $ SPRITE (Berkeley)
'\" 
.so \*(]ltmac.sprite
.HS Tcl_Concat tcl
.BS
.SH NAME
Tcl_Concat \- concatenate a collection of strings
.SH SYNOPSIS
.nf
\fB#include <tcl.h>\fR
.sp
char *
\fBTcl_Concat\fR(\fIargc, argv\fR)
.SH ARGUMENTS
.AP int argc in
Number of strings.
.AP char *argv[] in
Array of strings to concatenate.  Must have \fIargc\fR entries.
.BE

.SH DESCRIPTION
.PP
\fBTcl_Concat\fR is a utility procedure used by several of the
Tcl commands.  Given a collection of strings, it concatenates
them together into a single string, with the original strings
separated by spaces.  This procedure behaves differently than
\fBTcl_Merge\fR, in that the arguments are simply concatenated:
no effort is made to ensure proper list structure.
The result string is dynamically allocated
using \fBmalloc()\fR;  the caller must eventually release the space
by calling \fBfree()\fR.

.SH KEYWORDS
concatenate, strings
