'\" Copyright 1989 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: /sprite/src/lib/tcl/RCS/Tcl_GetVar.man,v 1.3 90/03/11 17:22:41 ouster Exp $ SPRITE (Berkeley)
'\" 
.so \*(]ltmac.sprite
.HS Tcl_GetVar tcl
.BS
.SH NAME
Tcl_GetVar \- return the value of a Tcl variable
.SH SYNOPSIS
.nf
\fB#include <tcl.h>\fR
.sp
char *
\fBTcl_GetVar\fR(\fIinterp, varName, global\fR)
.SH ARGUMENTS
.AS Tcl_Interp *interp
.AP Tcl_Interp *interp in
Interpreter in which to check for variable.
.AP char *varName in
Name of desired variable.
.AP int global in
If non-zero, then insist that \fIvarName\fR be interpreted as
a global variable regardless of whether a procedure invocation
is in progress.
.BE

.SH DESCRIPTION
.PP
\fBTcl_GetVar\fR is a utility procedure used by several of the Tcl commands.
It returns the value of variable \fIvarName\fR in
interpreter \fIinterp\fR.  If there isn't a Tcl command procedure
being interpreted right now, or if \fIglobal\fR is non-zero,
then \fIvarName\fR is always treated
as the name of a global variable.  Otherwise, if a procedure is
being interpreted,
then \fIvarName\fR will be treated as a local variable name, unless
it has been declared global using the \fBglobal\fR command.  If
no variable by the name \fIvarName\fR exists right now, then a NULL
pointer is returned.

.SH KEYWORDS
interpreter, global, local, variable
