'\" Copyright 1989 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: /sprite/src/lib/tcl/RCS/Tcl_DeleteCommand.man,v 1.2 89/03/24 14:16:03 ouster Exp $ SPRITE (Berkeley)
'\" 
.so \*(]ltmac.sprite
.HS Tcl_DeleteCommand tcl
.BS
.SH NAME
Tcl_DeleteCommand \- remove a command from a Tcl interpreter
.SH SYNOPSIS
.nf
\fB#include <tcl.h>\fR
.sp
\fBTcl_DeleteCommand\fR(\fIinterp, cmdName\fR)
.SH ARGUMENTS
.AS Tcl_Interp *cmdName
.AP Tcl_Interp *interp in
Interpreter in which to delete command.
.AP char *cmdName in
Name of command to be deleted.
.BE

.SH DESCRIPTION
.PP
This procedure deletes a command from a command interpreter.
Once the call completes, attempts to invoke \fIcmdName\fR in
\fIinterp\fR will result in errors.  If \fIcmdName\fR isn't bound
as a command in \fIinterp\fR then \fBTcl_DeleteCommand\fR does nothing.
There are no restrictions on \fIcmdName\fR:  it may refer to
a built-in command, an application-specific command, or a Tcl procedure.

.SH KEYWORDS
command, delete, interpreter
