# Hyperlink-Men fr TeX/LaTeX-Syntax-Help
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Uni Bremen

proc TeX_syntax_help  {format} {# Hypertext version of xtem-syntax-help


proc hlpwin_fill {window filedir entry} {

  global  hlp_dir hlp_stack hlp_filedir hlp_bmlist

  if {$filedir=="miscellaneous/mainhelp"} {set hlp_stack ""}
  if {$hlp_stack==""} {.ts.a.2.b configure -state disabled} \
	  else {.ts.a.2.b configure -state normal}
  if {$hlp_stack==""} {.ts.a.2.t configure -state disabled} \
	  else {.ts.a.2.t configure -state normal}
  lvarpush hlp_stack $entry;  lvarpush hlp_stack $filedir
  set c_filedir $filedir
  set c_entry   $entry
  if {"$c_filedir"==""} {set c_filedir "???"}
  if {![file exists "${hlp_dir}${c_filedir}.htx"]} {
    set hlp_filedir $c_filedir
    set c_filedir "miscellaneous/missing_file";  set c_entry "missing_file"
  }
  # remove old tags, clear window etc.
  $window configure -state normal
  $window delete 0.0 end; update
  set hlp_bmlist ""; .ts.a.4.r configure -state disabled
  foreach tn [$window tag names] {if {$tn!="sel"} {$window tag delete $tn}}
  .ts.a.1.e configure -state disabled
  hlpwin_fillfile $window "$c_filedir" "$c_entry"
  if {$hlp_bmlist!=""} {.ts.a.4.r configure -state normal}
  .ts.a.1.e configure -state normal
  $window configure -state disabled

}

proc hlpwin_bitmap {w filedir} {

  global  vv hlp_dir hlp_pid hlp_cbm hlp_wgmdxy hlp_wgmx hlp_bmlist hlp_bmsuppr hlp_thisbm

  update

  if {[lsearch $hlp_bmlist $filedir]==-1} {set hlp_bmlist "$hlp_bmlist $filedir "}
  if  {($hlp_bmsuppr) && (!$hlp_thisbm)} return
  set file [crange $filedir [string last "/" "/$filedir"] end]
  incr hlp_cbm;  set dx [expr 250+20*$hlp_cbm]; set dy [expr 180+20*$hlp_cbm]
  set hlp_wgmdxy +${dx}+${dy}; set hlp_wgmx 600

  if       {([file exists $hlp_dir${filedir}.xbm]) ||  \
            ([file exists $hlp_dir${filedir}.xbm.gz])   } {# bitmap exists
    if {[file exists $hlp_dir${filedir}.xbm.gz]} {# bitmap is packed
      set xbmfile ".xtem_hlpxbm$hlp_cbm";    unlink -nocomplain $xbmfile
      exec gunzip -c $hlp_dir${filedir}.xbm.gz > $xbmfile
    } else {
      set xbmfile "$hlp_dir${filedir}.xbm"
    }
    set w .tsxbm$hlp_cbm;    if {[winfo exists $w]} {destroy $w}
    toplevel $w
    wm title $w "$vv(tshlp) $file";          wm iconname $w "$file"
    wm minsize $w 15 10;           wm geometry $w =$hlp_wgmdxy
    frame     $w.1
    pack      $w.1 -in $w -anchor nw
    button    $w.1.e -text "$vv(ae)" -command "destroy $w"
    pack      $w.1.e -in $w.1 -pady 2 -side left
    label     $w.1.l -text "$vv(tsex)"
    pack      $w.1.l -in $w.1 -padx 10 -side left
    scrollbar $w.sb -command "$w.bm yview" -relief sunken
    pack      $w.sb -in $w -side right -fill y
    canvas    $w.bm -yscroll "$w.sb set" -relief raised -borderwidth 1 -width $hlp_wgmx
    pack      $w.bm -in $w -side left -fill both -expand yes
    $w.bm create bitmap 2 2 -bitmap "@$xbmfile" -anchor nw -tags item
    $w.bm config -scrollregion [$w.bm bbox all]
    if {$xbmfile==".xtem_hlpxbm$hlp_cbm"} {unlink -nocomplain $xbmfile}

  } elseif {[file exists $hlp_dir${filedir}.dvi]} {#bitmap doesn't exist, but dvi exists
    set x [expr $hlp_wgmx+100]
    set hlp_pid "$hlp_pid [exec xdvi $hlp_dir${filedir}.dvi \
                      -geometry ${x}x400$hlp_wgmdxy -sidemargin 4.0cm -topmargin 4.3cm &]"

  } else {# neither bitmap nor dvi exists
    hlpwin_insertinline $w \
        "\n$vv(tsbtm) $hlp_dir$filedir\n" normal
  }

}

proc hlpwin_delbitmaps {} {

  global hlp_pid hlp_cbm

  foreach i [string trim $hlp_pid] {killprocess $i}
  for {set i 1} {$i<=$hlp_cbm} {incr i} {if {[winfo exists .tsxbm$i]} {destroy .tsxbm$i}}
  set hlp_pid "";  set hlp_cbm 0

}

proc hlpwin_refreshbitmaps {w} {

  global hlp_bmlist hlp_thisbm

  hlpwin_delbitmaps
  set hlp_thisbm 1;  foreach i $hlp_bmlist {hlpwin_bitmap $w $i};  set hlp_thisbm 0

}

proc hlpwin_fillfile {w filedir entry} {# read+analyze help-file, fill into window w

  global  vv hlp_dir hlp_c hlp_cnr hlp_tnr hlp_font hlp_line hlp_stack hlp_filedir hlp_undline

  if {![info exists hlp_font(normal)]} \
    {set hlp_font(normal)         "-*-New Century Schoolbook-Medium-R-Normal-*-120-*"}
  if {![info exists hlp_font(bold)]} \
    {set hlp_font(bold)           "-*-New Century Schoolbook-Bold-R-Normal-*-120-*"}
  if {![info exists hlp_font(boldlrge)]} \
    {set hlp_font(boldlrge)       "-*-New Century Schoolbook-Bold-R-Normal-*-140-*"}
  if {![info exists hlp_font(telelrge)]} \
    {set hlp_font(telelrge)       "-*-Terminal-Medium-R-Normal-*-140-*"}
  if {![info exists hlp_font(teletype)]} \
    {set hlp_font(teletype)       "lucidasanstypewriter-12"}
  if {![info exists hlp_font(telesmll)]} \
    {set hlp_font(telesmll)       "lucidasanstypewriter-10"}
  if {![info exists hlp_font(italic)]} \
    {set hlp_font(italic)         "-*-New Century Schoolbook-Medium-I-Normal-*-120-*"}
  if {![info exists hlp_font(tag)]} \
    {set hlp_font(tag)            "$hlp_font(normal)"}
 #set hlp_font(helvbold)       "-*-Helvetica-Bold-R-Normal-*-120-*"
 #set hlp_font(courier)        "-*-Courier-Medium-R-Normal-*-120-*"
 #set hlp_font(courierl)       "-*-Courier-Medium-R-Normal-*-140-*"
 #set hlp_font(courierboldl)   "-*-Courier-Bold-R-Normal-*-140-*"
 #set hlp_font(fixbold)        "-*-Fixed-Bold-R-Normal-*-120-*"
 #set hlp_font(edit)           "-*-Courier-Medium-R-Normal-*-120-*"
  $w tag configure normal -font $hlp_font(normal)
  $w tag configure italic -font $hlp_font(italic)
  $w tag configure bold -font $hlp_font(bold)
  $w tag configure boldlrge -font $hlp_font(boldlrge)
  $w tag configure title -font $hlp_font(boldlrge)
  $w tag configure teletype -font $hlp_font(teletype)
  $w tag configure telelrge -font $hlp_font(telelrge)
  $w tag configure telesmll -font $hlp_font(telesmll)
  $w tag configure tag -font $hlp_font(tag)

  set uline "___________________________________________________________________"
  set hlp_cnr 0; set hlp_tnr 0; set type normal; set hlp_undline 0; set evaluate 0;
  hlpwin_delbitmaps
  set fid [open "${hlp_dir}${filedir}.htx" r]
  while {[getscl0 $fid line]!=-1 && [string trim $line]!="@eof"} {
    set l [string trim $line]; set p [string first " " $l]
    if {$p>0} {set first [crange $l 0 $p-1]} else {set first $l}
    set eoltext "\n"; set ctype $type

    if       {$first == "@entries"} {# skip entry line
      set eoltext "";   set hlp_line ""

    } elseif {$first == "@title"} {# prepare title
      set eoltext ""
      set eoltext "${eoltext}\n$uline\n"; set ctype boldlrge;  set hlp_line [crange $line  7 end]; 

    } elseif {$first == "@update"} {# update screen
      set eoltext ""; update

    } elseif {$first == "@section"} {# prepare section-title
      set eoltext "\n"; set ctype bold;     set hlp_line [crange $line  9 end]

    } elseif {$first == "@bitmap"} {# prepare bitmap
      set eoltext "";  set hlp_line ""
      set f ""; set p [string last "/" $filedir]; if {$p>=0} {set f "[crange $filedir 0 $p]"}
      hlpwin_bitmap "$w" "$f[crange $line  8 end]";

     } elseif {$first == "@begdescription"} {# prepare description
      set eoltext "\n"; lvarpush typestack $type; set type normal;  set ctype bold
      set hlp_line "$vv(tsdes)"
    } elseif {$first == "@enddescription"} {#
      set eoltext "";   set type [lvarpop typestack]

    } elseif {$first == "@begteletype"} {# prepare teletype
      set eoltext ""; lvarpush typestack $type; set type teletype; set ctype $type
    } elseif {$first == "@endteletype"} {#
      set eoltext "";   set type [lvarpop typestack]

    } elseif {$first == "@begsyntax"} {# prepare syntax description
      set eoltext "\n"; lvarpush typestack $type; set type teletype; set ctype bold
      set hlp_line "$vv(tssyn)"
    } elseif {$first == "@endsyntax"} {#
      set eoltext "";   set type [lvarpop typestack]

    } elseif {$first == "@begexamples"} {# prepare examples      
      set eoltext "\n"; lvarpush typestack $type; set type telesmll; set ctype bold
      set hlp_line "$vv(tsexa)"
    } elseif {$first == "@endexamples"} {#
      set eoltext "";   set type [lvarpop typestack]
      if {[lindex $line 1]!="no_bitmap"} {hlpwin_bitmap "$w" "$filedir"}

    } elseif {$first == "@begeval"} {# starts evaluation of each text-line before output
      set eoltext "";  set evaluate 1
    } elseif {$first == "@endeval"} {# ends   evaluation of each text-line before output
      set eoltext "";  set evaluate 0

    } else {
      set hlp_line $line
    }
    if {$evaluate} {eval set hlp_line "\"$hlp_line\""}
#puts stdout "***<$hlp_line>"; flush stdout;#####@@@@@
    while {$hlp_line != ""} {hlpwin_insertinline $w [hlpwin_strpart] $ctype}
    $w insert insert "$eoltext";  set eoltext "\n"
    # the following line must be done "in retard" because of an Tk-error (Tcl version 3.6)
    for {set i 1} {$i<=$hlp_cnr} {incr i} {set res [eval $hlp_c($i)]}; # exec tag commands
#for {set i 1} {$i<=$hlp_cnr} {incr i} {puts stdout "Tag:$hlp_c($i)"; flush stdout};#####@@@@@
    set hlp_cnr 0
  }  
  close $fid
}


proc hlpwin_insertinline {w text type} {# fills text t into window w with font type

  global  hlp_line  hlp_c hlp_cnr hlp_tnr hlp_bdw hlp_undline hlp_font hlp_fgr hlp_bgr

#puts stdout "*  insertinline: <$type><$text>"; flush stdout;#####@@@@@
  set pf [string first "@@" $text];# look for inline-command
  if       {$pf<0} {# "text" contains no inline-command
    set tp1 [$w index insert]; $w insert insert "$text"; set tp2 [$w index insert]
    if {$hlp_undline} {$w tag configure underline -font $hlp_font($type) -underline on;
                       set type underline}
    incr hlp_cnr; set hlp_c($hlp_cnr) "$w tag add $type $tp1 $tp2"
  } elseif {$pf>0} {# "text" starts with normal text, followed by inline-command
    set string [crange $text 0 $pf-1]
    set tp1 [$w index insert]; $w insert insert "$string"; set tp2 [$w index insert]
    incr hlp_cnr; set hlp_c($hlp_cnr) "$w tag add $type $tp1 $tp2"
    hlpwin_insertinline $w [crange $text $pf end] $type
  } else           {# "text" starts with inline-command
    set com  [lindex $text 0];   set l [string length $com]
    set text [string trimleft [crange $text $l+1 end]]
    set arg  [lindex $text 0];   set l [string length $arg]
    if {[string first "\{" $text]==0} {
      set rest [crange $text $l+3 end]
    } else { 
      set rest [crange $text $l+1 end]
    }
#puts stdout "   zerlegt1:     <$com><$arg><$rest>"; flush stdout;#####@@@@@
    if {$com=="@@linktag"} {# prepare LinkTag
      set hlp_bdw 1; set hlp_undline 0
      if {[regsub "@@bdw" $arg "" arg]} {
        set hlp_bdw [string index $arg 0]; set arg [crange $arg 2 end]
        if {$hlp_bdw=="_"} {set hlp_bdw 0; set hlp_undline 1}
      }
      set arg  [string trimleft $arg]
      set tdir [lindex "$arg" 0];   set l [string length $tdir]
      set arg  [string trimleft [crange $arg $l+1 end]]
      set tent [list [lindex "$arg" 0]];   set l [string length $tent]
      set t    [crange "$arg" $l+1 end]
      if {[string first "\{" $t]==0} {set t [lindex $t 0]} else {set t [crange $t 0 end]}
#puts stdout "   zerlegt2:     <$tdir><$tent><$t>"; flush stdout;#####@@@@@
      set tp1 [$w index insert]
      hlpwin_insertinline $w "$t" tag;      set tp2 [$w index insert]
      incr hlp_cnr; incr hlp_tnr;              set hlp_c($hlp_cnr) \
       "$w tag configure $hlp_tnr -relief raised -borderwidth $hlp_bdw -background bisque"
      incr hlp_cnr; set hlp_c($hlp_cnr) "$w tag add $hlp_tnr $tp1 $tp2"
      incr hlp_cnr;                            set hlp_c($hlp_cnr) \
        "$w tag bind $hlp_tnr <ButtonRelease-1> \"hlpwin_fill $w $tdir $tent\""
      incr hlp_cnr;                            set hlp_c($hlp_cnr) \
        "$w tag bind $hlp_tnr <Leave> \"$w tag configure $hlp_tnr -foreground $hlp_fgr \
                                                                  -background $hlp_bgr\""
      incr hlp_cnr;                            set hlp_c($hlp_cnr) \
        "$w tag bind $hlp_tnr <Enter> \"$w tag configure $hlp_tnr -foreground $hlp_bgr \
                                                                  -background $hlp_fgr\""
      set hlp_undline 0
    } elseif {($com=="@@tt") || ($com=="@@ts") || ($com=="@@tl") || ($com=="@@em") || \
              ($com=="@@bf") || ($com=="@@bl") || ($com=="@@rm")} {
              if     {$com=="@@tt"}   {set ctype teletype} \
              elseif {$com=="@@tl"}   {set ctype telelrge} \
              elseif {$com=="@@ts"}   {set ctype telesmll} \
              elseif {$com=="@@em"}   {set ctype italic} \
              elseif {$com=="@@bf"}   {set ctype bold} \
              elseif {$com=="@@bl"}   {set ctype boldlrge} \
              elseif {$com=="@@rm"}   {set ctype normal} \
              else                    {set ctype normal}
      hlpwin_insertinline $w "$arg" $ctype
    } else {# is not an implemented inline-command!
      puts stdout "*** Error: inline-command \"$com\" not implemented!"; flush stdout; bell
    }
    if {$rest!=""} { hlpwin_insertinline $w "$rest" $type}
  }
}


proc hlpwin_strpart {} {# returns next part of "hlp_line":
#                            pure text up to next inline-command        or
#                            inline-command together with its argument
  global hlp_line

  set pf [string first "@@" "$hlp_line"]
  if       {$pf<0} {# no inline-command
    set strpart $hlp_line; set hlp_line ""
  } elseif {$pf==0} {# starts with inline command
    # gives the command, deletes it from "hlp_line"
      set strpart [lindex $hlp_line 0]; set l [string length $strpart]
      set hlp_line [crange $hlp_line $l+1 end]
    # cut first list element from "hlp_line" and gives its content
    # first (separating) blank after listelement is deleted!
      set hlp_line [string trim $hlp_line]
      set listel [lrange $hlp_line 0 0];   set l [string length $listel]
      set hlp_line [crange $hlp_line $l+1 end]
      set strpart "$strpart $listel"
  } else   {# $pf>0 --> starts with pure text, followed by inline-command
    set strpart [crange $hlp_line 0 $pf-1]
    set hlp_line [crange $hlp_line $pf end]
  }
#puts stdout "** Ausgabe: <$strpart> Rest: <$hlp_line>"; flush stdout;#####@@@@@
  return $strpart
}


global  vv hlp_dir hlp_stack hlp_width hlp_fgr hlp_bgr hlp_pid hlp_cbm hlp_bmsuppr hlp_thisbm

if {[winfo exists .ts]} {raise .ts; return}

toplevel .ts
wm title .ts "$vv(tsvor)"
wm minsize .ts 15 10
wm geometry .ts =+0+0
set hlp_pid ""; set hlp_cbm 0

# Bereich fr erste Buttons
frame .ts.a -relief raised -borderwidth 1
pack configure .ts.a -in .ts -pady 2 -anchor w

frame .ts.a.1
frame .ts.a.2
frame .ts.a.3
frame .ts.a.4
pack configure .ts.a.1 .ts.a.2 .ts.a.3 .ts.a.4 -in .ts.a -pady 2 -side left -anchor n

button .ts.a.1.e -text "$vv(ae)" -command {destroy .ts; hlpwin_delbitmaps; set texfmtts ""}
bind   .ts.a.1.e <Button-3> {hlpwin_fill $hlp_window "miscellaneous/w_end" "end"}
pack configure .ts.a.1.e -in .ts.a.1 -side left -padx 5 -pady 3

button .ts.a.2.t -text "$vv(tsat)" -command {
  global hlp_window; hlpwin_fill $hlp_window "miscellaneous/mainhelp" "mainhelp"
}
bind   .ts.a.2.t <Button-3> {hlpwin_fill $hlp_window "miscellaneous/w_top" "top"}
button .ts.a.2.b -text "$vv(tsab)" -command {
  lvarpop hlp_stack;  lvarpop hlp_stack; global hlp_window
  set filedir [lvarpop hlp_stack]; set entry [lvarpop hlp_stack]
  if {$filedir!="" && $entry!=""} {hlpwin_fill $hlp_window "$filedir" "$entry"}
}
bind   .ts.a.2.b <Button-3> {hlpwin_fill $hlp_window "miscellaneous/w_back" "back"}
pack configure .ts.a.2.t .ts.a.2.b -in .ts.a.2 -side top -anchor w -padx 5 -pady 3

set hlp_thisbm 0
checkbutton .ts.a.3.bm -borderwidth 1 -variable hlp_bmsuppr -text "$vv(tsbm)" -command {
  global hlp_bmsuppr; if {$hlp_bmsuppr} {hlpwin_delbitmaps} {hlpwin_refreshbitmaps $hlp_window}
}
bind   .ts.a.3.bm <Button-3> {hlpwin_fill $hlp_window "miscellaneous/w_bitmap" "bitmap"}
pack configure .ts.a.3.bm -in .ts.a.3 -side top -anchor w -padx 5 -pady 3

button .ts.a.4.r -text "$vv(tsbmr)" -command {hlpwin_refreshbitmaps $hlp_window}
bind   .ts.a.4.r <Button-3> {hlpwin_fill $hlp_window "miscellaneous/w_bitmap_r" "refresh"}
pack configure .ts.a.4.r -in .ts.a.4 -side top -anchor w -padx 5 -pady 3

if {![info exists hlp_width]} {set hlp_width 80 }
scrollbar .ts.sb   -command ".ts.li.t yview" -relief sunken
bind      .ts.sb   <Button-3> {hlpwin_fill $hlp_window "miscellaneous/w_text" "text"}
frame     .ts.li   -relief raised -borderwidth 1 
text      .ts.li.t -yscroll ".ts.sb set" -setgrid true -width $hlp_width -height 32 \
                   -padx 3 -pady 2
bind      .ts.li.t  <Button-3> {hlpwin_fill $hlp_window "miscellaneous/w_text" "text"}
pack      .ts.sb   -in .ts -side left -fill y
pack      .ts.li   -in .ts -side right -fill both -expand yes
pack      .ts.li.t -in .ts.li -side right -fill both -expand yes
global hlp_window;  set hlp_window .ts.li.t
set hlp_fgr [lindex [$hlp_window configure -foreground] 4]
set hlp_bgr [lindex [$hlp_window configure -background] 4]

hlpwin_fill $hlp_window "miscellaneous/mainhelp" "mainhelp"
}
