# TeX run with the file $main_file$tsuff and with the format $texmem$texfmt
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Uni Bremen

proc tex {f austext} {# TeX run: file $main_file$tsuff, format $texfmt   

  upvar 1 $austext a

  global  texfmt main_file tsuff prsuffix texmem texrun texmax 
  global  editor edsubback env vv

  set noedittext "\n$vv(ten1)\n$vv(ten2)\n"


  if { "$texrun" == "1" } {
    writescr0 $f  "[datime] $vv(te1) $texfmt $main_file$tsuff\n"
  } else {# 2th, 3rd, ... run (if max. number of TeX runs > 1)
    writescr  $f  "[datime] $vv(te1) $texfmt $main_file$tsuff\n\n" \
                 "$texrun. $vv(te2)  $texmax  $vv(te3)\n\n"
    bell
  }
  set a ""



#  editor in background: e-option forbidden, except with emacsserver/emacsclient

    if { $edsubback == 0 } {

      unlink -nocomplain .tmp.noedit
      if { $editor == "emacs" } {
        set env(TEXEDIT) "emacs +%d %s"
      } else {
        set env(TEXEDIT) "xterm -e vi +%d %s"
      }

    } else { 
      set env(TEXEDIT) "echo \"$noedittext\";touch .tmp.noedit"
    }

    unlink -nocomplain "${main_file}.dvi ${main_file}.log"

#   call of tex/latex/...

#   either:
         ################################################################
         mkCmd_wait  $f  $texmem$texfmt  [list "$main_file$tsuff"]
         ################################################################

#   or:
         ################################################################
         #set message ""
         #eval set res [catch "exec xterm -e $texmem$texfmt $main_file$tsuff " message]
         #set pid "$message"
         #cat_file ${main_file}.log $f
         #if { [file exists .tmp.noedit] } {set a "${a}$noedittext"} 
         ################################################################


}


proc tex_post {f austext} {# after TeX run: .dvi -> .ps if postscript-preview

  upvar 1 $austext a

  global  main_file prsuffix vv prpreopt

  set a ""

  set message ""
  if { ("$prsuffix" == ".ps") && [file exists $main_file.dvi] } { 
  # Postscript-Previewer, daher .dvi --> .ps
    writescr  $f "\n[datime] dvips $vv(tea3)\n"
    writescr  $f "          $vv(tea4)\n\n"

    #catch "exec dvips $main_file.dvi $prpreopt -o $main_file.ps" message
    #oder:
    mkCmd_wait $f dvips "$main_file.dvi $prpreopt -o $main_file.ps"

  }
  writescr  $f "$message\n[datime] $vv(tea5)\n"
  bell

}
