# Voreinstellungsmen fr Preview   
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Uni Bremen

proc prv_select {s1 s2} {# get options after selection according to 
                         # s1 (== prtext, prformat) and 
                         # s2 (!= "" if format is to be changed to "s2")
                         # return 1 if selection successfull, 0 otherwise
  global  vv pvsep prtext preview prsuffix proptions prformat prback prpreopt 
  global  prvfmtli

  if {![info exists pvsep]} {# read first line, get separator from it
    set foid [open_vst preview.vst]
    getscl $foid ein;  set pvsep [string index [string trim $ein] 0]
    close $foid
  }

  set k [string trim [string range $s1 1 [expr [string length $s1]-2]]]
  set p [string last "," $k]
  set txt [string trim [string range $k 0 [expr $p-1]]]
  set fmt [string trim [string range $k [expr $p+1] end]]
  set foid [open_vst preview.vst]
  getscl $foid ein; # skip first line
  set selected 0
  while {[getscl $foid ein] > 0} {
    set z [split $ein $pvsep]
    if {[string trim [lindex $z 0]]==$txt} {# preview found
      set preview_     [string trim [lindex $z 1]]
      set prsuffix_    [string trim [lindex $z 2]]
      set proptions_   [string trim [lindex $z 3]]
      set sn [split [string trim [lindex $z 4]] ","]
      set prvfmtli ""
      foreach i $sn {# set list of all possible formats for this previewer
        regsub -all "\{" $i " \{" lien
        set prvfmtli "$prvfmtli [lindex $lien 0]"
      }
      foreach i $sn {# process formats for a distinct previewer until found
        regsub -all "\{" $i " \{" lien
        set fmt [lindex $lien 0]
        if {("$fmt"=="$prformat")} {# (old) format is found
	  if {$s2 == ""} {
            set prpreopt_ "[lindex $lien 1]"
            set proptions_ "$proptions_ [lindex $lien 2]"
            set selected 1; break
	  } else {# format change is demanded; look for new format hit
            foreach j $sn {
              regsub -all "\{" $j " \{" lien
              set fmt [lindex $lien 0]
              if {("$fmt"=="$s2")} {# new format hit
                set prpreopt_ "[lindex $lien 1]"
                set proptions_ "$proptions_ [lindex $lien 2]"
                set prformat "$s2"
                set selected 1; break
              }
            }
            if {$selected} {break}
          }
        }
      }
      if {$selected} {break}
    }
  }
  close $foid
  if {![info exists prvmftli]} \
            {set prvfmtli \n$vv(pvns1)\n$vv(pvns2)\n$vv(xt32)\n$vv(xt33)\n}
  if {$selected} {
    set prtext      $txt
    set preview     $preview_
    set prsuffix    $prsuffix_
    set proptions   $proptions_
    set prpreopt    $prpreopt_
    progback  preview prback
    if {[winfo exists .pv]} {
      .pv.cb delete 0 end
      .pv.cb insert end "$proptions"
      pvanzeige;  if {"$s2" == ""} {pvanzeigen "$vv(pv5)"}
    }
  }
  if {$selected} {return 1} else {return 0}
}


proc pvanzeige {} {
  global vv preview prback prtext prformat
  if {$preview == ""} {
    .pv.b.ad configure -text "$vv(pvbad1)" 
  } else {
    .pv.b.ad configure -text "$vv(pvbad2)   $prtext, $prformat"
  }
}

proc pvanzeigen {s1} {
  global vv prtext prformat preview prback prsuffix prpreopt proptions
  writescr0 .pv.d.tt "$s1\n\n" \
                     "$prtext, $prformat\n\n" \
                     " $vv(pv2) $preview$prback\n" \
                     " $vv(pv3) $prsuffix\n" \
                     " $vv(pv7) $prpreopt\n" \
                     " $vv(pv4) $proptions\n" \
                     " $vv(pv6) $prformat\n"
}


proc pv  {} {

global  vv hlp_dir pvsep 
global  preview prback prsuffix proptions prtext prformat prvformat prpreopt


toplevel .pv
wm title .pv "$vv(pvvor)"
wm minsize .pv 0 0


set tyh 18


proc prvlistfill {} {#fills the "preview list" in the "preview setting menu" by
                     #reading file "preview.vst",respecting variable "prvformat"
  global  pvsep prvformat

  set foid [open_vst preview.vst]
  # read first line, get separator from it
  getscl $foid ein;  set pvsep [string index [string trim $ein] 0]
  # read 2. and following lines
  .pv.c.1.fr.li delete 0 end;  .pv.c.2.fr.li delete 0 end
  set fmtl ""; set fmtla 0
  while {[getscl $foid ein] > 0} {
    set z [split $ein $pvsep]
    set sn [split [string trim [lindex $z 4]] ","]
    foreach i $sn {
      regsub -all "\{" $i " \{" lien
      set fmt [lindex $lien 0]
      if {[string first $fmt $fmtl] < 0} {set fmtl "$fmtl $fmt"; incr fmtla}
      if {("$fmt"=="$prvformat")} {
        .pv.c.1.fr.li insert end "[string trim [lindex $z 0]], $prvformat"
      }
    }
  }
  set fmtl [lsort $fmtl]
  foreach i $fmtl {.pv.c.2.fr.li insert end "$i"}
  close $foid
}

proc prfmtwahl {fmtneu} {
  global  vv  main_file sub

  writescr0 .pv.d.tt ""
  set subalt $sub; exec touch $main_file.dvi; lock; set sub $subalt
  format_switch  .pv.d.tt  "$fmtneu"  3
}



# Bereich a fuer erste Buttons

frame .pv.a -relief raised -borderwidth 1
pack configure .pv.a -in .pv -pady 10 -anchor w
 
button .pv.a.e -text "$vv(ae)"
bind   .pv.a.e <Button-3>   {+ cat_file0 "${hlp_dir}z_vstquit.hlp" .pv.d.tt}
button .pv.a.h -text "$vv(ah)" 
bind   .pv.a.h <Any-Button> {+ cat_file0 "${hlp_dir}pv_h.hlp" .pv.d.tt}
button .pv.a.l -text "$vv(al)" -command {clearscr .pv.d.tt}
bind   .pv.a.l <Button-3>  {+ cat_file0 "${hlp_dir}z_loeschetf.hlp" .pv.d.tt}
button .pv.a.g -text "$vv(ag)" -command {
  set foid [open_vst default.vst]
  while {[getscl $foid ein] > 0} {
   mtest $ein 19 preview
   mtest $ein 19 prtext
   mtest $ein 19 prsuffix
   mtest $ein 19 proptions
   mtest $ein 19 prpreopt
   mtest $ein 19 prformat
  }
  progback  preview prback
  close $foid
  .pv.cb delete 0 end
  .pv.cb insert end "$proptions"
  pvanzeige;   pvanzeigen "$vv(ausg1)"
  set prvformat $prformat
  prvlistfill
}
bind   .pv.a.g <Button-3>   {+ cat_file0 "${hlp_dir}pv_grund.hlp" .pv.d.tt}
pack configure .pv.a.e .pv.a.h .pv.a.l .pv.a.g -in .pv.a -side left -padx 3 -pady 3


# Bereich bv fuer eigene Einstellungen

frame .pv.bv
pack configure .pv.bv -in .pv -pady 13 -anchor w

label   .pv.bv.dv -text "$vv(bvdv)"  -width 23 -anchor w
bind    .pv.bv.dv <Button-3> {+ cat_file0 "${hlp_dir}z_voreinst1.hlp" .pv.d.tt}
button  .pv.bv.va -text "$vv(bvva)" -command {pvanzeigen "$vv(aus0)"}
bind  .pv.bv.va <Button-3> {+ cat_file0 "${hlp_dir}z_voreinst1.hlp" .pv.d.tt}
pack configure .pv.bv.dv .pv.bv.va -in .pv.bv -side left


# Bereich b fuer Anzeigen   

frame .pv.b
pack configure .pv.b -in .pv -anchor w

label .pv.b.ad -width 80 -anchor w
bind  .pv.b.ad <Button-3> {+ cat_file0 "${hlp_dir}pv_anzeig.hlp" .pv.d.tt}
pack configure .pv.b.ad  -in .pv.b
pvanzeige

# Bereich c fuer Wechsel   

frame .pv.c
pack configure .pv.c -in .pv -anchor w

# Bereich c1 fuer Preview-Auswahl
    
frame .pv.c.1
pack configure .pv.c.1 -in .pv.c -side left

label  .pv.c.1.dl -text "$vv(pvc1dl)"
bind   .pv.c.1.dl <Button-3> {+ cat_file0 "${hlp_dir}pv_prevsel.hlp" .pv.d.tt}
frame  .pv.c.1.fr -relief raised -borderwidth 2 
pack configure .pv.c.1.dl .pv.c.1.fr -in .pv.c.1 -anchor w

scrollbar .pv.c.1.fr.sb -command ".pv.c.1.fr.li yview"
bind   .pv.c.1.fr.sb <Button-3> {+ cat_file0 "${hlp_dir}pv_prevsel.hlp" .pv.d.tt}
listbox   .pv.c.1.fr.li -yscroll ".pv.c.1.fr.sb set" -geometry 52x8
bind   .pv.c.1.fr.li <Button-3> {+ cat_file0 "${hlp_dir}pv_prevsel.hlp" .pv.d.tt}
bind   .pv.c.1.fr.li <Triple-Button-1> {}
bind   .pv.c.1.fr.li <Double-Button-1> {
  set ii [catch {selection get} k]
  if {!$ii} {prv_select "$k" ""} else {writescr0 .dv.d.tt "\n $vv(el)\n\n"; bell  selection clear .pv.c.1.fr.li
}
}
pack configure .pv.c.1.fr.sb .pv.c.1.fr.li -in .pv.c.1.fr -side right -fill y

# Bereich c2 fuer Formatwechsel
    
frame .pv.c.2
pack configure .pv.c.2 -in .pv.c -anchor e -padx 15

label .pv.c.2.dl -text "$vv(pvc2dl)"
bind  .pv.c.2.dl <Button-3> {+ cat_file0 "${hlp_dir}pv_fmtvsel.hlp" .pv.d.tt}
frame .pv.c.2.fr -relief raised -borderwidth 2 
pack configure .pv.c.2.dl .pv.c.2.fr -in .pv.c.2 -anchor w

scrollbar .pv.c.2.fr.sb -command ".pv.c.2.fr.li yview"
bind  .pv.c.2.fr.sb <Button-3> {+ cat_file0 "${hlp_dir}pv_fmtsel.hlp" .pv.d.tt}
listbox   .pv.c.2.fr.li -yscroll ".pv.c.2.fr.sb set" -geometry 22x8
bind  .pv.c.2.fr.li <Button-3> {+ cat_file0 "${hlp_dir}pv_fmtsel.hlp" .pv.d.tt}
bind  .pv.c.2.fr.li <Triple-Button-1> {}
bind  .pv.c.2.fr.li <Double-Button-1> {foreach i [selection get] {prfmtwahl $i}}
pack configure .pv.c.2.fr.sb .pv.c.2.fr.li -in .pv.c.2.fr -side right -fill y

prvlistfill


# Ausgabe und Veraendern des Optionen-Strings

label .pv.ca -text "$vv(pvca)"
bind  .pv.ca <Button-3> {+ cat_file0 "${hlp_dir}pv_optedi.hlp" .pv.d.tt}
pack configure .pv.ca -in .pv -anchor w

entry .pv.cb -width 80 -relief sunken
      .pv.cb delete  0 end
      .pv.cb insert end "$proptions"
bind  .pv.cb <Button-3> {+ cat_file0 "${hlp_dir}pv_optedi.hlp" .pv.d.tt}
bind  .pv.cb <Return> {
  set proptions  [.pv.cb get] 
  writescr0 .pv.d.tt "$vv(aus4)\n $proptions\n"
  focus none
}
pack configure .pv.cb -in .pv -anchor w
focus none


# Bereich d fuer Hilfe-Ausgaben

frame .pv.d -relief raised -borderwidth 2
pack configure .pv.d -in .pv -anchor sw -pady 6

scrollbar .pv.d.sb -command ".pv.d.tt yview"
bind      .pv.d.sb <Button-3> {+ cat_file0 "${hlp_dir}z_textfeld.hlp" .pv.d.tt}
text      .pv.d.tt -yscroll ".pv.d.sb set" -height $tyh
bind      .pv.d.tt <Button-3> {+ cat_file0 "${hlp_dir}z_textfeld.hlp" .pv.d.tt}
pack configure .pv.d.sb .pv.d.tt -in .pv.d -side right -fill y
.pv.d.tt configure -state disabled

}
