# previewing  of the file $efile with the previewer $preview   
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Uni Bremen

proc preview {f austext} {

  upvar 1 $austext a

  global  vv preview prback proptions prformat main_file prsuffix pid prpreopt

  set a ""
  writescr0 $f "[datime] $vv(pr1) $main_file$prsuffix\n"


  if { "$main_file" == "" } {set a "${a}***** $vv(ea1)\n"; bell; return}


  if { "$prsuffix" == ".ps" } {# postscript preview: recreate postscript file 

    if { [file exists "$main_file.ps"] } { # postscript file exists

      if { [file exists "$main_file.dvi" ]} {
        if { [file mtime "$main_file.dvi"] > [file mtime "$main_file.ps"] } {
          writescr $f "$vv(pr2) dvips $main_file.dvi $prpreopt -o $main_file.ps\n"
          mkCmd_wait $f dvips "$main_file.dvi $prpreopt -o $main_file.ps"
        }
      } 

    } else {  # postscript file doesn't exist

      if { [file exists "$main_file.dvi"] } { # .dvi file exists

        writescr $f "$vv(pr3) dvips $main_file.dvi $prpreopt -o $main_file.ps\n"
        mkCmd_wait $f dvips "$main_file.dvi $prpreopt -o $main_file.ps"
 
      } else {    # .dvi file doesn't exist either

        writescr $f "\n***** $vv(pr4) $main_file.ps $vv(pr5) " \
                   "$main_file.dvi)!\n$vv(pr6)\n"
        bell
        return

      }
    }

  }


  if { [file exists "$main_file$prsuffix"] } {
 
    set a "${a}[datime] $preview $vv(pr7)\n"
 
    set message ""
    eval set res [catch "exec $preview $proptions $main_file$prsuffix $prback" message]
    set pid "$message"

    set a "${a}$message\n"
    if {$res != 0} {set a "${a}$vv(pr8)=$res\n"}

  } else {

    set a "${a}\n\n***** $vv(pr9) $main_file$prsuffix $vv(ea4)\n"
    set a "${a}$vv(pr6)\n"
    bell

  }

}
