# logfile $main_file$lsuff displayed wit command $logform    
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Uni Bremen

proc logfile {f austext} {

  upvar 1 $austext a

  global  vv logform logback logxterm logoptions main_file lsuff pid

  writescr0 $f ""
  set a ""

  if { "$main_file" == "" } {set a "${a}***** $vv(ea1)\n"; bell; return}

  writescr $f "[datime] $vv(lo1) $main_file$lsuff\n"


  if { [file exists $main_file$lsuff] } { 

    if { [file isfile $main_file$lsuff] } { # displaying:

      if       { $logform == "cat" } {# cat ---> xtem text display window

        cat_file $main_file$lsuff $f       

      } else {

        # "logform" builds its own window (e.g. emacs) or "logform" is called
        # in an xterm window (e.g. vi), depending on variable "logxterm"
        eval set res [catch "exec $logxterm $logform $logoptions \
                                            $main_file$lsuff $logback" message]
        set pid "$message"

      }

    } else {                                 # is no regular file!

     set a "${a}***** $vv(aus5) \"$main_file$lsuff\"  $vv(aus6)\n"
     bell

    }

  } else {                                 # logfile deosn't exist!

   set a "${a}***** $vv(lo4) \"$main_file$lsuff\" $vv(lo5)\n"

   bell

  }

}
