# Voreinstellungsmen fr Index-Erstellung
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Uni Bremen

proc ivanzeigen {s1} {
  global vv intext index inoptions
  writescr0 .iv.d.tt "$s1\n\n" \
                     "$intext\n\n" \
                     " $vv(ausg2)  $index\n" \
                     " $vv(ausg3)  $inoptions\n\n"
}


proc iv  {} {

global  vv hlp_dir index intext inoptions ivsep


toplevel .iv
wm title .iv "$vv(ivvor)"
wm minsize .iv 0 0


set tyh 18


# Bereich a fuer erste Buttons

frame .iv.a -relief raised -borderwidth 1
pack configure .iv.a -in .iv -pady 10 -anchor w
 
button .iv.a.e -text "$vv(ae)"
bind   .iv.a.e <Button-3> {+ cat_file0 "${hlp_dir}z_vstquit.hlp" .iv.d.tt}

button .iv.a.h -text "$vv(ah)" 
bind   .iv.a.h <Any-Button> {+ cat_file0 "${hlp_dir}iv_h.hlp" .iv.d.tt}

button .iv.a.l -text "$vv(al)" -command {clearscr .iv.d.tt}
bind   .iv.a.l <Button-3> {+ cat_file0 "${hlp_dir}z_loeschetf.hlp" .iv.d.tt}

button .iv.a.g -text "$vv(ag)" -command {
  set foid [open_vst default.vst]
  while { [getscl $foid ein] > 0 } {
    mtest $ein 19 index
    mtest $ein 19 intext
    mtest $ein 19 inoptions
  }
  close $foid
  if {$index == ""} {
    .iv.b.ad configure -text "kein Index-Programm eingestellt" 
  } else {
    .iv.b.ad configure -text "Index-Programm:  $index    $intext"
  }
  .iv.cb delete 0 end
  .iv.cb insert end "$inoptions"
  ivanzeigen "$vv(ausg1)"
}
bind   .iv.a.g <Button-3> {+ cat_file0 "${hlp_dir}iv_grund.hlp" .iv.d.tt}

pack configure .iv.a.e .iv.a.h .iv.a.l .iv.a.g -in .iv.a -side left -padx 3 -pady 3


# Bereich bv fuer eigen Einstellungen

frame .iv.bv
pack configure .iv.bv -in .iv -pady 13 -anchor w

label  .iv.bv.dv -text "$vv(bvdv)" -width 23 -anchor w
bind   .iv.bv.dv <Button-3> {+ cat_file0 "${hlp_dir}z_voreinst1.hlp" .iv.d.tt}

button .iv.bv.va -text "$vv(bvva)" -command {ivanzeigen "$vv(aus0)"}
bind   .iv.bv.va <Button-3> {+ cat_file0 "${hlp_dir}z_voreinst1.hlp" .iv.d.tt}

pack configure .iv.bv.dv .iv.bv.va -in .iv.bv -side left


# Bereich b fuer Anzeigen   

frame .iv.b
pack configure .iv.b -in .iv -anchor w

label .iv.b.ad -width 90 -anchor w
if {$index == ""} {
  .iv.b.ad configure -text "$vv(ivbad1)" 
} else {
  .iv.b.ad configure -text "$vv(ivbad2)  $index    $intext"
}
bind  .iv.b.ad <Button-3> {+ cat_file0 "${hlp_dir}iv_anzeig.hlp" .iv.d.tt}
pack configure .iv.b.ad -in .iv.b


# Bereich c fuer Index-Programm-Auswahl

frame .iv.c
pack configure .iv.c -in .iv -anchor w

label .iv.c.l -text "$vv(ivcl) " -anchor w
bind  .iv.c.l <Button-3> {+ cat_file0 "${hlp_dir}iv_progsel.hlp" .iv.d.tt}
frame .iv.c.fr -relief raised -borderwidth 2 
pack configure .iv.c.l .iv.c.fr -in .iv.c -side left

scrollbar .iv.c.fr.sb -command ".iv.c.fr.li yview"
bind      .iv.c.fr.sb <Button-3> {+ cat_file0 "${hlp_dir}iv_progsel.hlp" .iv.d.tt}
listbox   .iv.c.fr.li -yscroll ".iv.c.fr.sb set" -geometry 55x10
set ivsep [fillboxsep .iv.c.fr.li index.vst]
bind      .iv.c.fr.li <Triple-Button-1> { }
bind      .iv.c.fr.li <Double-Button-1> {
  global ivsep
  foreach i [selection get] {set ii $i}
  set intext     [getvalue $ii 0 $ivsep]
  set index      [getvalue $ii 1 $ivsep]
  set inoptions [getvalue $ii 2 $ivsep]
  .iv.cb delete 0 end 
  .iv.cb insert end "$inoptions"
  .iv.b.ad configure -text "$vv(ivbad2) $index    $intext"
  ivanzeigen "$vv(iv1)"
  selection clear .iv.c.fr.li
}
bind      .iv.c.fr.li <Button-3> {+ cat_file0 "${hlp_dir}iv_progsel.hlp" .iv.d.tt}
pack configure .iv.c.fr.sb .iv.c.fr.li -in .iv.c.fr -side right -fill y


# Ausgabe und Veraendern des Optionen-Strings

label .iv.ca  -anchor w -text "$vv(ivca)"
bind  .iv.ca <Button-3> {+ cat_file0 "${hlp_dir}iv_optedi.hlp" .iv.d.tt}
pack configure .iv.ca -in .iv -anchor sw

entry .iv.cb -width 80 -relief sunken
      .iv.cb delete 0 end 
      .iv.cb insert end "$inoptions"
bind  .iv.cb <Button-3> {+ cat_file0 "${hlp_dir}iv_optedi.hlp" .iv.d.tt}
bind  .iv.cb <Return> {
  set inoptions  [string trim [.iv.cb get]]
  writescr0 .iv.d.tt  "$vv(aus4)\n $inoptions\n"
  focus none
}
pack configure .iv.cb -in .iv -anchor nw
focus none


# Bereich d fuer Hilfe-Ausgaben

frame .iv.d -relief raised -borderwidth 2
pack configure .iv.d -in .iv -anchor sw -pady 6
scrollbar .iv.d.sb -command ".iv.d.tt yview"
bind      .iv.d.sb <Button-3> {+ cat_file0 "${hlp_dir}z_textfeld.hlp" .iv.d.tt}
text      .iv.d.tt -yscroll ".iv.d.sb set" -height $tyh
bind      .iv.d.tt <Button-3> {+ cat_file0 "${hlp_dir}z_textfeld.hlp" .iv.d.tt}
pack configure .iv.d.sb .iv.d.tt -in .iv.d -side right -fill y
.iv.d.tt configure -state disabled

}
