#!/usr/local/bin/wishx -f
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Uni Bremen
#
# program to generate the alphabetical index (file Alphabetical_List.htx) 
# starting from the "@entries"-lines in the files "*.htx"
#
############################ Variables to be adjusted as you like ###############################
                   #                                                                            #
set cols 4;        # number of columns                                                          #
                   #                                                                            #
set cpcol 22;      # number of characters/column                                                #
                   #                                                                            #
set font @@ts;     # font-inline-command used for the entries in the alphabetical index list;   #
                   # should be a teletype font                                                  #
                   # (otherwise 2nd, 3rd, ... column wil not be well adjusted), i.e             #
                   #       @@ts : small teletype font                                           #
                   #       @@tt : normal teletype font                                          #
                   #       @@tl : large teletype font                                           #
                   #                                                                            #
#################################################################################################
 
# text inserted at the top of the index list:
 
set text        "@title Alphabetische Liste der LaTeX-Anweisungen \n\n"
set text "${text}In diesem Men kann die Suche fortgesetzt werden durch Anklicken "
set text "${text}der Stichworte in der \n"
set text "${text}folgenden Liste. Auf die Einrahmung wurde hier aus Grnden der "
set text "${text}bersichtlichkeit verzichtet. \n"
set text "${text}Man erkennt die Stichworte jedoch leicht beim berstreichen mit der Maus!\n"

#################################################################################################


proc getscl {foid e} {# filter for call of gets, but line breaks by "\" allowed
#
  upvar 1 $e ein

  set ret [gets $foid z];  set z [string trimright $z]
  set ein "$z"
  set lm1 [expr [string length $z]-1]
  while {($lm1>=0) && ([string last \\ $z]==$lm1)} { 
    set ein [string range $ein 0 [expr [string length $ein]-2]]
    set ret [gets $foid z];  set z [string trimright $z]
    set lm1 [expr [string length $z]-1]
    set ein "$ein$z"
  }
  return $ret
}

set directory "latex"

puts stdout "creates the file \"Alphabetical_List.htx\""
puts stdout "starting from all \"@entries\"-lines"
puts stdout "in the \"*.htx\"-files in this directory \"$directory\""
puts stdout ""

puts stdout "create unsorted list --> \".list_unsorted\" ..."
set index_list ""
set fod [open .list_unsorted w]
foreach i  [exec ls] {# scans file in directory in order to create index_list
  if { [file isfile $i] } {
    if {[string match "*.htx" $i]} {# OK, file is a *.htx-file
      set file [crange $i 0 [string length $i]-5]
      set fid [open $i]
      while {[getscl $fid ein]>0} {set n 0
        if {[lindex $ein $n]=="@entries"} {
          # lindex is not used in the following lines because of possible "\" in $ein!!!
          set ein "[string trim [crange $ein [string first " " $ein] end]] "
          set eintrag [crange $ein 0 [string first " " $ein]]
          while {$eintrag!=" "} {
            puts $fod "$eintrag $file"
            set ein "[string trim [crange $ein [string first " " $ein] end]] "
            set eintrag [crange $ein 0 [string first " " $ein]]
          }
        }
      }
      close $fid
    }
  }
}
close $fod


puts stdout "sort list \".list_unsorted\" --> \".list_sorted\" ..."
exec sort -fd <.list_unsorted >.list_sorted

catch "exec wc .list_sorted" anzt;  set anz [lindex $anzt 0];  # number of index-entries
set lines [expr ($anz+$cols-1)/$cols];                         # number of lines in index


puts stdout "read \".list_sorted\" ($anz/$lines lines) ..."
set fid [open .list_sorted];  set sortlist ""; lappend sortlist "$anz"
while {[getscl $fid ein]>0} {lappend sortlist $ein}
close $fid


puts stdout "create sort \"Alphabetical_List.htx\" ..."
set fod [open Alphabetical_List.htx w]
puts $fod "$text"
for {set l 1} {$l<=$lines} {incr l} {
  for {set c 0} {$c<$cols} {incr c} {
    set ein [lindex $sortlist [expr $l+$lines*$c]]
    set eintrag [string trim [crange $ein 0                         [string first " " $ein]-1 ]]
    set dir     [string trim [crange $ein [string first " " $ein]+1 end                       ]]
    set entry $eintrag;   regsub -all {\\} $entry "" entry;   if {$entry==""} {set entry "\{\}"}
    if {$eintrag!=""} {
      set eintrag [crange "$eintrag                                    " 0 $cpcol-1]
      set linktag "@@linktag \{@@bdw0 $directory/$dir $entry @@ts \{$eintrag\} \}"
      puts $fod "$linktag \\"
    }
  }
  puts $fod ""
  if {[expr $l%10]==0} {puts $fod "@update"}
}
puts $fod "@eof";   close $fod

unlink  .list_unsorted
unlink  .list_sorted

exit
