# Call of the bibliography program for the file $main_file$bsuff
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Uni Bremen

proc bibliogr {f austext} {

  upvar 1 $austext a

  global  vv bibtex bioptions main_file bsuff

  writescr0 $f ""
  set a ""

   if { "$main_file" == "" } {# text output: "no file selected --> go to TeX settings!"
    set a "${a}***** $vv(ea1)\n"
    bell
    return
  }

 writescr $f "[datime] $vv(bib1) \"$main_file\"\n"


  if { [file exists $main_file$bsuff] } { 

    eval mkCmd_wait $f $bibtex [list "$bioptions $main_file"]

  } else {# output text: "file $main_file.aux doesn't exist!\none more LaTeX run with:\n"
    bell
    set a "${a}\n***** $vv(aus5)   $main_file.aux   $vv(ea4)\n      $vv(bib2)\n"
    set a "${a}        \\documentstyle\[...\]\{...\}\n"
    set a "${a}        ...\n"
    set a "${a}        \\begin\{document\}\n"
    set a "${a}          \\bibliographystyle\{plain\}\n"
    set a "${a}        ... \\cite\{...\} ...\n"
    set a "${a}        \\bibliography\{...\}\n"
    set a "${a}        \\end\{document\}\n"
  }

}
